<!-- 

    A copying stylesheet. This expands entities and makes visible the default and fixed attributes.
    
-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:css="http://www.w3.org/1998/CSS" version="2.0" >
    
    <!-- 
        If this is missing Saxon will transform the XHTML 
        input into HTML documents that are not welformed. 
        This would break the pipeline. 
    -->
    <xsl:output method="xml"/>

    <xsl:template match="/*">
        <xsl:copy>
            <!-- We use this attribute to force the processor declare the CSS namespace on the root.
    			 We can declare this namespace directly on the root of the document loaded in the "set style attributes" stage, but it is costly.
    	     -->
            <xsl:attribute name="css:declared-ns" select="true()"/>
            <xsl:apply-templates select="@*"/>
            <xsl:apply-templates select="node()"/>
        </xsl:copy>
    </xsl:template>
    
    <xsl:template match="node() | @*">
        <xsl:copy>
            <xsl:apply-templates select="node() | @*"/>
        </xsl:copy>
    </xsl:template>
    
    <xsl:template match="xi:include" xmlns:xi="http://www.w3.org/2001/XInclude">
      <xsl:apply-templates select="xi:fallback/node()"/>
    </xsl:template>
    
    
    
    
    
     <!-- Template that does not match anything, but avoids Saxon warnings:
        
        SXXP0005: The source document is in no namespace, but the template rules all expect
        elements in a namespace (Use -suppressXsltNamespaceCheck:on to avoid this warning)
        
         -->
    <xsl:template match="/__Chemistry_SXXP0005__">
         <xsl:next-match/>
    </xsl:template>
    
</xsl:stylesheet>
