<?xml version="1.0" encoding="UTF-8"?>
<!-- 
    
    Skips the elements with display none, but creates invisible 
    structures for the ones that have string sets.    
        
-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:css="http://www.w3.org/1998/CSS"
    xmlns:fo="http://www.w3.org/1999/XSL/Format"
    xmlns:oxy="http://www.oxygenxml.com/css2fo"
    xmlns:xs="http://www.w3.org/2001/XMLSchema"
    
    exclude-result-prefixes="fo css oxy xs"
    version="2.0">
    
    <xsl:template match="*[@css:display = 'none']" priority="2">
    	<xsl:apply-templates select="." mode="display-none"/>
    </xsl:template>
    
    <xsl:template match="*|node()" mode="display-none">
        <xsl:apply-templates mode="display-none"/>
    </xsl:template>
    
    <!-- 
    	Also they may define string-sets, that should go into the output.  
   	-->
    <xsl:template match="css:string-set" mode="display-none">

        <!-- Determine the context of the element with display:none, maybe it should generate a block. -->
        <xsl:variable name="display-none-node" select="(ancestor::*[@css:display = 'none'])[1]"/>
        <xsl:variable name="is-in-inline-context" select="oxy:is-in-inline-context($display-none-node)"></xsl:variable>
    	
        <xsl:choose>
        	<xsl:when test="$is-in-inline-context">
        		<fo:inline font-size="0">
        			<xsl:apply-templates select="." mode="#default"/>
        		</fo:inline>
        	</xsl:when>
        	<xsl:otherwise>
        		<fo:block font-size="0">
        			<xsl:apply-templates select="$display-none-node/@css:page-break-after"/>
        			<xsl:apply-templates select="$display-none-node/@css:page-break-before"/>
        			<xsl:apply-templates select="$display-none-node/@css:page-break-inside"/>
        			
        			<xsl:apply-templates select="." mode="#default"/>
        		</fo:block>
        	</xsl:otherwise>
        </xsl:choose>
    
    </xsl:template>
    
    <!-- Checks if the node parameter is sibling with inline elements or text.-->
    <xsl:function name="oxy:is-in-inline-context" as="xs:boolean">
        <xsl:param name="node"/>

        <xsl:variable name="preceding" select="$node/preceding-sibling::node()[1]"/>
        <xsl:variable name="following" select="$node/following-sibling::node()[1]"/>
        <xsl:variable name="parent" select="$node/.."/>
        <xsl:variable name="is-in-inline-context" select="
            $parent/@css:display='inline' or        
            $preceding instance of text() and string-length(normalize-space($preceding)) > 0 or 
            $following instance of text() and string-length(normalize-space($following)) > 0 or
            $preceding instance of element() and $preceding/@css:display='inline' or 
            $following instance of element() and $following/@css:display='inline' or 
            $preceding instance of element() and $preceding/@css:display='inline-block' or 
            $following instance of element() and $following/@css:display='inline-block' 
            "/>
            
        <xsl:sequence select="$is-in-inline-context"/>
    </xsl:function>
    
</xsl:stylesheet>