<?xml version="1.0" encoding="UTF-8"?>
<!-- 
    Generates different FO elements based on the css:display attribute:
    
    css:display="table-cell" -> fo:table-cell
    ...
    
    The more advanced structures, like lists are in separate stylesheets.
        
-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:css="http://www.w3.org/1998/CSS"
    xmlns:fo="http://www.w3.org/1999/XSL/Format"
    exclude-result-prefixes="fo css"
    version="2.0">    
    
    <xsl:template match="*[@css:display]" priority="-1">
        <xsl:message terminate="yes">The display: <xsl:value-of select="@css:display"/> is not yet known.</xsl:message>        
    </xsl:template>
    
</xsl:stylesheet>