<?xml version="1.0" encoding="UTF-8"?>
<!-- 
    Adds the page definitions XML fragment to the intermediate XML.
-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:css="http://www.w3.org/1998/CSS" exclude-result-prefixes="xs css" version="2.0">

    <!-- The XML fragment with the page definitions. Can miss if there are no page definitions. -->
    <xsl:param name="generate-pages" as="xs:boolean" select="false()"/>
    <xsl:param name="pages" as="node()"/>

    <!-- 
        Adds the list of page definitions in the intermediate XML.  
    -->
    <xsl:template match="/*">
    	<xsl:copy>
            <xsl:if test="$generate-pages">
                <xsl:copy-of select="$pages"/>
            </xsl:if>
	        <xsl:copy-of select="*"/>
        </xsl:copy>
    </xsl:template>
    
</xsl:stylesheet>