/*
 * Copyright (c) 2018 Syncro Soft SRL - All Rights Reserved.
 *
 * This file contains proprietary and confidential source code.
 * Unauthorized copying of this file, via any medium, is strictly prohibited.
 */
package org.w3c.flute.parser.selectors.spc;

import org.w3c.flute.css.sac.AttributeCondition;


/**
 * Base class for all the structural pseudo classes conditions.
 * 
 * See http://www.w3.org/TR/css3-selectors/#structural-pseudos
 * 
 * @author dan
 */
public abstract class SPCCondition implements AttributeCondition {
  
  /**
   * The type of the condition:
   * @author dan
   *
   */
  public enum Type{
    /**
     * :first-child
     */
    FIRST_CHILD,
    /**
     * :nth-child
     */
    NTH_CHILD,
    /**
     * :last-child
     */
    LAST_CHILD,
    /**
     * :nth-last-child
     */
    NTH_LAST_CHILD,
    /**
     * :first-of-type
     */
    FIRST_OF_TYPE,
    /**
     * :nth-of-type
     */
    NTH_OF_TYPE,
    /**
     * :last-of-type
     */
    LAST_OF_TYPE,
    /**
     * :nth-last-of-type
     */
    NTH_LAST_OF_TYPE,
    /**
     * :root
     */
    ROOT,    
    /**
     * :empty
     */
    EMPTY, 
    /**
     * :only-child
     */
    ONLY_CHILD,    
    /**
     * :only-of-type
     */
    ONLY_OF_TYPE,    
  }
  
  /**
   * @return the type of the structural condition.
   */
  public abstract Type getType();
  
  /**
   * @see org.w3c.css.sac.Condition#getConditionType()
   */
  @Override
  public final short getConditionType() {   
    return SAC_STRUCTURAL_PSEUDO_CLASS_CONDITION;
  }
  
  
  /**
   * @see org.w3c.css.sac.AttributeCondition#getLocalName()
   */
  @Override
  public String getLocalName() {
//    logger.error(IMPROPER_USAGE_MESSAGE, new Exception());
    return "x";
  }
  
  /**
   * @see org.w3c.css.sac.AttributeCondition#getSpecified()
   */
  @Override
  public boolean getSpecified() {
    //logger.error(IMPROPER_USAGE_MESSAGE, new Exception());
    return false;
  }


  /**
   * @see org.w3c.css.sac.AttributeCondition#getNamespaceURI()
   */
  @Override
  public String getNamespaceURI() {
    //logger.error(IMPROPER_USAGE_MESSAGE, new Exception());
    return null;
  }

  /**
   * @see org.w3c.css.sac.AttributeCondition#getValue()
   */
  @Override
  public String getValue() {
    //logger.error(IMPROPER_USAGE_MESSAGE, new Exception());
    return "x";
  }
  
//  /**
//   * A message issued when the class is not used correctly.
//   */
//  private static final String IMPROPER_USAGE_MESSAGE = 
//      "The SPC condition extends the AttributeCondition just for " +
//      "the sake of the parsing API. Not intended to be used as an attribute condition.";
    
}
