/*
 * Copyright (c) 2018 Syncro Soft SRL - All Rights Reserved.
 *
 * This file contains proprietary and confidential source code.
 * Unauthorized copying of this file, via any medium, is strictly prohibited.
 */
package org.w3c.flute.parser.selectors.spc;

import java.util.Map;

/**
 * The :root pseudo-class represents an element that 
 * is the root of the document.
 * 
 * @author dan
 *
 * @see "http://www.w3.org/TR/css3-selectors/#root-pseudo"
 */
public class RootSPCCondition extends SPCCondition {

  /**
   * @see org.w3c.flute.parser.selectors.spc.SPCCondition#getType()
   */
  @Override
  public Type getType() {
    return Type.ROOT;
  }
  
  /**
   * @see org.w3c.flute.css.sac.Condition#getSerialization(Map)
   */
  @Override
  public String getSerialization(Map<String, String> proxyNamespaceMapping) {
    return ":root";
  }

}
