/*
 * Copyright (c) 2000 World Wide Web Consortium,
 * (Massachusetts Institute of Technology, Institut National de
 * Recherche en Informatique et en Automatique, Keio University). All
 * Rights Reserved. This program is distributed under the W3C's Software
 * Intellectual Property License. This program is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.
 * See W3C License http://www.w3.org/Consortium/Legal/ for more details.
 *
 * $Id$
 */
package org.w3c.flute.parser.selectors.spc;

import java.util.Map;

/**
 * An implementation of the nth-child pseudo function.
 * 
 * The :nth-of-type(an+b) pseudo-class notation represents an element that has an+b-1 
 * siblings with the same expanded element name before it in the document tree, for 
 * any zero or positive integer value of n, and has a parent element. See :nth-child() 
 * pseudo-class for the syntax of its argument. It also accepts the 'even' and 'odd' values.
 *  
 * @author dan
 * @see "http://www.w3.org/TR/css3-selectors/#nth-of-type-pseudo"
 * @see NthChildSPCCondition
 */
public class NthOfTypeSPCCondition extends NthChildSPCCondition {

  /**
   * Constructor.
   * 
   * @param cycle The cycle after which the delta is triggered. For instance if cycle 
   * is 10 and delta is -1, the condition will match the child element with number 9, 19, 29, 39, etc..
   * It is 1 based. 
   * @param delta The offset in the cycle. It is one based, may be negative. 
   */
  public NthOfTypeSPCCondition(int cycle, int delta) {
    super(cycle, delta);
  }

  /**
   * @see org.w3c.flute.parser.selectors.spc.SPCCondition#getType()
   */
  @Override
  public Type getType() {
    return Type.NTH_OF_TYPE;
  }

  /**
   * @see org.w3c.flute.parser.selectors.spc.NthChildSPCCondition#getSerialization(Map)
   */
  @Override
  public String getSerialization(Map<String, String> proxyNamespaceMapping) {
    return getSerialization("nth-of-type");
  }
}
