/*
 * Copyright (c) 2018 Syncro Soft SRL - All Rights Reserved.
 *
 * This file contains proprietary and confidential source code.
 * Unauthorized copying of this file, via any medium, is strictly prohibited.
 */
package org.w3c.flute.parser.selectors.spc;

import java.util.Map;


/**
 * The :nth-last-of-type(an+b) pseudo-class notation represents an element 
 * that has an+b-1 siblings with the same expanded element name after it in 
 * the document tree, for any zero or positive integer value of n, and has 
 * a parent element. See :nth-child() pseudo-class for the syntax of its argument. 
 * It also accepts the 'even' and 'odd' values. 
 * 
 * @author dan
 * @see "http://www.w3.org/TR/css3-selectors/#nth-last-of-type-pseudo"
 */
public class NthLastOfTypeSPCCondition extends NthOfTypeSPCCondition {

  /**
   * Constructor.
   * 
   * @param cycle The cycle. The counting begins from the end of the parent.  
   * @param delta The offset in the cycle. 1 based.
   */
  public NthLastOfTypeSPCCondition(int cycle, int delta) {
    super(cycle, delta);
  }
  
  /**
   * @see org.w3c.flute.parser.selectors.spc.NthChildSPCCondition#getType()
   */
  @Override
  public Type getType() {
    return Type.NTH_LAST_OF_TYPE;
  }


  /**
   * @see org.w3c.flute.parser.selectors.spc.NthChildSPCCondition#getSerialization(Map)
   */
  @Override
  public String getSerialization(Map<String, String> proxyNamespaceMapping) {
    return  getSerialization("nth-last-of-type");
  }
}
