/*
 * Copyright (c) 2018 Syncro Soft SRL - All Rights Reserved.
 *
 * This file contains proprietary and confidential source code.
 * Unauthorized copying of this file, via any medium, is strictly prohibited.
 */
package org.w3c.flute.parser.selectors;

import org.w3c.css.sac.Locator;
import org.w3c.flute.css.sac.Selector;
import org.w3c.flute.css.sac.SimpleSelector;

/**
 * A selector implementation for the general CSS sibling selector.
 * 
 * @author dan
 */
public class GeneralAdjacentSelectorImpl extends DirectAdjacentSelectorImpl {

 
  /**
   * Constructor
   * 
   * @param child The previous child
   * @param directAdjacent The one on which the styles are applied.
   * @param locator The CSS parser locator. It is used for back-mapping. Can be <code>null</code>.
   */
  public GeneralAdjacentSelectorImpl(Selector child, SimpleSelector directAdjacent, Locator locator) {
    super(child, directAdjacent, locator);
  }

  
  /**
   * An integer indicating the type of <code>Selector</code>
   */
  @Override
  public short getSelectorType() {
    return SAC_GENERAL_ADJACENT_SELECTOR;
  }

}
