/*
 * Copyright (c) 2018 Syncro Soft SRL - All Rights Reserved.
 *
 * This file contains proprietary and confidential source code.
 * Unauthorized copying of this file, via any medium, is strictly prohibited.
 */
package org.w3c.flute.parser.selectors;

import java.util.Map;

/**
 * Condition for:
 * 
 * E[foo$="bar"]  an E element whose "foo" attribute value ends exactly with the string "bar"   Attribute selectors   3
 */
public class EndsWithAttributeCondition extends BeginHyphenAttributeConditionImpl {

  /**
   * Constructor
   * 
   * @param nsURI The namespace of the attribute
   * @param localName The local name of the attribute
   * @param value The value of the attribute
   */
  public EndsWithAttributeCondition(String nsURI, String localName, String value) {
    super(nsURI, localName, value);
  }

  
  /**
   * @see org.w3c.flute.parser.selectors.BeginHyphenAttributeConditionImpl#getConditionType()
   */
  @Override
  public short getConditionType() {
    return SAC_END_WITH_ATTRIBUTE_CONDITION;
  }
  
  /**
   * @see org.w3c.flute.css.sac.Condition#getSerialization(java.util.Map)
   */
  @Override
  public String getSerialization(Map<String, String> proxyNamespaceMapping) {
    return getSerialization("$=", proxyNamespaceMapping);
  }

}
