/*
 * Copyright (c) 2000 World Wide Web Consortium,
 * (Massachusetts Institute of Technology, Institut National de
 * Recherche en Informatique et en Automatique, Keio University). All
 * Rights Reserved. This program is distributed under the W3C's Software
 * Intellectual Property License. This program is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.
 * See W3C License http://www.w3.org/Consortium/Legal/ for more details.
 *
 * $Id$
 */
package org.w3c.flute.parser.selectors;

import java.util.Map;

import org.w3c.css.sac.Locator;
import org.w3c.flute.css.sac.Selector;
import org.w3c.flute.css.sac.SiblingSelector;
import org.w3c.flute.css.sac.SimpleSelector;

/**
 * A selector like A+B.
 * 
 * @version $Revision$
 * @author  Philippe Le Hegaret
 */
public class DirectAdjacentSelectorImpl extends AbstractLocalizableSelector implements SiblingSelector {

  private Selector child;

  private SimpleSelector siblingSelector;

  /**
   * An integer indicating the type of <code>Selector</code>
   */
  @Override
  public short getSelectorType() {
    return Selector.SAC_DIRECT_ADJACENT_SELECTOR;
  }

  /**
   * Creates a new DescendantSelectorImpl
   * 
   * @param child The child selector.   In A + B, is A.
   * @param siblingSelector The direct adjacent sibling selector. In A + B, is the B part.
   * @param locator The CSS parser locator. It is used for back-mapping. Can be <code>null</code>.
   */
  public DirectAdjacentSelectorImpl(Selector child, SimpleSelector siblingSelector, Locator locator) {
    super(locator);
    this.child = child;
    this.siblingSelector = siblingSelector;
  }

  @Override
  public short getNodeType() {
    return 1;
  }

  /**
   * Returns the parent selector.
   */
  @Override
  public Selector getSelector() {
    return child;
  }

  /**
   * The selector that is after the adjacency operator. In A + B, is B.
   *  
   * @see org.w3c.flute.css.sac.SiblingSelector#getSiblingSelector()
   */
  @Override
  public SimpleSelector getSiblingSelector() {
    return siblingSelector;
  }
  
  /**
   * @see org.w3c.flute.css.sac.Selector#getSerialization(Map)
   */
  @Override
  public String getSerialization(Map<String, String> proxyNamespaceMapping) {    
    return child.getSerialization(proxyNamespaceMapping) + " + " + siblingSelector.getSerialization(proxyNamespaceMapping);
  }
}
