/*
 * Copyright (c) 2000 World Wide Web Consortium,
 * (Massachusetts Institute of Technology, Institut National de
 * Recherche en Informatique et en Automatique, Keio University). All
 * Rights Reserved. This program is distributed under the W3C's Software
 * Intellectual Property License. This program is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.
 * See W3C License http://www.w3.org/Consortium/Legal/ for more details.
 *
 * $Id$
 */
package org.w3c.flute.parser.selectors;

import java.util.Map;

import org.w3c.css.sac.Locator;
import org.w3c.flute.css.sac.Condition;
import org.w3c.flute.css.sac.ConditionalSelector;
import org.w3c.flute.css.sac.Selector;
import org.w3c.flute.css.sac.SimpleSelector;

/**
 * A selector with a condition.
 * 
 * @version $Revision$
 * @author  Philippe Le Hegaret
 */
public class ConditionalSelectorImpl extends AbstractLocalizableSelector implements ConditionalSelector {

  /**
   * The simple selector.
   */
  private SimpleSelector simpleSelector;

  /**
   * The condition.
   */
  private Condition condition;

  /**
   * A flag indicating if this selector is the subject of a CSS Level 4 subject selector.
   */
  private boolean isSubject;

  /**
   * An integer indicating the type of <code>Selector</code>
   */
  @Override
  public short getSelectorType() {
    return Selector.SAC_CONDITIONAL_SELECTOR;
  }

  /**
   * Creates a new ConditionalSelectorImpl
   * 
   * @param simpleSelector The simple selector
   * @param condition The condition
   * @param locator The CSS parser locator. It is used for back-mapping. Can be <code>null</code>.
   */
  public ConditionalSelectorImpl(SimpleSelector simpleSelector, Condition condition, Locator locator) {
    super(locator);
    this.simpleSelector = simpleSelector;
    this.condition = condition;
  }

  /**
   * Returns the simple selector.
   * <p>The simple selector can't be a <code>ConditionalSelector</code>.</p>
   */
  @Override
  public SimpleSelector getSimpleSelector() {
    return simpleSelector;
  }

  /**
   * Returns the condition to be applied on the simple selector.
   */
  @Override
  public Condition getCondition() {
    return condition;
  }

  /**
   * Sets the subject flag.
   * 
   * @param isSubject <code>true</code> if this selector is the subject of a larger selector.
   */
  @Override
  public void setIsSubject(boolean isSubject) {
    this.isSubject = isSubject;
  }

  /**
   * @see org.w3c.flute.css.sac.SubjectSelector#isSubject()
   */
  @Override
  public boolean isSubject() {
    return isSubject;
  }

  /**
   * @see org.w3c.flute.css.sac.SubjectSelector#hasSubject()
   */
  @Override
  public boolean hasSubject() {
    return isSubject;
  }

  /**
   * @see org.w3c.flute.css.sac.SubjectSelector#getSubjectAncestorSelector()
   */
  @Override
  public Selector getSubjectAncestorSelector() {
    return this;
  }

  /**
   * @see org.w3c.flute.css.sac.Selector#getSerialization(Map)
   */
  @Override
  public String getSerialization(Map<String, String> proxyNamespaceMapping) {    
    return simpleSelector.getSerialization(proxyNamespaceMapping) + condition.getSerialization(proxyNamespaceMapping) + (isSubject?"!":"");
  }

}
