/*
 * Copyright (c) 2000 World Wide Web Consortium,
 * (Massachusetts Institute of Technology, Institut National de
 * Recherche en Informatique et en Automatique, Keio University). All
 * Rights Reserved. This program is distributed under the W3C's Software
 * Intellectual Property License. This program is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.
 * See W3C License http://www.w3.org/Consortium/Legal/ for more details.
 *
 * $Id$
 */
package org.w3c.flute.parser.selectors;

import java.util.Map;

import org.w3c.flute.css.sac.CombinatorCondition;
import org.w3c.flute.css.sac.Condition;

/**
 * @version $Revision$
 * @author  Philippe Le Hegaret
 */
public class AndConditionImpl implements CombinatorCondition {

  /**
   * The first condition.
   */
  private Condition firstCondition;

  /**
   * The second condition.
   */
  private Condition secondCondition;

  /**
   * Creates a new AndConditionImpl
   * @param firstCondition The first condition.
   * @param secondCondition The second condition.
   */
  public AndConditionImpl(Condition firstCondition, Condition secondCondition) {
    this.firstCondition = firstCondition;
    this.secondCondition = secondCondition;
  }

  /**
   * An integer indicating the type of <code>Condition</code>.
   */
  @Override
  public short getConditionType() {
    return Condition.SAC_AND_CONDITION;
  }

  /**
   * Returns the first condition.
   */
  @Override
  public Condition getFirstCondition() {
    return firstCondition;
  }

  /**
   * Returns the second condition.
   */
  @Override
  public Condition getSecondCondition() {
    return secondCondition;
  }

  /**
   * @see org.w3c.flute.css.sac.Condition#getSerialization(Map)
   */
  @Override
  public String getSerialization(Map<String, String> proxyNamespaceMapping) {
    return firstCondition.getSerialization(proxyNamespaceMapping) + secondCondition.getSerialization(proxyNamespaceMapping);
  }
}
