/*
 * Copyright (c) 2018 Syncro Soft SRL - All Rights Reserved.
 *
 * This file contains proprietary and confidential source code.
 * Unauthorized copying of this file, via any medium, is strictly prohibited.
 */
package org.w3c.flute.parser;

import org.w3c.css.sac.LexicalUnit;

/**
 * Interface containing lexical unit constants used by the CSS Level 3.
 * 
 * @author dan
 */
public interface LexicalUnitEx extends LexicalUnit {
  
  /**
   * Relative length <em>rem</em>.
   */
  short SAC_REM = 1000;
  
  /**
   * Dots per inch <em>dpi</em>.
   */
  short SAC_DPI = 1001;
  
  /**
   * Left paranthesis, as used in the calc function expression groups.
   */
  short SAC_LPARAN = 50;
  
  /**
   * Right paranthesis, as used in the calc function expression groups.
   */
  short SAC_RPARAN = 51;
  
  /**
   * The initial CSS keyword. 
   */
  short SAC_INITIAL = 60;
  
  /**
   * The unset CSS keyword.
   */
  short SAC_UNSET = 61;
}
