package org.w3c.flute.css.sac;

/**
 * A list of page selectors.
 *  
 * https://www.w3.org/TR/css3-page/#page_selector_list
 */
public interface PageSelectorList {

  /**
   * Adds a page selector to the list.
   * 
   * @param selector The selector to add. Should not be <code>null</code>.
   */
  void add(PageSelector selector);
  
  /**
   * Gives access to the list of page selectors.
   * 
   * @return An iterable. Never <code>null</code>.
   */
  Iterable<PageSelector> getIterable();

}
