/*
 * (c) COPYRIGHT 1999 World Wide Web Consortium
 * (Massachusetts Institute of Technology, Institut National de Recherche
 *  en Informatique et en Automatique, Keio University).
 * All Rights Reserved. http://www.w3.org/Consortium/Legal/
 *
 * $Id: DescendantSelector.java,v 1.1 2000/07/15 22:08:32 plehegar Exp $
 */
package org.w3c.flute.css.sac;

/**
 * Matches nodes that are descendants of other nodes.
 * 
 * @version $Revision: 1.1 $
 * @author  Philippe Le Hegaret, dan
 * @see Selector#SAC_DESCENDANT_SELECTOR
 * @see Selector#SAC_CHILD_SELECTOR
 */
public interface DescendantSelector extends SubjectSelector {
    
    /**
     * Returns the parent selector.
     * @return If the selector was A &gt; B &gt; C, it returns A &gt; B.
     */    
    Selector getAncestorSelector();

    /**
     * Returns the simple selector.
     * 
     * @return The simple selector. If the selector was A &gt; B &gt; C, it returns C. 
     */    
    SimpleSelector getSimpleSelector();

    /**
     * Gets the depth of the selector.
     * 
     * @return The depth of the selector, in node levels. The level, for the direct 
     * children 1, for grandsons 2, etc..
     */
    int getDepth();
}
