/*
 * Copyright (c) 1999 World Wide Web Consortium,
 * (Massachusetts Institute of Technology, Institut National de
 * Recherche en Informatique et en Automatique, Keio University). All
 * Rights Reserved. This program is distributed under the W3C's Software
 * Intellectual Property License. This program is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.
 * See W3C License http://www.w3.org/Consortium/Legal/ for more details.
 *
 * $Id: Condition.java,v 1.8 2000/02/14 15:54:12 plehegar Exp $
 */
package org.w3c.flute.css.sac;

import java.util.Map;

/**
 * @version $Revision: 1.8 $
 * @author  Philippe Le Hegaret
 */
public interface Condition {

    /**
     * This condition checks exactly two conditions.
     * example:
     * <pre class="example">
     *   .part1:lang(fr)
     * </pre>
     * @see CombinatorCondition
     */    
    static final short SAC_AND_CONDITION		        = 0;

    /**
     * This condition checks one of two conditions.
     * @see CombinatorCondition
     */    
    static final short SAC_OR_CONDITION		        = 1;

    /**
     * This condition checks that a condition can't be applied to a node.
     * @see NegativeCondition
     */    
    static final short SAC_NEGATIVE_CONDITION		= 2;

    /**
     * 
     * This condition checks a specified position.
     * example:
     * <pre class="example">
     *   :first-child
     * </pre>
     * @deprecated Do not use this. It has changed to structural pseudo class condition.
     */    
    @Deprecated
    static final short SAC_POSITIONAL_CONDITION		= 3;

    /**
     * This condition checks an attribute.
     * example:
     * <pre class="example">
     *   [simple]
     *   [restart="never"]
     * </pre>
     * @see AttributeCondition
     */    
    static final short SAC_ATTRIBUTE_CONDITION		= 4;
    /**
     * This condition checks an id attribute.
     * example:
     * <pre class="example">
     *   #myId
     * </pre>
     * @see AttributeCondition
     */    
    static final short SAC_ID_CONDITION		        = 5;
    /**
     * This condition checks the language of the node.
     * example:
     * <pre class="example">
     *   :lang(fr)
     * </pre>
     * @see LangCondition
     */    
    static final short SAC_LANG_CONDITION		= 6;
    /**
     * This condition checks for a value in a space-separated values in a
     * specified attribute
     * example:
     * <pre class="example">
     *   [values~="10"]
     * </pre>
     * @see AttributeCondition
     */
    static final short SAC_ONE_OF_ATTRIBUTE_CONDITION	= 7;
    /**
     * This condition checks if the value is in a hypen-separated list of values
     * in a specified attribute.
     * example:
     * <pre class="example">
     *   [languages|="fr"]
     * </pre>
     * @see AttributeCondition
     */
    static final short SAC_BEGIN_HYPHEN_ATTRIBUTE_CONDITION = 8;
    /**
     * This condition checks for a specified class.
     * example:
     * <pre class="example">
     *   .example
     * </pre>
     * @see AttributeCondition
     */
    static final short SAC_CLASS_CONDITION		= 9;
    /**
     * This condition checks for the link pseudo class.
     * example:
     * <pre class="example">
     *   :link
     *   :visited
     *   :hover
     * </pre>
     * @see AttributeCondition
     */
    static final short SAC_PSEUDO_CLASS_CONDITION	= 10;
    /**
     * This condition checks if a node is the only one in the node list.
     */
    static final short SAC_ONLY_CHILD_CONDITION		= 11;
    /**
     * This condition checks if a node is the only one of his type.
     */
    static final short SAC_ONLY_TYPE_CONDITION		= 12;
    /**
     * This condition checks the content of a node.
     * @see ContentCondition
     */
    static final short SAC_CONTENT_CONDITION		= 13;

    /**
     * E[foo^="bar"]   an E element whose "foo" attribute value begins exactly with the string "bar"   Attribute selectors   3
     */
    static final short SAC_BEGIN_WITH_ATTRIBUTE_CONDITION = 123;
    
    /**
     * E[foo$="bar"]   an E element whose "foo" attribute value ends exactly with the string "bar"   Attribute selectors   3
     */
    static final short SAC_END_WITH_ATTRIBUTE_CONDITION = 124;

    /**
     * E[foo*="bar"]   an E element whose "foo" attribute value contains the substring "bar" 
     */
    static final short SAC_CONTAINS_ATTRIBUTE_CONDITION = 125;       
    

    /**
     * Structural positional pseudo classes: last-child, first-child, nth-last-child, root, empty, etc..
     */
    static final short SAC_STRUCTURAL_PSEUDO_CLASS_CONDITION = 126;

    /**
     * This condition implements the :has pseudo class
     * 
     * https://drafts.csswg.org/selectors-4/#relational
     * 
     * @see HasCondition
     */    
    static final short SAC_HAS_CONDITION = 127;


    /**
     * An integer indicating the type of <code>Condition</code>.
     * @return The condition type. One of the SAC_ constants.
     */    
    short getConditionType();

    /**
     * Get a string representing the Condition. For instance, an attribute condition
     * will serialize to "[attr='val']" or something similar.
     * @param proxyNamespaceMapping The proxy namespace mapping, key is the prefix, the namespace URI is the value. Can be <code>null</code>.
     * 
     * @return A string that by parsing will result in the current condition.  
     */
    String getSerialization(Map<String, String> proxyNamespaceMapping);
}
