/*
 * Decompiled with CFR 0.152.
 */
package com.elovirta.dita.markdown.renderer;

import com.elovirta.dita.markdown.DitaRenderer;
import com.elovirta.dita.markdown.MarkdownReader;
import com.elovirta.dita.markdown.MetadataSerializer;
import com.elovirta.dita.markdown.MetadataSerializerImpl;
import com.elovirta.dita.markdown.SaxWriter;
import com.elovirta.dita.markdown.renderer.Entities;
import com.elovirta.dita.markdown.renderer.NodeRendererContext;
import com.elovirta.dita.markdown.renderer.NodeRenderingHandler;
import com.elovirta.dita.markdown.renderer.Title;
import com.elovirta.dita.markdown.renderer.Utils;
import com.elovirta.dita.utils.ClasspathURIResolver;
import com.google.common.base.Suppliers;
import com.google.common.io.Files;
import com.vladsch.flexmark.ast.Code;
import com.vladsch.flexmark.ast.Emphasis;
import com.vladsch.flexmark.ast.Heading;
import com.vladsch.flexmark.ast.HtmlBlock;
import com.vladsch.flexmark.ast.HtmlEntity;
import com.vladsch.flexmark.ast.HtmlInlineComment;
import com.vladsch.flexmark.ast.StrongEmphasis;
import com.vladsch.flexmark.ast.Text;
import com.vladsch.flexmark.ast.TextBase;
import com.vladsch.flexmark.ext.anchorlink.AnchorLink;
import com.vladsch.flexmark.ext.attributes.AttributesNode;
import com.vladsch.flexmark.ext.gfm.strikethrough.Strikethrough;
import com.vladsch.flexmark.ext.gfm.strikethrough.Subscript;
import com.vladsch.flexmark.ext.superscript.Superscript;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.visitor.AstHandler;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.stream.StreamSource;
import org.dita.dost.util.Constants;
import org.dita.dost.util.DitaClass;
import org.dita.dost.util.URLUtils;
import org.dita.dost.util.XMLUtils;
import org.xml.sax.Attributes;

public abstract class AbstractRenderer {
    protected static final Attributes I_ATTS = Utils.buildAtts(Constants.HI_D_I);
    protected static final Attributes B_ATTS = Utils.buildAtts(Constants.HI_D_B);
    protected static final Attributes CODEPH_ATTS = Utils.buildAtts(Constants.PR_D_CODEPH);
    protected static final Attributes LINE_THROUGH_ATTS = Utils.buildAtts(Constants.HI_D_LINE_THROUGH);
    protected static final Attributes SUP_ATTS = Utils.buildAtts(Constants.HI_D_SUP);
    protected static final Attributes SUB_ATTS = Utils.buildAtts(Constants.HI_D_SUB);
    protected static final Attributes TT_ATTS = Utils.buildAtts(Constants.HI_D_TT);
    protected static final Attributes TITLE_ATTS = Utils.buildAtts(Constants.TOPIC_TITLE);
    protected static final Attributes IMAGE_ATTS = Utils.buildAtts(Constants.TOPIC_IMAGE);
    protected static final Attributes ALT_ATTS = Utils.buildAtts(Constants.TOPIC_ALT);
    protected static final Attributes PH_ATTS = Utils.buildAtts(Constants.TOPIC_PH);
    protected final boolean mditaExtendedProfile;
    protected final boolean mditaCoreProfile;
    protected final boolean rawDita;
    protected final Supplier<SAXTransformerFactory> transformerFactorySupplier;
    protected final Supplier<Templates> templatesSupplier;
    protected final Collection<String> formats;
    protected final MetadataSerializer metadataSerializer;
    protected static final Pattern HTML_HEADING_PATTERN = Pattern.compile("(<h([0-9]+)[^>]*>)([^<]*)</[^>]*>");

    public AbstractRenderer(DataHolder options) {
        boolean idFromYaml = (Boolean)DitaRenderer.ID_FROM_YAML.get(options);
        this.metadataSerializer = new MetadataSerializerImpl(idFromYaml);
        this.mditaExtendedProfile = (Boolean)DitaRenderer.MDITA_EXTENDED_PROFILE.get(options);
        this.mditaCoreProfile = (Boolean)DitaRenderer.MDITA_CORE_PROFILE.get(options);
        this.rawDita = (Boolean)DitaRenderer.RAW_DITA.get(options);
        this.transformerFactorySupplier = () -> ((com.google.common.base.Supplier)Suppliers.memoize(() -> {
            SAXTransformerFactory tf = (SAXTransformerFactory)TransformerFactory.newInstance();
            tf.setURIResolver(new ClasspathURIResolver(tf.getURIResolver()));
            return tf;
        })).get();
        this.templatesSupplier = () -> ((com.google.common.base.Supplier)Suppliers.memoize(() -> {
            Templates templates;
            block8: {
                SAXTransformerFactory tf = this.transformerFactorySupplier.get();
                String stylesheet = this.mditaCoreProfile || this.mditaExtendedProfile ? "/hdita2dita.xsl" : "/hdita2dita-markdown.xsl";
                InputStream in = this.getClass().getResourceAsStream(stylesheet);
                try {
                    templates = tf.newTemplates(new StreamSource(in, "classpath://" + stylesheet));
                    if (in == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException | TransformerConfigurationException e) {
                        throw new RuntimeException(e);
                    }
                }
                in.close();
            }
            return templates;
        })).get();
        this.formats = (Collection)MarkdownReader.FORMATS.get(options);
    }

    protected Map<Class<? extends Node>, NodeRenderingHandler<? extends Node>> getNodeRenderingHandlers() {
        ArrayList<NodeRenderingHandler<Object>> res = new ArrayList<NodeRenderingHandler<Object>>();
        res.add(new NodeRenderingHandler<AnchorLink>(AnchorLink.class, this::render));
        res.add(new NodeRenderingHandler<Code>(Code.class, this::render));
        res.add(new NodeRenderingHandler<TextBase>(TextBase.class, this::render));
        res.add(new NodeRenderingHandler<Emphasis>(Emphasis.class, this::render));
        res.add(new NodeRenderingHandler<StrongEmphasis>(StrongEmphasis.class, this::render));
        res.add(new NodeRenderingHandler<HtmlEntity>(HtmlEntity.class, this::render));
        res.add(new NodeRenderingHandler<HtmlInlineComment>(HtmlInlineComment.class, this::render));
        if (!this.mditaCoreProfile) {
            res.add(new NodeRenderingHandler<Superscript>(Superscript.class, this::render));
            res.add(new NodeRenderingHandler<Subscript>(Subscript.class, this::render));
        }
        if (!this.mditaCoreProfile && !this.mditaExtendedProfile) {
            res.add(new NodeRenderingHandler<Strikethrough>(Strikethrough.class, this::render));
        }
        return res.stream().collect(Collectors.toMap(AstHandler::getNodeType, Function.identity()));
    }

    protected void render(AnchorLink node, NodeRendererContext context, SaxWriter html) {
        context.renderChildren((Node)node);
    }

    private void render(Code node, NodeRendererContext context, SaxWriter html) {
        if (this.mditaExtendedProfile) {
            this.printTag((Node)node, context, html, Constants.HI_D_TT, TT_ATTS);
        } else {
            this.printTag((Node)node, context, html, Constants.PR_D_CODEPH, this.getInlineAttributes((Node)node, CODEPH_ATTS));
        }
    }

    protected void render(TextBase node, NodeRendererContext context, SaxWriter html) {
        context.renderChildren((Node)node);
    }

    protected void render(Emphasis node, NodeRendererContext context, SaxWriter html) {
        this.printTag((Node)node, context, html, Constants.HI_D_I, this.getInlineAttributes((Node)node, I_ATTS));
    }

    protected void render(StrongEmphasis node, NodeRendererContext context, SaxWriter html) {
        this.printTag((Node)node, context, html, Constants.HI_D_B, this.getInlineAttributes((Node)node, B_ATTS));
    }

    protected void render(Superscript node, NodeRendererContext context, SaxWriter html) {
        this.printTag((Node)node, context, html, Constants.HI_D_SUP, this.getInlineAttributes((Node)node, SUP_ATTS));
    }

    protected void render(Subscript node, NodeRendererContext context, SaxWriter html) {
        this.printTag((Node)node, context, html, Constants.HI_D_SUB, this.getInlineAttributes((Node)node, SUB_ATTS));
    }

    private void render(Strikethrough node, NodeRendererContext context, SaxWriter html) {
        if (this.mditaExtendedProfile) {
            this.printTag((Node)node, context, html, Constants.TOPIC_PH, PH_ATTS);
        } else {
            this.printTag((Node)node, context, html, Constants.HI_D_LINE_THROUGH, this.getInlineAttributes((Node)node, LINE_THROUGH_ATTS));
        }
    }

    private void render(HtmlEntity node, NodeRendererContext context, SaxWriter html) {
        BasedSequence chars = node.getChars();
        String name = chars.subSequence(1, chars.length() - 1).toString().toLowerCase();
        String val = Entities.ENTITIES.getProperty(name);
        if (val != null) {
            html.characters(val);
        }
    }

    private void render(HtmlInlineComment node, NodeRendererContext context, SaxWriter html) {
    }

    protected List<Node> childList(Node astRoot) {
        return StreamSupport.stream(astRoot.getChildren().spliterator(), false).collect(Collectors.toList());
    }

    protected boolean hasMultipleTopLevelHeaders(Document astRoot) {
        Integer[] firstLevel = new Integer[]{-1};
        int firstLevelNodeCount = 0;
        for (Node n : astRoot.getChildren()) {
            if (firstLevelNodeCount > 1) break;
            if (n instanceof Heading) {
                if (firstLevel[0] == -1) {
                    firstLevel[0] = ((Heading)n).getLevel();
                }
                if (((Heading)n).getLevel() > firstLevel[0]) continue;
                ++firstLevelNodeCount;
                continue;
            }
            if (!(n instanceof HtmlBlock)) continue;
            String text = n.getChars().toString();
            Matcher headingMatcher = HTML_HEADING_PATTERN.matcher(text);
            while (headingMatcher.find()) {
                Integer currentNodeLevel = Integer.valueOf(headingMatcher.group(2));
                if (firstLevel[0] == -1) {
                    firstLevel[0] = currentNodeLevel;
                }
                if (currentNodeLevel > firstLevel[0]) continue;
                ++firstLevelNodeCount;
            }
        }
        return firstLevelNodeCount > 1;
    }

    protected void printTag(Text node, NodeRendererContext context, SaxWriter html, DitaClass tag, Attributes atts) {
        html.startElement((Node)node, tag, atts);
        html.characters(node.getChars().toString());
        html.endElement();
    }

    protected void printTag(Node node, NodeRendererContext context, SaxWriter html, DitaClass tag, Attributes atts) {
        html.startElement(node, tag, atts);
        context.renderChildren(node);
        html.endElement();
    }

    abstract XMLUtils.AttributesBuilder getLinkAttributes(String var1);

    protected XMLUtils.AttributesBuilder getLinkAttributes(String href, Attributes baseAttrs) {
        XMLUtils.AttributesBuilder atts = new XMLUtils.AttributesBuilder(baseAttrs).add("href", href);
        if (href.startsWith("#")) {
            atts.add("format", "markdown");
        } else {
            URI uri = URLUtils.toURI((String)href);
            String format = null;
            if (uri.getPath() != null) {
                String ext;
                switch (ext = Files.getFileExtension((String)uri.getPath()).toLowerCase()) {
                    case "dita": 
                    case "xml": {
                        format = null;
                        break;
                    }
                    default: {
                        if (this.formats.contains(ext)) {
                            format = ext;
                            break;
                        }
                        String string = format = !ext.isEmpty() ? ext : "html";
                    }
                }
            }
            if (uri.getScheme() != null && uri.getScheme().equals("mailto")) {
                atts.add("format", "email");
            }
            if (format != null) {
                atts.add("format", format);
            }
            if (uri != null && (uri.isAbsolute() || !uri.isAbsolute() && uri.getPath() != null && uri.getPath().startsWith("/"))) {
                atts.add("scope", "external");
            }
        }
        return atts;
    }

    protected String normalize(String string) {
        StringBuilder sb = new StringBuilder();
        block3: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\t': 
                case '\n': 
                case ' ': {
                    continue block3;
                }
                default: {
                    sb.append(Character.toLowerCase(c));
                }
            }
        }
        return sb.toString();
    }

    protected Attributes getInlineAttributes(Node node, Attributes base) {
        if (!this.mditaCoreProfile && !this.mditaExtendedProfile) {
            if (node.getChildOfType(new Class[]{AttributesNode.class}) != null) {
                Title header = Title.getFromChildren(node);
                XMLUtils.AttributesBuilder builder = new XMLUtils.AttributesBuilder(base);
                return this.readAttributes(header, builder).build();
            }
            if (node.getNext() instanceof AttributesNode) {
                Title header = Title.getFromNext(node);
                XMLUtils.AttributesBuilder builder = new XMLUtils.AttributesBuilder(base);
                return this.readAttributes(header, builder).build();
            }
        }
        return base;
    }

    protected XMLUtils.AttributesBuilder readAttributes(Title header, XMLUtils.AttributesBuilder builder) {
        if (!header.classes.isEmpty()) {
            builder.add("outputclass", String.join((CharSequence)" ", header.classes));
        }
        for (Map.Entry<String, String> attr : header.attributes.entrySet()) {
            builder.add(attr.getKey(), attr.getValue());
        }
        header.id.ifPresent(id -> builder.add("id", id));
        return builder;
    }
}

