/*
 * Decompiled with CFR 0.152.
 */
package com.elovirta.dita.markdown;

import com.elovirta.dita.markdown.ParseException;
import com.vladsch.flexmark.util.ast.Node;
import java.util.ArrayDeque;
import java.util.Deque;
import org.dita.dost.util.DitaClass;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.Locator2Impl;
import org.xml.sax.helpers.XMLFilterImpl;

public class SaxWriter
extends XMLFilterImpl {
    public final Deque<String> tagStack = new ArrayDeque<String>();
    private final Locator2Impl locator = new Locator2Impl();

    public SaxWriter(ContentHandler out) {
        this.setContentHandler(out);
    }

    @Override
    public void startDocument() {
        this.locator.setLineNumber(1);
        this.locator.setColumnNumber(1);
        this.getContentHandler().setDocumentLocator(this.locator);
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        this.getContentHandler().startElement(uri, localName, qName, atts);
        this.tagStack.addFirst(localName);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.tagStack.isEmpty()) {
            throw new IllegalStateException("Empty tag stack");
        }
        String tag = this.tagStack.removeFirst();
        this.getContentHandler().endElement(uri, localName, qName);
    }

    public void setDocumentLocator() {
        this.getContentHandler().setDocumentLocator(this.locator);
    }

    public void setLocation(Node node) {
        if (node != null) {
            this.locator.setLineNumber(node.getLineNumber() + 1);
            this.locator.setColumnNumber(node.getStartOffset() - node.getStartOfLine() + 1);
        }
    }

    public void startElement(Node node, DitaClass tag, Attributes atts) {
        this.startElement(node, tag.localName, atts);
    }

    public void startElement(Node node, String tag, Attributes atts) {
        this.setLocation(node);
        try {
            this.startElement("", tag, tag, atts);
        }
        catch (SAXException e) {
            throw new ParseException(e);
        }
    }

    public void endElement() {
        String tag = this.tagStack.peekFirst();
        this.endElement(tag);
    }

    public void endElement(DitaClass cls) {
        this.endElement(cls.localName);
    }

    public void endElement(String tag) {
        try {
            this.endElement("", tag, tag);
        }
        catch (SAXException e) {
            throw new ParseException(e);
        }
    }

    public void characters(char c) {
        try {
            this.getContentHandler().characters(new char[]{c}, 0, 1);
        }
        catch (SAXException e) {
            throw new ParseException(e);
        }
    }

    public void characters(String t) {
        char[] cs = t.toCharArray();
        try {
            this.getContentHandler().characters(cs, 0, cs.length);
        }
        catch (SAXException e) {
            throw new ParseException(e);
        }
    }

    public void close() {
        while (!this.tagStack.isEmpty()) {
            this.endElement();
        }
    }

    @Override
    public void processingInstruction(String name, String data) {
        try {
            this.getContentHandler().processingInstruction(name, data != null ? data : "");
        }
        catch (SAXException e) {
            throw new ParseException(e);
        }
    }
}

