/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.zendesk.util;

import com.oxygenxml.zendesk.util.HtmlInfoExtractor;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.saxon.s9api.SaxonApiException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;
import org.zendesk.client.v2.Zendesk;
import org.zendesk.client.v2.model.User;
import org.zendesk.client.v2.model.hc.Category;
import org.zendesk.client.v2.model.hc.PermissionGroup;
import org.zendesk.client.v2.model.hc.Section;
import org.zendesk.client.v2.model.hc.Translation;
import org.zendesk.client.v2.model.hc.UserSegment;

public class OxygenZendeskUtil {
    private static final Logger logger = LoggerFactory.getLogger(OxygenZendeskUtil.class);
    public static final long ID_FOR_NO_USER_SEGMENT = -1L;

    private OxygenZendeskUtil() {
        throw new UnsupportedOperationException("Instantiation of this utility class is not allowed!");
    }

    public static boolean isArticleHtmlFile(File file, File mainDir, boolean createArticleFromToc) {
        boolean isMainIndexFile = file.equals(new File(mainDir, "index.html")) || file.equals(new File(mainDir, "index.xhtml"));
        boolean hasHTMLExtension = file.getName().endsWith(".html") || file.getName().endsWith(".xhtml");
        return hasHTMLExtension && (createArticleFromToc || !isMainIndexFile);
    }

    public static boolean isRemoteResource(String location) {
        return location.startsWith("http:") || location.startsWith("https:") || location.startsWith("ftp:") || location.startsWith("sftp:") || location.startsWith("mailto:");
    }

    public static String rewritePathSeparators(String path) {
        return path.replace("\\", "/");
    }

    public static List<File> getHTMLFiles(File baseDir, boolean createArticleFromToc) throws IOException {
        ArrayList<File> htmlFiles = new ArrayList();
        try (Stream<Path> stream = Files.walk(baseDir.toPath(), new FileVisitOption[0]).sorted();){
            htmlFiles = stream.map(Path::toFile).filter(file -> OxygenZendeskUtil.isArticleHtmlFile(file, baseDir, createArticleFromToc)).collect(Collectors.toList());
        }
        return htmlFiles;
    }

    public static List<File> getHtmlFilesSortedByIndex(List<File> htmlFiles, File indexFile) throws SaxonApiException, ParserConfigurationException, SAXException {
        List<File> sortedList = htmlFiles;
        if (indexFile != null && indexFile.exists()) {
            File mainFolder = indexFile.getParentFile();
            HtmlInfoExtractor htmlInfoExtractor = new HtmlInfoExtractor(indexFile);
            List<String> indexHrefs = htmlInfoExtractor.getAllAnchorHrefValues();
            List htmlFilesPaths = htmlFiles.stream().map(f -> OxygenZendeskUtil.rewritePathSeparators(mainFolder.toPath().relativize(f.toPath()).toString())).collect(Collectors.toList());
            sortedList = indexHrefs.stream().distinct().map(href -> new File(mainFolder, (String)href)).filter(htmlFiles::contains).collect(Collectors.toList());
            htmlFilesPaths.removeAll(indexHrefs);
            List remainingFiles = htmlFilesPaths.stream().map(href -> new File(mainFolder, (String)href)).collect(Collectors.toList());
            sortedList.addAll(remainingFiles);
            if (sortedList.contains(indexFile)) {
                sortedList.remove(indexFile);
                sortedList.add(0, indexFile);
            }
        }
        return sortedList;
    }

    public static List<String> getCurrentUserPermissionGroups(Zendesk zendeskAccess) {
        ArrayList<String> userPermGroups = new ArrayList<String>();
        Iterable allPermissionGroups = zendeskAccess.getPermissionGroups();
        User currentUser = zendeskAccess.getCurrentUser();
        ArrayList userSegments4UserID = new ArrayList();
        zendeskAccess.getUserSegments(currentUser.getId().longValue()).forEach(userSegments4UserID::add);
        List userSegmentIDs4User = userSegments4UserID.stream().map(UserSegment::getId).collect(Collectors.toList());
        for (PermissionGroup permissionGroup : allPermissionGroups) {
            List<Long> publish;
            HashSet<Long> permGroupUserSegments = new HashSet<Long>();
            List<Long> edit = permissionGroup.getEdit();
            if (edit != null && !edit.isEmpty()) {
                permGroupUserSegments.addAll(edit);
            }
            if ((publish = permissionGroup.getPublish()) != null && !publish.isEmpty()) {
                permGroupUserSegments.addAll(publish);
            }
            if (permGroupUserSegments.isEmpty()) {
                userPermGroups.add(permissionGroup.getName());
                continue;
            }
            permGroupUserSegments.retainAll(userSegmentIDs4User);
            if (permGroupUserSegments.isEmpty()) continue;
            userPermGroups.add(permissionGroup.getName());
        }
        return userPermGroups;
    }

    public static boolean shouldCreateDrafts(String isDraft) {
        return "yes".equalsIgnoreCase(isDraft) || "true".equalsIgnoreCase(isDraft);
    }

    public static long getCategoryID(String categoryName, Zendesk zendeskAccess) {
        if (categoryName != null && !categoryName.isEmpty()) {
            Iterable categories = zendeskAccess.getCategories();
            for (Category category : categories) {
                if (!category.getName().equals(categoryName)) continue;
                return category.getId();
            }
        }
        return -1L;
    }

    public static long getSectionID(String sectionName, Category category, Zendesk zendeskAccess) {
        if (sectionName != null && !sectionName.isEmpty()) {
            String[] sectionsPath = sectionName.split("///");
            Iterable sections = zendeskAccess.getSections(category);
            for (Section section : sections) {
                boolean subsectionsPresent;
                if (!section.getName().equals(sectionsPath[0]) || section.getId() == null) continue;
                long sectionID = section.getId();
                boolean bl = subsectionsPresent = sectionsPath.length > 1;
                if (subsectionsPresent) {
                    sectionID = OxygenZendeskUtil.getSubsectionID(sectionID, sectionsPath, 1, category, zendeskAccess);
                }
                return sectionID;
            }
        }
        return -1L;
    }

    private static long getSubsectionID(long parentSectionID, String[] sectionsPath, int index, Category category, Zendesk zendeskAccess) {
        Iterable sections = zendeskAccess.getSections(category);
        for (Section section : sections) {
            boolean foundMatchingSubsection = section.getId() != null && section.getParentSectionId() != null && section.getParentSectionId() == parentSectionID && sectionsPath[index].equals(section.getName());
            if (!foundMatchingSubsection) continue;
            if (index < sectionsPath.length - 1) {
                return OxygenZendeskUtil.getSubsectionID(section.getId(), sectionsPath, index + 1, category, zendeskAccess);
            }
            return section.getId();
        }
        return -1L;
    }

    public static long getPermissionGroupID(String permissionGroupName, Zendesk zendeskAccess) {
        if (permissionGroupName != null && !permissionGroupName.isEmpty()) {
            Iterable permissionGroups = zendeskAccess.getPermissionGroups();
            for (PermissionGroup permissionGroup : permissionGroups) {
                if (!permissionGroup.getName().equals(permissionGroupName)) continue;
                return permissionGroup.getId();
            }
        }
        return -1L;
    }

    public static long getUserSegmentID(String userSegmentName, Zendesk zendeskAccess) {
        if (userSegmentName != null && !userSegmentName.isEmpty()) {
            Iterable userSegments = zendeskAccess.getUserSegments();
            for (UserSegment userSeg : userSegments) {
                if (!userSeg.getName().equals(userSegmentName)) continue;
                return userSeg.getId();
            }
        }
        return -1L;
    }

    public static Translation getTranslationForArticleLocale(String articleLocale, Long articleID, Zendesk zendeskAccess) {
        Translation translation = null;
        Iterable articleTranslations = zendeskAccess.getArticleTranslations(articleID);
        for (Translation t : articleTranslations) {
            if (!t.getLocale().equals(articleLocale)) continue;
            translation = t;
            break;
        }
        return translation;
    }
}

