/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.zendesk.util;

import java.io.File;
import java.io.StringReader;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XPathCompiler;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.trans.XPathException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class HtmlInfoExtractor {
    private XdmNode xdm;
    private XPathCompiler xPathCompiler;
    private String titlePrefix;
    private String titleSuffix;

    public HtmlInfoExtractor(File htmlFile) throws SaxonApiException, ParserConfigurationException, SAXException {
        Processor processor = new Processor(false);
        SAXParser sp = SAXParserFactory.newInstance().newSAXParser();
        XMLReader reader = sp.getXMLReader();
        reader.setEntityResolver((publicId, systemId) -> new InputSource(new StringReader("")));
        SAXSource source = new SAXSource(reader, new InputSource(htmlFile.toURI().toASCIIString()));
        this.xdm = processor.newDocumentBuilder().build((Source)source);
        this.xPathCompiler = processor.newXPathCompiler();
    }

    public String getTitle() throws SaxonApiException, XPathException {
        XdmValue result = this.xPathCompiler.evaluate("normalize-space(string-join(//*:head/*:title[1]/text(), ''))", (XdmItem)this.xdm);
        Object title = result.getUnderlyingValue().getStringValue();
        if (this.titlePrefix != null) {
            title = this.titlePrefix + (String)title;
        }
        if (this.titleSuffix != null) {
            title = (String)title + this.titleSuffix;
        }
        return title;
    }

    public String getBody() throws SaxonApiException, XPathException {
        XdmValue result = this.xPathCompiler.evaluate("serialize(//*:body/*[not(self::*:h1[normalize-space(string-join(.//text(), ''))=normalize-space(string-join(/*:html/*:head/*:title/text(), ''))])])", (XdmItem)this.xdm);
        return result.getUnderlyingValue().getStringValue();
    }

    public List<String> getAllImgSrcValues() throws SaxonApiException {
        XdmValue result = this.xPathCompiler.evaluate("//*:img/@src/string()", (XdmItem)this.xdm);
        return result.stream().map(XdmValue::toString).collect(Collectors.toList());
    }

    public List<String> getAllCrossRefHrefs() throws SaxonApiException {
        XdmValue result = this.xPathCompiler.evaluate("//*:a[analyze-string(@href, '(http|https|ftp|sftp|mailto)://(.*)')/*:non-match][analyze-string(@href, '(.*)(\\.html|\\.xhtml){1}(#|\\?)*(.*)')/*:match]/@href/string()", (XdmItem)this.xdm);
        return result.stream().map(XdmValue::toString).collect(Collectors.toList());
    }

    public List<String> getAllAnchorReferencesToResources() throws SaxonApiException {
        XdmValue result = this.xPathCompiler.evaluate("//*:a[analyze-string(@href, '(.*)(\\.html|\\.xhtml){1}(#|\\?)*(.*)')/*:non-match][analyze-string(@href, '#(.+)')/*:non-match]/@href/string()", (XdmItem)this.xdm);
        return result.stream().map(XdmValue::toString).collect(Collectors.toList());
    }

    public List<String> getAllAnchorHrefValues() throws SaxonApiException {
        XdmValue result = this.xPathCompiler.evaluate("//*:a/@href/string()", (XdmItem)this.xdm);
        return result.stream().map(XdmValue::toString).collect(Collectors.toList());
    }

    public List<String> getAllObjectDataValues() throws SaxonApiException {
        XdmValue result = this.xPathCompiler.evaluate("//*:object/@data/string()", (XdmItem)this.xdm);
        return result.stream().map(XdmValue::toString).collect(Collectors.toList());
    }

    public List<String> getAllAudioSrcValues() throws SaxonApiException {
        XdmValue result = this.xPathCompiler.evaluate("//*:audio/*:source/@src/string()", (XdmItem)this.xdm);
        return result.stream().map(XdmValue::toString).collect(Collectors.toList());
    }

    public List<String> getAllVideoSrcValues() throws SaxonApiException {
        XdmValue result = this.xPathCompiler.evaluate("//*:video/*:source/@src/string()", (XdmItem)this.xdm);
        return result.stream().map(XdmValue::toString).collect(Collectors.toList());
    }

    public void setTitlePrefix(String titlePrefix) {
        this.titlePrefix = titlePrefix;
    }

    public void setTitleSuffix(String titleSuffix) {
        this.titleSuffix = titleSuffix;
    }
}

