/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.zendesk.settings;

import com.oxygenxml.platform.integration.Settings;
import com.oxygenxml.zendesk.OxygenZendeskException;
import com.oxygenxml.zendesk.settings.ProcessedInitializationSettings;
import com.oxygenxml.zendesk.settings.ProcessedSettingsForHelpCenterUpdate;
import com.oxygenxml.zendesk.util.OxygenZendeskUtil;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.zendesk.client.v2.Zendesk;
import org.zendesk.client.v2.model.hc.Category;
import org.zendesk.client.v2.model.hc.Section;
import org.zendesk.client.v2.model.hc.UserSegment;

public final class SettingsProcessor {
    private Settings settings;

    public SettingsProcessor(Settings settings) {
        this.settings = settings;
    }

    public ProcessedInitializationSettings getProcessedInitializationSettings() throws OxygenZendeskException {
        return new ProcessedInitializationSettings().setZendeskHost(this.getZendeskHost()).setUsername(this.getUsername()).setToken(this.getToken());
    }

    public ProcessedSettingsForHelpCenterUpdate getProcessedSettingsForHelpCenterUpdate(Zendesk zendeskAccess) throws OxygenZendeskException {
        long categoryID = this.getCategoryID(zendeskAccess);
        String createDrafts = this.settings.getParameterValue("createDrafts");
        return new ProcessedSettingsForHelpCenterUpdate().setCreateDrafts(OxygenZendeskUtil.shouldCreateDrafts(createDrafts)).setCategoryID(categoryID).setSectionID(this.getSectionID(categoryID, zendeskAccess)).setPermissionGroupID(this.getPermissionGroupID(zendeskAccess)).setUserSegmentID(this.getUserSegmentID(zendeskAccess));
    }

    private long getUserSegmentID(Zendesk zendeskAccess) throws OxygenZendeskException {
        long userSegmentID = -1L;
        String visibleToUserSegment = this.settings.getParameterValue("visibleTo");
        if (visibleToUserSegment != null && !visibleToUserSegment.isEmpty() && (userSegmentID = OxygenZendeskUtil.getUserSegmentID(visibleToUserSegment, zendeskAccess)) == -1L) {
            throw new OxygenZendeskException("No user segment ID found for '" + visibleToUserSegment + "'. " + this.getKnownUserSegmentsMessage(zendeskAccess));
        }
        return userSegmentID;
    }

    private long getPermissionGroupID(Zendesk zendeskAccess) throws OxygenZendeskException {
        String permGroupName = this.settings.getParameterValue("permissionGroupName");
        if (permGroupName == null || permGroupName.isEmpty()) {
            throw new OxygenZendeskException(this.getNoValueProvidedForParamMessage("permissionGroupName") + " " + this.getKnownPermissionGroupsMessage(zendeskAccess));
        }
        long permissionGroupID = OxygenZendeskUtil.getPermissionGroupID(permGroupName, zendeskAccess);
        if (permissionGroupID == -1L) {
            throw new OxygenZendeskException("No permission group ID found for '" + permGroupName + "'. " + this.getKnownPermissionGroupsMessage(zendeskAccess));
        }
        return permissionGroupID;
    }

    private long getSectionID(long categoryID, Zendesk zendeskAccess) throws OxygenZendeskException {
        Category category = zendeskAccess.getCategory(categoryID);
        String sectionName = this.settings.getParameterValue("sectionName");
        if (sectionName == null || sectionName.isEmpty()) {
            throw new OxygenZendeskException(this.getNoValueProvidedForParamMessage("sectionName") + " " + this.getKnownSectionsMessage(category, zendeskAccess));
        }
        long sectionID = OxygenZendeskUtil.getSectionID(sectionName, category, zendeskAccess);
        if (sectionID == -1L) {
            throw new OxygenZendeskException("No section ID found for '" + sectionName + "'. " + this.getKnownSectionsMessage(category, zendeskAccess));
        }
        return sectionID;
    }

    private long getCategoryID(Zendesk zendeskAccess) throws OxygenZendeskException {
        String categoryName = this.settings.getParameterValue("categoryName");
        if (categoryName == null || categoryName.isEmpty()) {
            throw new OxygenZendeskException(this.getNoValueProvidedForParamMessage("categoryName") + " " + this.getKnownCategoriesMessage(zendeskAccess));
        }
        long categoryID = OxygenZendeskUtil.getCategoryID(categoryName, zendeskAccess);
        if (categoryID == -1L) {
            throw new OxygenZendeskException("No category ID found for '" + categoryName + "'. " + this.getKnownCategoriesMessage(zendeskAccess));
        }
        return categoryID;
    }

    private String getToken() throws OxygenZendeskException {
        String token = this.settings.getParameterValue("token");
        if (token == null || token.isEmpty()) {
            throw new OxygenZendeskException(this.getNoValueProvidedForParamMessage("token"));
        }
        return token;
    }

    private String getUsername() throws OxygenZendeskException {
        String username = this.settings.getParameterValue("username");
        if (username == null || username.isEmpty()) {
            throw new OxygenZendeskException(this.getNoValueProvidedForParamMessage("username"));
        }
        return username;
    }

    private String getZendeskHost() throws OxygenZendeskException {
        String host = this.settings.getParameterValue("zendeskHost");
        if (host == null || host.isEmpty()) {
            throw new OxygenZendeskException(this.getNoValueProvidedForParamMessage("zendeskHost"));
        }
        try {
            new URL(host).toURI();
            return host;
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new OxygenZendeskException("The value provided for the 'zendeskHost' parameter is not a valid URL.");
        }
    }

    private String getNoValueProvidedForParamMessage(String paramName) {
        return "No value provided for parameter '" + paramName + "'.";
    }

    private String getKnownPermissionGroupsMessage(Zendesk zendeskAccess) {
        String knownPermGroups = OxygenZendeskUtil.getCurrentUserPermissionGroups(zendeskAccess).stream().collect(Collectors.joining(", "));
        return "Known permission group names: " + knownPermGroups + ".";
    }

    private String getKnownUserSegmentsMessage(Zendesk zendeskAccess) {
        String knownUserSegments = StreamSupport.stream(zendeskAccess.getUserSegments().spliterator(), false).map(UserSegment::getName).collect(Collectors.joining(", "));
        return "Known user segment names: " + knownUserSegments + ".";
    }

    private String getKnownSectionsMessage(Category category, Zendesk zendeskAccess) {
        ArrayList sections = new ArrayList();
        zendeskAccess.getSections(category).forEach(sections::add);
        String knownSectionNames = sections.stream().map(Section::getName).collect(Collectors.joining(", "));
        return "Known sections for category '" + category.getName() + "': " + knownSectionNames + ".";
    }

    private String getKnownCategoriesMessage(Zendesk zendeskAccess) {
        ArrayList categories = new ArrayList();
        zendeskAccess.getCategories().forEach(categories::add);
        String knownCategoryNames = categories.stream().map(Category::getName).collect(Collectors.joining(", "));
        return "Known categories: " + knownCategoryNames + ".";
    }
}

