/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.zendesk;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.MapType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.oxygenxml.platform.integration.ErrorHandler;
import com.oxygenxml.platform.integration.Parameter;
import com.oxygenxml.platform.integration.ProgressEvent;
import com.oxygenxml.platform.integration.ProgressTracker;
import com.oxygenxml.platform.integration.RepositoryUpdater;
import com.oxygenxml.platform.integration.Settings;
import com.oxygenxml.zendesk.OxygenZendeskException;
import com.oxygenxml.zendesk.metadata.ArticleMetadata;
import com.oxygenxml.zendesk.metadata.ResourceMetadata;
import com.oxygenxml.zendesk.settings.ProcessedInitializationSettings;
import com.oxygenxml.zendesk.settings.ProcessedSettingsForHelpCenterUpdate;
import com.oxygenxml.zendesk.settings.SettingsProcessor;
import com.oxygenxml.zendesk.util.HtmlInfoExtractor;
import com.oxygenxml.zendesk.util.OxygenZendeskUtil;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.bind.DatatypeConverter;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XPathCompiler;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.trans.XPathException;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.AsyncHttpClientConfig;
import org.asynchttpclient.DefaultAsyncHttpClient;
import org.asynchttpclient.DefaultAsyncHttpClientConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.zendesk.client.v2.Zendesk;
import org.zendesk.client.v2.ZendeskException;
import org.zendesk.client.v2.model.hc.Article;
import org.zendesk.client.v2.model.hc.ArticleAttachments;
import org.zendesk.client.v2.model.hc.Category;
import org.zendesk.client.v2.model.hc.Section;
import org.zendesk.client.v2.model.hc.Translation;
import ro.sync.basic.util.URLUtil;

public class ZendeskRepositoryManager
implements RepositoryUpdater {
    private static final String TOC_LABEL_VALUE = "toc";
    private static final ErrorHandler DEFAULT_ERROR_HANDLER = new ErrorHandler(){
        private final Logger logger = LoggerFactory.getLogger(ZendeskRepositoryManager.class);

        @Override
        public void warn(Exception ex) {
            this.logger.warn(ex.getMessage(), (Throwable)ex);
        }

        @Override
        public void fatal(Exception ex) {
            this.logger.error(ex.getMessage(), (Throwable)ex);
        }

        @Override
        public void error(Exception ex) {
            this.logger.error(ex.getMessage(), (Throwable)ex);
        }
    };
    private static final ProgressTracker DEFAULT_PROGRESS_TRACKER = new ProgressTracker(){

        @Override
        public void operationStarted() {
        }

        @Override
        public void operationEnded() {
        }

        @Override
        public void eventHappened(ProgressEvent event) {
        }
    };
    private static final String[] IMAGE_EXTENSIONS = new String[]{"svg", "svgz", "jpg", "jpeg", "png", "gif"};
    static final String METADATA_ARTICLE_NAME = "Oxygen Publishing Metadata - do not delete";
    private String zendeskHost;
    private Zendesk zendeskAccess;
    private ErrorHandler errorHandler = DEFAULT_ERROR_HANDLER;
    private ProgressTracker progressTracker = DEFAULT_PROGRESS_TRACKER;

    @Override
    public List<Parameter> getAvailableParameters() {
        ArrayList<Parameter> params = new ArrayList<Parameter>();
        params.add(new Parameter("zendeskHost", "The Zendesk host where the HTML files are uploaded.", Parameter.ParamType.STRING_TYPE));
        params.add(new Parameter("username", "The user name used to authenticate to the Zendesk repository.", Parameter.ParamType.STRING_TYPE));
        params.add(new Parameter("token", "The token used to authenticate to the Zendesk repository.", Parameter.ParamType.PASSWORD_TYPE));
        params.add(new Parameter("categoryName", "The name of the target category. A category contains sections, not articles.", Parameter.ParamType.STRING_TYPE));
        params.add(new Parameter("sectionName", "The name of the target section. Sections are the containers of articles.", Parameter.ParamType.STRING_TYPE));
        params.add(new Parameter("createDrafts", "Choose if the articles to be created should be saved as drafts. By default, they are published. To create drafts, set this argument's value to \"true\". This argument does not apply to existing articles.", Parameter.ParamType.BOOLEAN_TYPE, false));
        params.add(new Parameter("visibleTo", "The name of the user segment to which the articles will be visible.", Parameter.ParamType.STRING_TYPE, false));
        params.add(new Parameter("permissionGroupName", "The name of the permission group used when creating articles. Permission groups control who can edit and publish articles.", Parameter.ParamType.STRING_TYPE));
        return params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateRepository(File baseDir, Settings settings, ErrorHandler errorHandler, ProgressTracker progressTracker) {
        this.errorHandler = errorHandler != null ? errorHandler : DEFAULT_ERROR_HANDLER;
        this.progressTracker = progressTracker != null ? progressTracker : DEFAULT_PROGRESS_TRACKER;
        try {
            this.progressTracker.operationStarted();
            try {
                SettingsProcessor settingsProcessor = new SettingsProcessor(settings);
                ProcessedInitializationSettings processedInitSettings = settingsProcessor.getProcessedInitializationSettings();
                this.initZendesk(processedInitSettings.getZendeskHost(), processedInitSettings.getUsername(), processedInitSettings.getToken());
                ProcessedSettingsForHelpCenterUpdate processedSettingsForHCUpdate = settingsProcessor.getProcessedSettingsForHelpCenterUpdate(this.zendeskAccess);
                boolean createArticleFromToc = !"false".equals(settings.getParameterValue("createToc"));
                this.updateZendeskRepo(processedSettingsForHCUpdate.getSectionID(), processedSettingsForHCUpdate.getPermissionGroupID(), processedSettingsForHCUpdate.getUserSegmentID(), OxygenZendeskUtil.getHTMLFiles(baseDir, createArticleFromToc), processedSettingsForHCUpdate.isCreateDrafts(), baseDir, settings);
            }
            catch (OxygenZendeskException e) {
                this.errorHandler.fatal(e);
            }
            catch (IOException e) {
                this.errorHandler.fatal(new OxygenZendeskException("Could not collect the HTML files.", e));
            }
        }
        finally {
            this.progressTracker.operationEnded();
        }
    }

    void updateZendeskRepo(long sectionID, long permissionGroupID, List<File> htmlFiles, boolean isCreateDrafts, File baseDir) {
        this.updateZendeskRepo(sectionID, permissionGroupID, -1L, htmlFiles, isCreateDrafts, baseDir, null);
    }

    private void updateZendeskRepo(long sectionID, long permissionGroupID, long userSegmentID, List<File> htmlFiles, boolean isCreateDrafts, File baseDir, Settings settings) {
        Article metadataArticle = this.getMetadataArticle(sectionID);
        Map<String, ArticleMetadata> metadata = this.getMetadata(metadataArticle);
        HashSet<String> toDelete = new HashSet<String>(metadata.keySet());
        DecodedFilePathKeyHashMap<List<String>> htmlFilepathToXRefValues = new DecodedFilePathKeyHashMap<List<String>>();
        File indexFile = new File(baseDir, "index.html");
        if (indexFile.exists()) {
            try {
                htmlFiles = OxygenZendeskUtil.getHtmlFilesSortedByIndex(htmlFiles, indexFile);
            }
            catch (ParserConfigurationException | SaxonApiException | SAXException e) {
                this.errorHandler.error(new OxygenZendeskException("Could not sort the HTML files based on index.html.", e));
            }
        }
        for (int i = 0; i < htmlFiles.size(); ++i) {
            HtmlInfoExtractor htmlInfoExtractor;
            String htmlFileRelativePath;
            boolean isIndexFile;
            File htmlFile;
            block17: {
                htmlFile = htmlFiles.get(i);
                isIndexFile = indexFile != null && indexFile.equals(htmlFile);
                htmlFileRelativePath = ZendeskRepositoryManager.getRelativeFilePath(baseDir, htmlFile.toPath());
                toDelete.remove(htmlFileRelativePath);
                htmlInfoExtractor = null;
                try {
                    htmlInfoExtractor = new HtmlInfoExtractor(htmlFile);
                    if (!isIndexFile || settings == null) break block17;
                    htmlInfoExtractor.setTitlePrefix(settings.getParameterValue("tocTitlePrefix"));
                    htmlInfoExtractor.setTitleSuffix(settings.getParameterValue("tocTitleSuffix"));
                }
                catch (ParserConfigurationException | SaxonApiException | SAXException e) {
                    this.errorHandler.error(new OxygenZendeskException("Could not parse " + htmlFile, e));
                    continue;
                }
            }
            try {
                List<String> xrefs = htmlInfoExtractor.getAllCrossRefHrefs();
                if (!xrefs.isEmpty()) {
                    htmlFilepathToXRefValues.put(htmlFileRelativePath, xrefs);
                }
            }
            catch (SaxonApiException e) {
                this.errorHandler.error(new OxygenZendeskException("Could not extract cross references from " + htmlFile, e));
            }
            try {
                int position = i + 1;
                ArticleMetadata articleMetadata = metadata.get(htmlFileRelativePath);
                boolean createArticle = true;
                if (articleMetadata != null) {
                    long existingArticleID = articleMetadata.getArticleID();
                    boolean updatedArticle = this.updateArticle(baseDir, existingArticleID, userSegmentID, htmlFile.toPath(), htmlFileRelativePath, htmlInfoExtractor, metadata, position);
                    boolean bl = createArticle = !updatedArticle;
                }
                if (!createArticle) continue;
                ArrayList<String> labels = null;
                if (isIndexFile) {
                    labels = new ArrayList<String>(1);
                    labels.add(TOC_LABEL_VALUE);
                }
                this.createArticle(baseDir, sectionID, permissionGroupID, userSegmentID, position, htmlFile.toPath(), isCreateDrafts, metadata, htmlInfoExtractor, labels);
                continue;
            }
            catch (OxygenZendeskException ex) {
                this.errorHandler.error(ex);
            }
        }
        if (!toDelete.isEmpty()) {
            this.archiveArticles(toDelete, metadata);
        }
        if (!htmlFilepathToXRefValues.isEmpty()) {
            this.updateXrefHrefs(htmlFilepathToXRefValues, metadata);
        }
        try {
            this.updateRemoteMetadata(sectionID, metadataArticle, permissionGroupID, metadata);
        }
        catch (JsonProcessingException | IllegalArgumentException | ZendeskException e) {
            this.errorHandler.error(new OxygenZendeskException("Could not update remote metadata."));
        }
    }

    private void updateRemoteMetadata(long sectionID, Article metadataArticle, long permissionGroupID, Map<String, ArticleMetadata> metadata) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        String jsonMetadata = mapper.writerWithDefaultPrettyPrinter().writeValueAsString(metadata);
        String body = "<div><p>This article is used to store Oxygen metadata, such as which article ID corresponds to which HTML file. This article must not be deleted.</p><pre>" + jsonMetadata + "</pre></div>";
        if (metadataArticle == null) {
            metadataArticle = new Article();
            metadataArticle.setTitle(METADATA_ARTICLE_NAME);
            metadataArticle.setBody(body);
            metadataArticle.setDraft(Boolean.valueOf(true));
            metadataArticle.setSectionId(Long.valueOf(sectionID));
            metadataArticle.setPermissionGroupId(Long.valueOf(permissionGroupID));
            this.zendeskAccess.createArticle(metadataArticle);
        } else {
            this.updateArticleTranslation(metadataArticle.getId(), metadataArticle.getLocale(), null, body);
        }
    }

    Article getMetadataArticle(long sectionID) {
        Article metadataArticle = null;
        Iterable articles = this.zendeskAccess.getArticles(this.zendeskAccess.getSection(sectionID));
        for (Article article : articles) {
            if (!METADATA_ARTICLE_NAME.equals(article.getTitle())) continue;
            metadataArticle = article;
            break;
        }
        return metadataArticle;
    }

    private void archiveArticles(Set<String> toDelete, Map<String, ArticleMetadata> metadata) {
        for (String filepath : toDelete) {
            ArticleMetadata articleMetadata = metadata.get(filepath);
            if (articleMetadata == null) continue;
            long articleID = articleMetadata.getArticleID();
            Article article = null;
            try {
                article = this.zendeskAccess.getArticle(articleID);
            }
            catch (ZendeskException e) {
                this.errorHandler.error(new OxygenZendeskException("Cannot retrieve article for ID " + articleID, e));
            }
            if (article == null) continue;
            try {
                this.progressTracker.eventHappened(new ProgressEvent("Archiving article '" + article.getHtmlUrl() + "'..."));
                this.zendeskAccess.deleteArticle(article);
                metadata.remove(filepath);
                this.progressTracker.eventHappened(new ProgressEvent("Article archived."));
            }
            catch (IllegalArgumentException | ZendeskException e) {
                this.errorHandler.error(new OxygenZendeskException("Cannot delete article " + article.getTitle() + " " + articleID, e));
            }
        }
    }

    private void updateXrefHrefs(Map<String, List<String>> htmlFilepathToXRefValues, Map<String, ArticleMetadata> metadata) {
        Set<Map.Entry<String, List<String>>> entrySet = htmlFilepathToXRefValues.entrySet();
        for (Map.Entry<String, List<String>> entry : entrySet) {
            String htmlFilepath = entry.getKey();
            ArticleMetadata articleMetadata = metadata.get(htmlFilepath);
            if (articleMetadata != null) {
                long articleID = articleMetadata.getArticleID();
                Article article = null;
                try {
                    article = this.zendeskAccess.getArticle(articleID);
                }
                catch (ZendeskException e) {
                    this.errorHandler.error(new OxygenZendeskException("Cannot retrieve article for ID " + articleID, e));
                    continue;
                }
                List<String> hrefs = entry.getValue();
                if (article == null || hrefs.isEmpty()) continue;
                String initialArticleBody = article.getBody();
                String updatedArticleBody = this.getArticleBodyWithUpdatedXrefHrefs(initialArticleBody, hrefs, htmlFilepath, metadata);
                boolean isBodyChanged = initialArticleBody != null && !initialArticleBody.equals(updatedArticleBody);
                if (!isBodyChanged) continue;
                try {
                    this.updateArticleTranslation(articleID, article.getLocale(), null, updatedArticleBody);
                }
                catch (IllegalArgumentException | ZendeskException e) {
                    this.errorHandler.error(new OxygenZendeskException("Cannot update article " + article.getTitle() + " " + article.getId(), e));
                }
                continue;
            }
            this.errorHandler.error(new OxygenZendeskException("Cannot retrieve article metadata for " + htmlFilepath));
        }
    }

    private Translation updateArticleTranslation(long articleID, String articleLocale, String newArticleTitle, String newArticleBody) {
        Translation translation = OxygenZendeskUtil.getTranslationForArticleLocale(articleLocale, articleID, this.zendeskAccess);
        if (translation != null) {
            if (newArticleBody != null) {
                translation.setBody(newArticleBody);
            }
            if (newArticleTitle != null) {
                translation.setTitle(newArticleTitle);
            }
            return this.zendeskAccess.updateArticleTranslation(Long.valueOf(articleID), articleLocale, translation);
        }
        return null;
    }

    private String getArticleBodyWithUpdatedXrefHrefs(String body, List<String> hrefs, String htmlFilepath, Map<String, ArticleMetadata> metadata) {
        for (String href : hrefs) {
            ArticleMetadata articleMetadata;
            if (href.startsWith("#")) continue;
            String refFilePath = ZendeskRepositoryManager.getFilePathRelativeToURLPath(htmlFilepath, href);
            int indexOfHashSign = refFilePath.indexOf(35);
            String anchor = "";
            if (indexOfHashSign != -1) {
                anchor = refFilePath.substring(indexOfHashSign);
                refFilePath = refFilePath.substring(0, indexOfHashSign);
            }
            if ((articleMetadata = metadata.get(refFilePath)) != null) {
                long refArticleID = articleMetadata.getArticleID();
                body = body.replace(href, this.zendeskHost + "/hc/en-us/articles/" + refArticleID + anchor);
                continue;
            }
            this.errorHandler.error(new OxygenZendeskException("Could not retrieve article metadata for: " + refFilePath));
        }
        return body;
    }

    static String getFilePathRelativeToURLPath(String htmlFilepath, String href) {
        Path hrefPath = Paths.get(htmlFilepath, new String[0]).resolveSibling(Paths.get(URLUtil.uncorrect((String)href), new String[0])).normalize();
        return OxygenZendeskUtil.rewritePathSeparators(hrefPath.toString());
    }

    Map<String, ArticleMetadata> getMetadata(Article metadataArticle) {
        if (metadataArticle != null) {
            String body = metadataArticle.getBody();
            Processor processor = new Processor(false);
            try {
                SAXParser sp = SAXParserFactory.newInstance().newSAXParser();
                XMLReader reader = sp.getXMLReader();
                reader.setEntityResolver((publicId, systemId) -> new InputSource(new StringReader("")));
                SAXSource source = new SAXSource(reader, new InputSource(new StringReader(body)));
                XdmNode xdm = processor.newDocumentBuilder().build((Source)source);
                XPathCompiler xPathCompiler = processor.newXPathCompiler();
                XdmValue result = xPathCompiler.evaluate("//*:div/*:pre[1]/text()", (XdmItem)xdm);
                String jsonString = result.getUnderlyingValue().getStringValue();
                ObjectMapper mapper = new ObjectMapper();
                TypeFactory typeFactory = mapper.getTypeFactory();
                MapType mapType = typeFactory.constructMapType(HashMap.class, String.class, ArticleMetadata.class);
                return new DecodedFilePathKeyHashMap<ArticleMetadata>((Map)mapper.readValue(jsonString, (JavaType)mapType));
            }
            catch (JsonProcessingException | ParserConfigurationException | SaxonApiException | XPathException | SAXException e) {
                this.errorHandler.error(new OxygenZendeskException("Could not read metadata.", e));
            }
        }
        return new DecodedFilePathKeyHashMap<ArticleMetadata>();
    }

    private void createArticle(File baseDir, long sectionID, long permissionGroupID, long userSegmentID, long position, Path htmlFilePath, boolean isCreateDrafts, Map<String, ArticleMetadata> metadata, HtmlInfoExtractor htmlInfoExtractor, List<String> labelNames) throws OxygenZendeskException {
        try {
            String htmlFileRelativePath = ZendeskRepositoryManager.getRelativeFilePath(baseDir, htmlFilePath);
            this.progressTracker.eventHappened(new ProgressEvent("Creating article for '" + htmlFileRelativePath + "'..."));
            String title = htmlInfoExtractor.getTitle();
            if (title != null && !title.isEmpty()) {
                Article articleToCreate = new Article();
                articleToCreate.setSectionId(Long.valueOf(sectionID));
                articleToCreate.setPosition(Long.valueOf(position));
                articleToCreate.setDraft(Boolean.valueOf(isCreateDrafts));
                articleToCreate.setTitle(title);
                articleToCreate.setBody(htmlInfoExtractor.getBody());
                articleToCreate.setPermissionGroupId(Long.valueOf(permissionGroupID));
                if (userSegmentID != -1L) {
                    articleToCreate.setUserSegmentId(Long.valueOf(userSegmentID));
                }
                if (labelNames != null) {
                    articleToCreate.setLabelNames(labelNames);
                }
                Article createdArticle = this.zendeskAccess.createArticle(articleToCreate);
                this.progressTracker.eventHappened(new ProgressEvent("Article created: " + createdArticle.getHtmlUrl()));
                ArticleMetadata articleMetadata = new ArticleMetadata();
                articleMetadata.setArticleID(createdArticle.getId());
                articleMetadata.setPosition(position);
                this.addMD5ToArticleMetadata(htmlFilePath, htmlFileRelativePath, articleMetadata);
                metadata.put(htmlFileRelativePath, articleMetadata);
                this.addAttachmentsToArticle(baseDir, createdArticle, htmlFilePath, htmlInfoExtractor, metadata);
            }
        }
        catch (IllegalArgumentException | SaxonApiException | XPathException | ZendeskException e) {
            throw new OxygenZendeskException("Could not create Zendesk article for " + htmlFilePath, e);
        }
    }

    static String getRelativeFilePath(File baseDir, Path filePath) {
        String htmlFileRelativePath = baseDir.toPath().relativize(filePath).normalize().toString();
        return OxygenZendeskUtil.rewritePathSeparators(htmlFileRelativePath);
    }

    private void addMD5ToArticleMetadata(Path htmlFilePath, String htmlFileRelativePath, ArticleMetadata articleMetadata) {
        try {
            articleMetadata.setHtmlFileMD5(this.getMD5(htmlFilePath));
        }
        catch (IOException | NoSuchAlgorithmException e) {
            this.errorHandler.error(new OxygenZendeskException("Could not compute MD5 for HTML file " + htmlFileRelativePath, e));
            articleMetadata.setHtmlFileMD5("");
        }
    }

    private String getMD5(Path htmlFilePath) throws NoSuchAlgorithmException, IOException {
        MessageDigest md = MessageDigest.getInstance("MD5");
        md.update(Files.readAllBytes(htmlFilePath));
        return DatatypeConverter.printHexBinary((byte[])md.digest());
    }

    private boolean updateArticle(File baseDir, long existingArticleID, long userSegmentID, Path htmlFilePath, String htmlFileRelativePath, HtmlInfoExtractor htmlInfoExtractor, Map<String, ArticleMetadata> metadata, long position) throws OxygenZendeskException {
        if (this.shouldSkipUpdatingArticle(baseDir, htmlFilePath, htmlFileRelativePath, metadata, position)) {
            return true;
        }
        try {
            Article existingArticle = this.zendeskAccess.getArticle(existingArticleID);
            if (existingArticle != null) {
                Translation updatedTranslation;
                boolean isBodyChanged;
                this.progressTracker.eventHappened(new ProgressEvent("Updating article '" + existingArticle.getHtmlUrl() + "'..."));
                if (position != existingArticle.getPosition()) {
                    existingArticle.setPosition(Long.valueOf(position));
                    if (userSegmentID != -1L) {
                        existingArticle.setUserSegmentId(Long.valueOf(userSegmentID));
                    }
                    this.zendeskAccess.updateArticle(existingArticle);
                    this.progressTracker.eventHappened(new ProgressEvent("Article position updated."));
                    ArticleMetadata newArticleMetadata = metadata.get(htmlFileRelativePath);
                    if (newArticleMetadata != null) {
                        newArticleMetadata.setPosition(position);
                    }
                }
                Map<String, ResourceMetadata> resourcesMetadata = metadata.get(htmlFileRelativePath).getResourcesMetadata();
                ArrayList<String> oldResourcePaths = new ArrayList<String>();
                if (resourcesMetadata != null) {
                    oldResourcePaths.addAll(resourcesMetadata.keySet());
                }
                List<String> currentResourceReferences = this.getResourceReferences(htmlInfoExtractor);
                String newTitle = htmlInfoExtractor.getTitle();
                String newBody = this.updateResourceReferenceValues(baseDir, existingArticleID, htmlInfoExtractor.getBody(), htmlFilePath, currentResourceReferences, metadata);
                boolean isTitleChanged = !newTitle.equals(existingArticle.getTitle());
                boolean bl = isBodyChanged = !newBody.equals(existingArticle.getBody());
                if ((isTitleChanged || isBodyChanged) && (updatedTranslation = this.updateArticleTranslation(existingArticleID, existingArticle.getLocale(), newTitle, newBody)) != null) {
                    if (resourcesMetadata != null) {
                        List resRefsRelativeToBaseDir = currentResourceReferences.stream().map(resFilePath -> {
                            Path resPath = htmlFilePath.resolveSibling((String)resFilePath);
                            Path resPathRelativeToBaseDir = baseDir.toPath().relativize(resPath).normalize();
                            return OxygenZendeskUtil.rewritePathSeparators(resPathRelativeToBaseDir.toString());
                        }).collect(Collectors.toList());
                        oldResourcePaths.removeAll(resRefsRelativeToBaseDir);
                        for (String orphanPath : oldResourcePaths) {
                            long attachmentID = resourcesMetadata.get(orphanPath).getAttachmentID();
                            this.tryDeleteAttachment(attachmentID);
                        }
                    }
                    this.updateArticleMetadataMap(baseDir, htmlFilePath, htmlFileRelativePath, metadata, oldResourcePaths);
                    Object progressMessage = "Article updated.";
                    if (isTitleChanged) {
                        String newHtmlUrl = this.zendeskAccess.getArticle(existingArticleID).getHtmlUrl();
                        progressMessage = (String)progressMessage + " Changed HTML URL to '" + newHtmlUrl + "'.";
                    }
                    this.progressTracker.eventHappened(new ProgressEvent((String)progressMessage));
                }
                return true;
            }
            this.progressTracker.eventHappened(new ProgressEvent("Article with ID '" + existingArticleID + "' not found on Zendesk."));
            return false;
        }
        catch (IllegalArgumentException | SaxonApiException | XPathException | ZendeskException e) {
            throw new OxygenZendeskException("Could not update article with ID " + existingArticleID, e);
        }
    }

    private void tryDeleteAttachment(long attachmentID) {
        try {
            this.zendeskAccess.deleteArticleAttachment(attachmentID);
        }
        catch (ZendeskException e) {
            this.errorHandler.error(new OxygenZendeskException("Could not delete attachment widh ID " + attachmentID));
        }
    }

    private void updateArticleMetadataMap(File baseDir, Path htmlFilePath, String htmlFileRelativePath, Map<String, ArticleMetadata> metadata, List<String> deletedResources) {
        ArticleMetadata newArticleMetadata = metadata.get(htmlFileRelativePath);
        this.addMD5ToArticleMetadata(htmlFilePath, htmlFileRelativePath, newArticleMetadata);
        Map<String, ResourceMetadata> resourcesMetadata = newArticleMetadata.getResourcesMetadata();
        if (resourcesMetadata != null) {
            Set<Map.Entry<String, ResourceMetadata>> entrySet = resourcesMetadata.entrySet();
            for (Map.Entry<String, ResourceMetadata> entry : entrySet) {
                String resRelativePath = entry.getKey();
                ResourceMetadata resMetadata = entry.getValue();
                String remoteResMD5 = resMetadata.getResourceFileMD5();
                String localResMD5 = "";
                try {
                    localResMD5 = this.getMD5(new File(baseDir, resRelativePath).toPath());
                    if (localResMD5.equals(remoteResMD5)) continue;
                    resMetadata.setResourceFileMD5(localResMD5);
                    entry.setValue(resMetadata);
                }
                catch (IOException | NoSuchAlgorithmException e) {
                    this.errorHandler.error(new OxygenZendeskException("Could not compute MD5 for resource " + resRelativePath, e));
                }
            }
            for (String path : deletedResources) {
                resourcesMetadata.remove(path);
            }
        }
        metadata.put(htmlFileRelativePath, newArticleMetadata);
    }

    private boolean shouldSkipUpdatingArticle(File baseDir, Path htmlFilePath, String htmlFileRelativePath, Map<String, ArticleMetadata> metadata, long newPosition) {
        boolean shouldSkip = true;
        ArticleMetadata articleMetadata = metadata.get(htmlFileRelativePath);
        if (newPosition == articleMetadata.getPosition()) {
            if (!this.isFileChanged(htmlFilePath.toFile(), articleMetadata.getHtmlFileMD5())) {
                Map<String, ResourceMetadata> resourcesMetadata = articleMetadata.getResourcesMetadata();
                if (resourcesMetadata == null) {
                    return true;
                }
                Set<Map.Entry<String, ResourceMetadata>> entrySet = resourcesMetadata.entrySet();
                for (Map.Entry<String, ResourceMetadata> entry : entrySet) {
                    String resRelativePath = entry.getKey();
                    String remoteResMD5 = entry.getValue().getResourceFileMD5();
                    String localResMD5 = "";
                    try {
                        localResMD5 = this.getMD5(new File(baseDir, resRelativePath).toPath());
                        if (localResMD5.equals(remoteResMD5)) continue;
                        shouldSkip = false;
                        break;
                    }
                    catch (IOException | NoSuchAlgorithmException e) {
                        this.errorHandler.error(new OxygenZendeskException("Could not compute MD5 for resource " + resRelativePath, e));
                    }
                }
            } else {
                shouldSkip = false;
            }
        } else {
            shouldSkip = false;
        }
        return shouldSkip;
    }

    private void addAttachmentsToArticle(File baseDir, Article article, Path htmlFilePath, HtmlInfoExtractor htmlInfoExtractor, Map<String, ArticleMetadata> metadata) throws OxygenZendeskException {
        try {
            String initialArticleBody = article.getBody();
            String updatedArticleBody = this.updateResourceReferenceValues(baseDir, article.getId(), initialArticleBody, htmlFilePath, this.getResourceReferences(htmlInfoExtractor), metadata);
            if (initialArticleBody != null && initialArticleBody.equals(updatedArticleBody)) {
                return;
            }
            this.updateArticleTranslation(article.getId(), article.getLocale(), null, updatedArticleBody);
        }
        catch (IllegalArgumentException | SaxonApiException | ZendeskException e) {
            throw new OxygenZendeskException("Could not add attachment to article " + article.getTitle() + " " + article.getId(), e);
        }
    }

    private List<String> getResourceReferences(HtmlInfoExtractor htmlInfoExtractor) throws SaxonApiException {
        ArrayList<String> resourceReferences = new ArrayList<String>();
        resourceReferences.addAll(htmlInfoExtractor.getAllImgSrcValues());
        resourceReferences.addAll(htmlInfoExtractor.getAllAnchorReferencesToResources());
        resourceReferences.addAll(htmlInfoExtractor.getAllObjectDataValues());
        resourceReferences.addAll(htmlInfoExtractor.getAllAudioSrcValues());
        resourceReferences.addAll(htmlInfoExtractor.getAllVideoSrcValues());
        return resourceReferences;
    }

    private String updateResourceReferenceValues(File baseDir, long articleID, String articleBody, Path htmlFilePath, List<String> refs, Map<String, ArticleMetadata> metadata) {
        for (String ref : refs) {
            if (OxygenZendeskUtil.isRemoteResource(ref)) continue;
            File resource = ZendeskRepositoryManager.createFileFromRelativeURLHref(htmlFilePath, ref);
            try {
                ArticleAttachments attachment = this.getAttachmentForResource(baseDir, articleID, htmlFilePath, metadata, resource);
                articleBody = articleBody.replace(ref, this.zendeskHost + "/hc/article_attachments/" + attachment.getId() + "/" + attachment.getFileName());
            }
            catch (IOException | ZendeskException e) {
                this.errorHandler.error(new OxygenZendeskException("Could not create resource '" + resource + "' as attachment!", e));
            }
        }
        return articleBody;
    }

    static File createFileFromRelativeURLHref(Path htmlFilePath, String ref) {
        return htmlFilePath.resolveSibling(Paths.get(URLUtil.uncorrect((String)ref), new String[0])).normalize().toFile();
    }

    private ArticleAttachments getAttachmentForResource(File baseDir, long articleID, Path htmlFilePath, Map<String, ArticleMetadata> metadata, File resource) throws IOException {
        ArticleAttachments attachment = null;
        String htmlRelativePath = ZendeskRepositoryManager.getRelativeFilePath(baseDir, htmlFilePath);
        String resRelativePath = ZendeskRepositoryManager.getRelativeFilePath(baseDir, resource.toPath());
        ArticleMetadata articleMetadata = metadata.get(htmlRelativePath);
        Map<String, ResourceMetadata> resourcesMetadata = articleMetadata.getResourcesMetadata();
        if (resourcesMetadata == null || resourcesMetadata.isEmpty()) {
            attachment = this.zendeskAccess.createUploadArticle(articleID, resource, ZendeskRepositoryManager.isImageRef(resource));
            resourcesMetadata = new DecodedFilePathKeyHashMap<ResourceMetadata>();
            this.addResourceMetadata(resource, resRelativePath, attachment.getId(), resourcesMetadata);
            articleMetadata.setResourcesMetadata(resourcesMetadata);
            metadata.put(htmlRelativePath, articleMetadata);
        } else {
            Optional<ArticleAttachments> attachmentOptional;
            ResourceMetadata resMetadata = resourcesMetadata.get(resRelativePath);
            if (resMetadata != null && (attachmentOptional = this.zendeskAccess.getAttachmentsFromArticle(Long.valueOf(articleID)).stream().filter(at -> at.getId().equals(resMetadata.getAttachmentID())).findAny()).isPresent()) {
                ArticleAttachments existingAttachment = attachmentOptional.get();
                if (!this.isFileChanged(resource, resMetadata.getResourceFileMD5())) {
                    attachment = existingAttachment;
                } else {
                    this.tryDeleteAttachment(existingAttachment.getId());
                }
            }
        }
        if (attachment == null) {
            attachment = this.zendeskAccess.createUploadArticle(articleID, resource, ZendeskRepositoryManager.isImageRef(resource));
            this.addResourceMetadata(resource, resRelativePath, attachment.getId(), resourcesMetadata);
        }
        return attachment;
    }

    private static boolean isImageRef(File resource) {
        String extension = URLUtil.getExtension((String)resource.getName());
        if (extension != null && !extension.isEmpty()) {
            for (int i = 0; i < IMAGE_EXTENSIONS.length; ++i) {
                if (!extension.equalsIgnoreCase(IMAGE_EXTENSIONS[i])) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isFileChanged(File file, String remoteMD5) {
        String localMD5 = "";
        try {
            localMD5 = this.getMD5(file.toPath());
        }
        catch (IOException | NoSuchAlgorithmException e) {
            this.errorHandler.error(new OxygenZendeskException("Could not compute MD5 for file " + file, e));
        }
        return !localMD5.equals(remoteMD5);
    }

    private void addResourceMetadata(File resource, String relativeResPath, long attachmentID, Map<String, ResourceMetadata> resourcesMetadata) throws IOException {
        ResourceMetadata resMetadata = new ResourceMetadata();
        resMetadata.setAttachmentID(attachmentID);
        try {
            resMetadata.setResourceFileMD5(this.getMD5(resource.toPath()));
        }
        catch (NoSuchAlgorithmException e) {
            this.errorHandler.error(new OxygenZendeskException("Could not compute MD5 for resource " + resource, e));
            resMetadata.setResourceFileMD5("");
        }
        resourcesMetadata.put(relativeResPath, resMetadata);
    }

    Category createCategory(String name, String description, long position) throws OxygenZendeskException {
        Category newCategory = new Category();
        newCategory.setName(name);
        newCategory.setDescription(description);
        newCategory.setPosition(Long.valueOf(position));
        Category createdCategory = null;
        try {
            createdCategory = this.zendeskAccess.createCategory(newCategory);
        }
        catch (ZendeskException e) {
            throw new OxygenZendeskException("Could not create category.", e);
        }
        return createdCategory;
    }

    Section createSection(long categoryID, String name, String description, long position) throws OxygenZendeskException {
        Section newSection = new Section();
        newSection.setCategoryId(Long.valueOf(categoryID));
        newSection.setName(name);
        newSection.setDescription(description);
        newSection.setPosition(Long.valueOf(position));
        Section createdSection = null;
        try {
            createdSection = this.zendeskAccess.createSection(newSection);
        }
        catch (IllegalArgumentException | ZendeskException e) {
            throw new OxygenZendeskException("Could not create section.", e);
        }
        return createdSection;
    }

    void initZendesk(String zendeskHost, String username, String token) {
        this.zendeskHost = zendeskHost;
        DefaultAsyncHttpClientConfig clientConfig = new DefaultAsyncHttpClientConfig.Builder().setUseProxyProperties(true).build();
        DefaultAsyncHttpClient client = new DefaultAsyncHttpClient((AsyncHttpClientConfig)clientConfig);
        this.zendeskAccess = new Zendesk.Builder(zendeskHost).setClient((AsyncHttpClient)client).setUsername(username).setToken(token).build();
    }

    void clearOutPublishedContent() {
        Iterable categories = this.zendeskAccess.getCategories();
        for (Category category : categories) {
            try {
                this.zendeskAccess.deleteCategory(category);
            }
            catch (IllegalArgumentException | ZendeskException e) {
                this.errorHandler.error(new OxygenZendeskException("Cannot delete category " + category.getName() + " " + category.getId(), e));
            }
        }
    }

    public Zendesk getZendeskAccess() {
        return this.zendeskAccess;
    }

    void setZendeskAccess(Zendesk zendeskAccess) {
        this.zendeskAccess = zendeskAccess;
    }

    private final class DecodedFilePathKeyHashMap<V>
    extends HashMap<String, V> {
        public DecodedFilePathKeyHashMap() {
        }

        public DecodedFilePathKeyHashMap(Map<String, ? extends V> m) {
            super(m);
        }

        @Override
        public V put(String key, V value) {
            return super.put(this.getDecodedKey(key), value);
        }

        @Override
        public V putIfAbsent(String key, V value) {
            return super.putIfAbsent(this.getDecodedKey(key), value);
        }

        @Override
        public void putAll(Map<? extends String, ? extends V> m) {
            for (String string : m.keySet()) {
                this.put(this.getDecodedKey(string), m.get(string));
            }
        }

        @Override
        public V get(Object key) {
            return super.get(this.getDecodedKey((String)key));
        }

        @Override
        public V getOrDefault(Object key, V defaultValue) {
            return super.getOrDefault(this.getDecodedKey((String)key), defaultValue);
        }

        private String getDecodedKey(String key) {
            if (key.indexOf(37) != -1) {
                try {
                    key = URLDecoder.decode(key, StandardCharsets.UTF_8.name());
                }
                catch (UnsupportedEncodingException e) {
                    OxygenZendeskException ex = new OxygenZendeskException("Cannot encode file path!", e);
                    ZendeskRepositoryManager.this.errorHandler.error(ex);
                }
            }
            return key;
        }
    }
}

