/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.basic.xml.pifinder;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import ro.sync.basic.io.NonCloseableReader;
import ro.sync.basic.io.NonCloseableStringReader;
import ro.sync.basic.xml.BasicXmlUtil;
import ro.sync.basic.xml.parser.ContentHandlerAdapter;
import ro.sync.basic.xml.parser.lexer.XMLLexer;
import ro.sync.basic.xml.pifinder.PIConstants;
import ro.sync.basic.xml.schema.SchemaDeclarationInfo;
import ro.sync.basic.xml.schema.SchemaDeclarationLocatorImpl;

public class PIFinder
implements PIConstants {
    private static final Logger logger = LoggerFactory.getLogger((String)PIFinder.class.getName());
    private static final String XSLT_CONTENT_TYPE = "text/xslt";
    private static final String XSLT_CONTENT_TYPE_2_0 = "application/xslt+xml";
    private static final String CSS_CONTENT_TYPE = "text/css";
    PIFinderResult[] matchedUrls;
    private List<String> phases = new ArrayList<String>();
    private PIFinderResult detectedDTD;
    private String stylesheetMatchedURL;

    public PIFinderResult getDetectedDTD() {
        return this.detectedDTD;
    }

    public PIFinderResult[] getMatchedUrls() {
        return this.matchedUrls;
    }

    public String[] getPhases() {
        return this.phases.toArray(new String[0]);
    }

    public PIFinder(NonCloseableReader snapshotReader, int kind) {
        switch (kind) {
            case 0: {
                this.matchedUrls = this.getRelaxNGSchemaMatch(snapshotReader, true);
                break;
            }
            case 1: {
                this.matchedUrls = this.getRelaxNGSchemaMatch(snapshotReader, false);
                break;
            }
            case 3: {
                this.matchedUrls = this.getNVDLSchemaMatch(snapshotReader);
                break;
            }
            case 6: {
                this.matchedUrls = this.getSchematronMatch(snapshotReader);
                break;
            }
            case 8: {
                this.matchedUrls = this.getXMLModelSchemaMatch(snapshotReader, 8);
                break;
            }
            case 4: {
                this.stylesheetMatchedURL = this.getStylesheetMatch(snapshotReader, false);
                break;
            }
            case 7: {
                this.stylesheetMatchedURL = this.getStylesheetMatch(snapshotReader, true);
                break;
            }
            case 5: {
                PIFinderResult[] dtdSchemaMatch = this.getDTDSchemaMatch(snapshotReader);
                this.detectedDTD = dtdSchemaMatch != null ? dtdSchemaMatch[0] : null;
                this.matchedUrls = this.getXMLModelSchemaMatch(snapshotReader, 5);
            }
        }
    }

    private PIFinderResult[] getDTDSchemaMatch(NonCloseableReader snapshot) {
        String target = "oxygen";
        String systemAttrName = "DTDSystemID";
        String publicAttrName = "DTDPublicID";
        List<MatchedAttributeValues> matchedAttrValuesWithLocation = PIFinder.getMatchedAttrValuesWithLocation(snapshot, target, new String[]{systemAttrName, publicAttrName});
        ArrayList<PIFinderResult> detecteDTDs = new ArrayList<PIFinderResult>();
        for (MatchedAttributeValues matchedAttributeValues : matchedAttrValuesWithLocation) {
            detecteDTDs.add(new PIFinderResult(matchedAttributeValues.attributeValues.get(systemAttrName), matchedAttributeValues.attributeValues.get(publicAttrName), matchedAttributeValues.nodeLocator));
        }
        return detecteDTDs.isEmpty() ? null : detecteDTDs.toArray(new PIFinderResult[0]);
    }

    private String getStylesheetMatch(NonCloseableReader snapshotReader, boolean isCSS) {
        String foundHref = null;
        String target = "xml-stylesheet";
        String href = "href";
        String type = "type";
        List<Map<String, String>> found = PIFinder.getMatchedAttrValues(snapshotReader, target, new String[]{href, type});
        for (Map<String, String> mapping : found) {
            String typeValue = mapping.get(type);
            String hrefValue = mapping.get(href);
            if (hrefValue == null || typeValue != null && !(isCSS ? CSS_CONTENT_TYPE.equals(typeValue) : XSLT_CONTENT_TYPE.equals(typeValue) || XSLT_CONTENT_TYPE_2_0.equals(typeValue) || "text/xsl".equals(typeValue))) continue;
            foundHref = hrefValue;
            break;
        }
        return foundHref;
    }

    private PIFinderResult[] getNVDLSchemaMatch(NonCloseableReader snapshot) {
        ArrayList<PIFinderResult> matches = new ArrayList<PIFinderResult>();
        PIFinderResult[] nvdlSchemMatch = this.getOxygenSchemaMatch(snapshot, "NVDLSchema");
        if (nvdlSchemMatch != null && nvdlSchemMatch.length > 0) {
            matches.addAll(Arrays.asList(nvdlSchemMatch));
        }
        snapshot.rewind();
        nvdlSchemMatch = this.getXMLModelSchemaMatch(snapshot, 3);
        if (nvdlSchemMatch != null && nvdlSchemMatch.length > 0) {
            matches.addAll(Arrays.asList(nvdlSchemMatch));
        }
        return matches.isEmpty() ? null : matches.toArray(new PIFinderResult[0]);
    }

    private PIFinderResult[] getOxygenSchemaMatch(NonCloseableReader snapshotReader, String attrName) {
        String target = "oxygen";
        PIFinderResult[] foundHrefs = null;
        List<MatchedAttributeValues> found = PIFinder.getMatchedAttrValuesWithLocation(snapshotReader, target, new String[]{attrName});
        if (found.size() != 0) {
            ArrayList<PIFinderResult> schemaRefs = new ArrayList<PIFinderResult>(found.size());
            for (int i = 0; i < found.size(); ++i) {
                MatchedAttributeValues matchedAttributeValues = found.get(i);
                Map<String, String> mapping = matchedAttributeValues.attributeValues;
                String schemaRef = mapping.get(attrName);
                if (schemaRef == null) continue;
                schemaRefs.add(new PIFinderResult(schemaRef, matchedAttributeValues.nodeLocator));
            }
            if (schemaRefs.size() != 0) {
                foundHrefs = schemaRefs.toArray(new PIFinderResult[0]);
            }
        }
        return foundHrefs;
    }

    private PIFinderResult[] getOxygenRNGSchemaMatch(NonCloseableReader snapshotReader, boolean isCompact) {
        String target = "oxygen";
        String attrName = "RNGSchema";
        String attrType = "type";
        PIFinderResult[] foundHrefs = null;
        List<MatchedAttributeValues> found = PIFinder.getMatchedAttrValuesWithLocation(snapshotReader, target, new String[]{attrName, attrType});
        if (found.size() != 0) {
            ArrayList<PIFinderResult> schemaRefs = new ArrayList<PIFinderResult>(found.size());
            for (int i = 0; i < found.size(); ++i) {
                MatchedAttributeValues matchedAttributeValues = found.get(i);
                Map<String, String> mapping = matchedAttributeValues.attributeValues;
                String schemaRef = mapping.get(attrName);
                String schemaType = mapping.get(attrType);
                if (schemaRef == null || schemaType == null || !schemaType.equals("compact") && !schemaType.equals("xml") || schemaType.equals("compact") != isCompact) continue;
                schemaRefs.add(new PIFinderResult(schemaRef, matchedAttributeValues.nodeLocator));
            }
            if (schemaRefs.size() != 0) {
                foundHrefs = schemaRefs.toArray(new PIFinderResult[0]);
            }
        }
        return foundHrefs;
    }

    private PIFinderResult[] getXMLModelSchemaMatch(NonCloseableReader snapshotReader, int sType) {
        String target = "xml-model";
        String attrHref = "href";
        String attrType = "type";
        String attrSchemaTypeNS = "schematypens";
        String attrPhase = "phase";
        PIFinderResult[] foundHrefs = null;
        List<MatchedAttributeValues> found = PIFinder.getMatchedAttrValuesWithLocation(snapshotReader, target, new String[]{attrHref, attrType, attrSchemaTypeNS, attrPhase});
        if (found.size() != 0) {
            ArrayList<PIFinderResult> schemaRefs = new ArrayList<PIFinderResult>(found.size());
            block8: for (int i = 0; i < found.size(); ++i) {
                MatchedAttributeValues matchedAttributeValues = found.get(i);
                Map<String, String> mapping = matchedAttributeValues.attributeValues;
                String schemaRef = mapping.get(attrHref);
                String schemaType = mapping.get(attrType);
                String schemaTypeNS = mapping.get(attrSchemaTypeNS);
                String phase = mapping.get(attrPhase);
                if (schemaRef == null) continue;
                switch (sType) {
                    case 1: {
                        if (schemaType != null && !schemaType.equals("application/xml") || !"http://relaxng.org/ns/structure/1.0".equals(schemaTypeNS) && (schemaTypeNS != null || !schemaRef.toLowerCase().endsWith(".rng"))) continue block8;
                        schemaRefs.add(new PIFinderResult(schemaRef, matchedAttributeValues.nodeLocator));
                        continue block8;
                    }
                    case 0: {
                        if (!"application/relax-ng-compact-syntax".equals(schemaType) && (schemaType != null || !schemaRef.toLowerCase().endsWith(".rnc"))) continue block8;
                        schemaRefs.add(new PIFinderResult(schemaRef, matchedAttributeValues.nodeLocator));
                        continue block8;
                    }
                    case 8: {
                        if (schemaType != null && !schemaType.equals("application/xml") || !"http://www.w3.org/2001/XMLSchema".equals(schemaTypeNS) && (schemaTypeNS != null || !schemaRef.toLowerCase().endsWith(".xsd"))) continue block8;
                        schemaRefs.add(new PIFinderResult(schemaRef, matchedAttributeValues.nodeLocator));
                        continue block8;
                    }
                    case 3: {
                        if (schemaType != null && !schemaType.equals("application/xml") || !"http://purl.oclc.org/dsdl/nvdl/ns/structure/1.0".equals(schemaTypeNS) && (schemaTypeNS != null || !schemaRef.toLowerCase().endsWith(".nvdl"))) continue block8;
                        schemaRefs.add(new PIFinderResult(schemaRef, matchedAttributeValues.nodeLocator));
                        continue block8;
                    }
                    case 6: {
                        if (schemaType != null && !schemaType.equals("application/xml") || !"http://purl.oclc.org/dsdl/schematron".equals(schemaTypeNS) && (schemaTypeNS != null || !schemaRef.toLowerCase().endsWith(".sch"))) continue block8;
                        schemaRefs.add(new PIFinderResult(schemaRef, matchedAttributeValues.nodeLocator));
                        if (phase == null) continue block8;
                        this.phases.add(phase);
                        continue block8;
                    }
                    case 5: {
                        if (schemaType != null && !schemaType.equals("application/xml-dtd") || schemaTypeNS != null || !schemaRef.toLowerCase().endsWith(".dtd")) continue block8;
                        schemaRefs.add(new PIFinderResult(schemaRef, matchedAttributeValues.nodeLocator));
                    }
                }
            }
            if (schemaRefs.size() != 0) {
                foundHrefs = schemaRefs.toArray(new PIFinderResult[0]);
            }
        }
        return foundHrefs;
    }

    private PIFinderResult[] getRelaxNGSchemaMatch(NonCloseableReader snapshot, boolean isCompact) {
        ArrayList<PIFinderResult> matches = new ArrayList<PIFinderResult>();
        PIFinderResult[] rncSchemMatch = this.getOxygenRNGSchemaMatch(snapshot, isCompact);
        if (rncSchemMatch != null && rncSchemMatch.length > 0) {
            matches.addAll(Arrays.asList(rncSchemMatch));
        }
        snapshot.rewind();
        rncSchemMatch = this.getXMLModelSchemaMatch(snapshot, isCompact ? 0 : 1);
        if (rncSchemMatch != null && rncSchemMatch.length > 0) {
            matches.addAll(Arrays.asList(rncSchemMatch));
        }
        return matches.isEmpty() ? null : matches.toArray(new PIFinderResult[0]);
    }

    private PIFinderResult[] getSchematronMatch(NonCloseableReader snapshot) {
        ArrayList<PIFinderResult> matches = new ArrayList<PIFinderResult>();
        PIFinderResult[] nvdlSchemMatch = this.getOxygenSchemaMatch(snapshot, "SCHSchema");
        if (nvdlSchemMatch != null && nvdlSchemMatch.length > 0) {
            matches.addAll(Arrays.asList(nvdlSchemMatch));
            for (int i = 0; i < nvdlSchemMatch.length; ++i) {
                this.phases.add(null);
            }
        }
        snapshot.rewind();
        nvdlSchemMatch = this.getXMLModelSchemaMatch(snapshot, 6);
        if (nvdlSchemMatch != null && nvdlSchemMatch.length > 0) {
            matches.addAll(Arrays.asList(nvdlSchemMatch));
        }
        return matches.isEmpty() ? null : matches.toArray(new PIFinderResult[0]);
    }

    public PIFinder(Document document, int kind) {
        ProcessingInstruction pi = PIFinder.getOxygenPI(document);
        if (pi != null) {
            String data = pi.getData();
            String snapshot = "<?oxygen " + data + "?>";
            if (logger.isDebugEnabled()) {
                logger.debug("Parsing:" + snapshot);
            }
            PIFinder finder = new PIFinder(new NonCloseableStringReader(snapshot), kind);
            this.matchedUrls = finder.matchedUrls;
        }
    }

    private static ProcessingInstruction getOxygenPI(Document document) {
        for (Node currentNode = document.getFirstChild(); currentNode != null; currentNode = currentNode.getNextSibling()) {
            if (currentNode.getNodeType() != 7 || !currentNode.getNodeName().equals("oxygen")) continue;
            return (ProcessingInstruction)currentNode;
        }
        return null;
    }

    public String getStylesheetMatchedURL() {
        return this.stylesheetMatchedURL;
    }

    private static List<Map<String, String>> getMatchedAttrValues(NonCloseableReader snapshotReader, String piName, String[] attrNames) {
        List<MatchedAttributeValues> matchedAttrValuesWithLocation = PIFinder.getMatchedAttrValuesWithLocation(snapshotReader, piName, attrNames);
        ArrayList<Map<String, String>> attrValues = new ArrayList<Map<String, String>>();
        for (MatchedAttributeValues matchedAttributeValues : matchedAttrValuesWithLocation) {
            attrValues.add(matchedAttributeValues.attributeValues);
        }
        return attrValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<MatchedAttributeValues> getMatchedAttrValuesWithLocation(NonCloseableReader snapshotReader, final String piName, final String[] attrNames) {
        final ArrayList<MatchedAttributeValues> piFoundList = new ArrayList<MatchedAttributeValues>(2);
        XMLLexer parser = new XMLLexer();
        ContentHandlerAdapter handler = new ContentHandlerAdapter(){
            int piIndex = 0;

            @Override
            public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
                throw new SAXException("Ended.");
            }

            @Override
            public void processingInstruction(String target, String data) throws SAXException {
                if (target.equals(piName)) {
                    HashMap<String, String> attrNamesToValuesMap = new HashMap<String, String>();
                    for (int i = 0; i < attrNames.length; ++i) {
                        String attrName = attrNames[i];
                        String attrValue = BasicXmlUtil.getFromPIDataPseudoAttribute(data, attrName, true);
                        attrNamesToValuesMap.put(attrName, attrValue);
                    }
                    piFoundList.add(new MatchedAttributeValues(attrNamesToValuesMap, new SchemaDeclarationLocatorImpl(this.piIndex, (String)attrNamesToValuesMap.get("href"))));
                }
                if (!"xml".equals(target)) {
                    ++this.piIndex;
                }
            }
        };
        parser.setContentHandler(handler);
        try {
            snapshotReader.rewind();
            parser.setProperty("http://xml.org/sax/properties/lexical-handler", handler);
            parser.parse(new InputSource(snapshotReader));
        }
        catch (IOException iOException) {
        }
        catch (SAXException sAXException) {
        }
        catch (Throwable throwable) {
        }
        finally {
            snapshotReader.rewind();
        }
        return piFoundList;
    }

    public static String getHeaderEncoding(NonCloseableReader reader) {
        String encoding = null;
        String target = "xml";
        String attrName = "encoding";
        List<Map<String, String>> found = PIFinder.getMatchedAttrValues(reader, target, new String[]{attrName});
        if (found.size() > 0 && (encoding = found.get(0).get(attrName)) == null) {
            encoding = "";
        }
        return encoding;
    }

    public static class PIFinderResult {
        public final String systemID;
        public final String publicID;
        public final SchemaDeclarationInfo locator;

        public PIFinderResult(String schemaRef, SchemaDeclarationInfo nodeLocator) {
            this(schemaRef, null, nodeLocator);
        }

        public PIFinderResult(String schemaRef, String publicID, SchemaDeclarationInfo nodeLocator) {
            this.systemID = schemaRef;
            this.publicID = publicID;
            this.locator = nodeLocator;
        }
    }

    private static class MatchedAttributeValues {
        private final Map<String, String> attributeValues;
        private final SchemaDeclarationInfo nodeLocator;

        public MatchedAttributeValues(Map<String, String> attrNamesToValuesMap, SchemaDeclarationLocatorImpl nodeLocatorImpl) {
            this.attributeValues = attrNamesToValuesMap;
            this.nodeLocator = nodeLocatorImpl;
        }
    }
}

