/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.basic.xml.encoding;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Set;
import java.util.TreeSet;
import ro.sync.basic.xml.encoding.AdditionalEncodingMap;
import ro.sync.basic.xml.encoding.EncodingDetectorImpl;

public class AccessibleEncodingMap {
    private static final String[] java142BasicEncodingSet = new String[]{"US-ASCII", "windows-1250", "windows-1251", "windows-1252", "windows-1253", "windows-1254", "windows-1257"};
    private static final String[] java142ExtendedEncodingSet = new String[]{"windows-1255", "windows-1256", "windows-1258", "ISO-8859-3", "ISO-8859-6", "ISO-8859-8", "windows-31j", "EUC-JP", "x-EUC-JP-LINUX", "Shift_JIS", "ISO-2022-JP", "x-mswin-936", "GB18030", "x-EUC-CN", "GBK", "ISCII91", "x-windows-949", "EUC-KR", "ISO-2022-KR", "x-windows-950", "x-MS950-HKSCS", "x-EUC-TW", "Big5", "Big5-HKSCS", "TIS-620", "MacRoman"};

    public static String[] getSupportedJavaEncodings() {
        int i;
        Hashtable map = AdditionalEncodingMap.getFJava2IANAMap();
        Set keySet = map.keySet();
        TreeSet<Object> encodings = new TreeSet<Object>();
        encodings.addAll(keySet);
        for (i = 0; i < java142BasicEncodingSet.length; ++i) {
            encodings.add(java142BasicEncodingSet[i]);
        }
        for (i = 0; i < java142ExtendedEncodingSet.length; ++i) {
            encodings.add(java142ExtendedEncodingSet[i]);
        }
        encodings.add(new EncodingDetectorImpl().getJavaPlatformEncoding());
        return encodings.toArray(new String[0]);
    }

    public static String[] getSupportedIANAEncodings() {
        ArrayList<String> toReturn = new ArrayList<String>();
        String[] javaEncodings = AccessibleEncodingMap.getSupportedJavaEncodings();
        for (int i = 0; i < javaEncodings.length; ++i) {
            String ianaEncoding = AdditionalEncodingMap.getJava2IANAMapping(javaEncodings[i]);
            if (ianaEncoding == null) continue;
            toReturn.add(ianaEncoding);
        }
        return toReturn.toArray(new String[0]);
    }
}

