/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.basic.xml;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.Transformer;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.dom.NodeImpl;
import org.apache.xerces.util.XMLChar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.UserDataHandler;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.basic.util.Equaler;
import ro.sync.basic.util.NumberFormatException;
import ro.sync.basic.util.NumberParserUtil;
import ro.sync.basic.util.SmallAndFastHashtable;
import ro.sync.basic.xml.ProxyNamespaceMapping;
import ro.sync.basic.xml.UnescapeParseException;
import ro.sync.basic.xml.dom.NodeAdapter;

@SkipObfuscate(classes=SkipLevel.NOT_SPECIFIED, fields=SkipLevel.NOT_SPECIFIED, methods=SkipLevel.PUBLIC)
public class BasicXmlUtil {
    private static Logger logger = LoggerFactory.getLogger((String)BasicXmlUtil.class.getName());
    private static final int SEARCHING_UNESCAPE = 0;
    private static final int START_ENCOUNTERED = 1;
    private static final boolean DEBUG_ENABLED = logger.isDebugEnabled();
    private static EscapeSelectionOptions LT_AND_AMP_ESCAPE_OPTIONS = new EscapeSelectionOptions(true, false, true, false, false, false, true, false, 0, false, false);
    public static final UnescapeSelectionOptions UNESCAPE_EVERYTHING_OPTIONS = new UnescapeSelectionOptions(true, true, true, true, true, true);
    private static final String ATTRIBUTES_REGEX = "([^\\s=<]+)\\s*(=\\s*(\\'[^<\\']*\\'|\"[^<\"]*\"))?";
    private static final Pattern ATRIBUTES_PATTERN = Pattern.compile("([^\\s=<]+)\\s*(=\\s*(\\'[^<\\']*\\'|\"[^<\"]*\"))?");
    public static final String NODES_UD = "U";
    public static final String ORDER = "aord";

    public static String getTextValue(Node node) {
        if (node.getNodeType() == 3) {
            return node.getNodeValue();
        }
        StringBuilder sb = new StringBuilder();
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 3) continue;
            sb.append(child.getNodeValue());
        }
        return sb.toString().trim();
    }

    public static String getAllText(Node node) {
        return BasicXmlUtil.getAllText(node, true);
    }

    public static String getAllText(Node node, boolean includeComments) {
        if (node instanceof NodeImpl) {
            return ((NodeImpl)node).getTextContent();
        }
        if (node.getNodeType() == 3 || node.getNodeType() == 4 || node.getNodeType() == 8 && includeComments) {
            return node.getNodeValue();
        }
        StringBuilder sb = new StringBuilder();
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            sb.append(BasicXmlUtil.getAllText(child, false));
        }
        return sb.toString();
    }

    public static int getAllTextLength(Node node) {
        String str = BasicXmlUtil.getAllText(node);
        if (str != null) {
            return str.length();
        }
        return 0;
    }

    public static int getOffsetOfNode(Node node) {
        Node parent = node.getParentNode();
        if (parent == null) {
            return 0;
        }
        int offset = BasicXmlUtil.getOffsetOfNode(parent);
        for (Node current = parent.getFirstChild(); current != node; current = current.getNextSibling()) {
            offset += BasicXmlUtil.getAllTextLength(current);
        }
        return offset;
    }

    public static void getTextNodes(Node node, List<Node> toPutIn) {
        if (node.getNodeType() == 3) {
            toPutIn.add(node);
        } else {
            for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                BasicXmlUtil.getTextNodes(child, toPutIn);
            }
        }
    }

    static boolean appendLimited(StringBuilder buf, String str, int maxLen) {
        int bLen = buf.length();
        int diff = maxLen - bLen;
        if (diff > 0) {
            if (diff > str.length()) {
                buf.append(str);
                return false;
            }
            buf.append(str.substring(0, diff)).append(" ...");
            return true;
        }
        return true;
    }

    public static List<String> getTextSections(String content) {
        ArrayList<String> textSections = new ArrayList<String>();
        int len = content.length();
        int state = 0;
        StringBuilder buffer = null;
        block4: for (int i = 0; i < len; ++i) {
            switch (state) {
                case 0: {
                    if (content.charAt(i) == '<') {
                        state = 1;
                        if (buffer == null) continue block4;
                        String buf = buffer.toString();
                        textSections.add(buf);
                        buffer.delete(0, buffer.length());
                        continue block4;
                    }
                    if (buffer == null) {
                        buffer = new StringBuilder();
                    }
                    buffer.append(content.charAt(i));
                    continue block4;
                }
                case 1: {
                    if (content.charAt(i) != '>') continue block4;
                    state = 0;
                }
            }
        }
        if (DEBUG_ENABLED) {
            logger.debug("Text list: " + textSections);
        }
        return textSections;
    }

    public static void removeBlankTextNodes(Node currentNode) {
        BasicXmlUtil.removeBlankTextNodes(currentNode, false);
    }

    public static void removeBlankTextNodes(Node currentNode, boolean inSpacePreserve) {
        Node parent = currentNode.getParentNode();
        if (currentNode.getNodeType() == 3) {
            String val;
            if (!inSpacePreserve && (val = currentNode.getNodeValue()).trim().length() == 0) {
                try {
                    parent.removeChild(currentNode);
                }
                catch (DOMException dOMException) {}
            }
        } else {
            Element elem;
            String spacePreserve;
            if (currentNode.getNodeType() == 1 && (spacePreserve = (elem = (Element)currentNode).getAttribute("xml:space")) != null && spacePreserve.length() > 0) {
                if (!inSpacePreserve) {
                    if ("preserve".equals(spacePreserve)) {
                        inSpacePreserve = true;
                    }
                } else if ("default".equals(spacePreserve)) {
                    inSpacePreserve = false;
                }
            }
            Node sibling = currentNode.getFirstChild();
            while (sibling != null) {
                Node ns = sibling.getNextSibling();
                BasicXmlUtil.removeBlankTextNodes(sibling, inSpacePreserve);
                sibling = ns;
            }
        }
    }

    public static void removeTextNodes(Node currentNode) {
        if (currentNode.getNodeType() == 3) {
            currentNode.getParentNode().removeChild(currentNode);
        } else {
            Node sibling = currentNode.getFirstChild();
            while (sibling != null) {
                Node ns = sibling.getNextSibling();
                BasicXmlUtil.removeTextNodes(sibling);
                sibling = ns;
            }
        }
    }

    public static void convertEntitiesToText(Document doc) {
        BasicXmlUtil.convertEntitiesNodesRec(doc, doc);
    }

    public static String escape(String text) {
        if (text != null && (text.indexOf(60) != -1 || text.indexOf(38) != -1 || text.indexOf(34) != -1)) {
            return BasicXmlUtil.escape(text, new EscapeSelectionOptions(true, false, true, false, true, false, false, false, 0, false, false));
        }
        return text;
    }

    public static String escapeAttributeValue(String text) {
        return BasicXmlUtil.escape(text, new EscapeSelectionOptions(true, false, true, false, true, true, false, false, 0, false, false));
    }

    public static String escape(String text, EscapeSelectionOptions escapeOptions) {
        if (text != null) {
            int len = text.length();
            StringBuilder escapedBuf = new StringBuilder((int)((double)len * 1.5));
            int parCount = 0;
            block8: for (int i = 0; i < len; ++i) {
                int ch = text.charAt(i);
                switch (ch) {
                    case 38: {
                        if (!escapeOptions.treatSpecialCharsAsUnicode) {
                            if (!(!escapeOptions.escapeAMP || escapeOptions.checkAMPInEntity && BasicXmlUtil.isEntityStart(i, text))) {
                                escapedBuf.append("&amp;");
                                continue block8;
                            }
                            escapedBuf.append((char)ch);
                            continue block8;
                        }
                    }
                    case 60: {
                        if (!escapeOptions.treatSpecialCharsAsUnicode) {
                            if (escapeOptions.escapeLT) {
                                escapedBuf.append("&lt;");
                                continue block8;
                            }
                            escapedBuf.append((char)ch);
                            continue block8;
                        }
                    }
                    case 62: {
                        if (!escapeOptions.treatSpecialCharsAsUnicode) {
                            if (escapeOptions.escapeGT || escapeOptions.escapeEndCDATA && parCount == 2 && text.charAt(i - 1) == ']') {
                                escapedBuf.append("&gt;");
                                continue block8;
                            }
                            escapedBuf.append((char)ch);
                            continue block8;
                        }
                    }
                    case 34: {
                        if (!escapeOptions.treatSpecialCharsAsUnicode) {
                            if (escapeOptions.escapeQUOT) {
                                escapedBuf.append("&quot;");
                                continue block8;
                            }
                            escapedBuf.append((char)ch);
                            continue block8;
                        }
                    }
                    case 39: {
                        if (!escapeOptions.treatSpecialCharsAsUnicode) {
                            if (escapeOptions.escapeAPOS) {
                                escapedBuf.append("&apos;");
                                continue block8;
                            }
                            escapedBuf.append((char)ch);
                            continue block8;
                        }
                    }
                    case 93: {
                        if (!escapeOptions.treatSpecialCharsAsUnicode && escapeOptions.escapeEndCDATA) {
                            parCount = i > 0 && text.charAt(i - 1) == ']' ? ++parCount : 1;
                            if (parCount > 2) {
                                parCount = 2;
                            }
                        }
                    }
                    default: {
                        if (escapeOptions.escapeUnicode) {
                            char low;
                            int codePoint = ch;
                            if (Character.isHighSurrogate((char)ch) && i < text.length() - 1 && Character.isLowSurrogate(low = text.charAt(i + 1))) {
                                codePoint = Character.toCodePoint((char)ch, low);
                                ++i;
                            }
                            BasicXmlUtil.appendUnicodeCharRepresentation(escapedBuf, codePoint, escapeOptions.startEscapeUnicodeAt, escapeOptions.escapeUnicodeAsHexa);
                            continue block8;
                        }
                        escapedBuf.append((char)ch);
                    }
                }
            }
            return escapedBuf.toString();
        }
        return null;
    }

    public static boolean isEntityStart(int pos, String text) {
        boolean isEntityStart = false;
        int nextAmp = text.indexOf(38, pos + 1);
        int nextSemiColon = text.indexOf(59, pos + 1);
        if (nextSemiColon != -1 && (nextAmp == -1 || nextSemiColon < nextAmp)) {
            String entity = text.substring(pos, nextSemiColon + 1);
            String entityName = text.substring(pos + 1, nextSemiColon);
            String unescapedStuff = null;
            try {
                unescapedStuff = BasicXmlUtil.unescape(entity, UNESCAPE_EVERYTHING_OPTIONS);
            }
            catch (UnescapeParseException unescapeParseException) {
                // empty catch block
            }
            isEntityStart = Equaler.verifyEquals(unescapedStuff, entity) ? XMLChar.isValidName((String)entityName) : true;
        }
        return isEntityStart;
    }

    private static void appendUnicodeCharRepresentation(StringBuilder escapedBuffer, int charCode, int startEscapeUnicodeAt, boolean asHex) {
        if (charCode >= startEscapeUnicodeAt) {
            if (asHex) {
                escapedBuffer.append("&#x").append(Integer.toHexString(charCode)).append(';');
            } else {
                escapedBuffer.append("&#").append(charCode).append(';');
            }
        } else {
            escapedBuffer.append((char)charCode);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String unescape(String text, UnescapeSelectionOptions unescapeOptions) throws UnescapeParseException {
        if (!text.contains("&")) return text;
        StringBuilder toReturn = new StringBuilder(text);
        boolean state = false;
        int startReplace = 0;
        int endReplace = 0;
        block8: for (int i = 0; i < toReturn.length(); ++i) {
            char ch = toReturn.charAt(i);
            switch (ch) {
                case '&': {
                    state = true;
                    startReplace = i;
                    endReplace = -1;
                    continue block8;
                }
                case ';': {
                    if (!state) continue block8;
                    endReplace = i + 1;
                    if (startReplace != -1 && endReplace != -1 && startReplace < toReturn.length() && endReplace <= toReturn.length()) {
                        int codePoint;
                        String charString;
                        String charsToUnescape = toReturn.substring(startReplace, endReplace);
                        String charsToReplace = null;
                        if (charsToUnescape.startsWith("&#x")) {
                            if (unescapeOptions.unescapeChars) {
                                if (charsToUnescape.length() <= 4) throw new UnescapeParseException("Cannot parse unicode character value from hex string.");
                                charString = charsToUnescape.substring(3, charsToUnescape.length() - 1);
                                try {
                                    codePoint = NumberParserUtil.parseInt(charString, 16);
                                    charsToReplace = new String(new int[]{codePoint}, 0, 1);
                                }
                                catch (NumberFormatException ex) {
                                    throw new UnescapeParseException("Cannot parse unicode character value from hex string: '" + charString + "'");
                                }
                            }
                        } else if (charsToUnescape.startsWith("&#")) {
                            if (unescapeOptions.unescapeChars) {
                                if (charsToUnescape.length() <= 3) throw new UnescapeParseException("Cannot parse unicode character value from decimal string.");
                                charString = charsToUnescape.substring(2, charsToUnescape.length() - 1);
                                try {
                                    codePoint = NumberParserUtil.parseInt(charString);
                                    charsToReplace = new String(new int[]{codePoint}, 0, 1);
                                }
                                catch (NumberFormatException e) {
                                    throw new UnescapeParseException("Cannot parse unicode character value from decimal string: '" + charString + "'");
                                }
                            }
                        } else if (charsToUnescape.equals("&amp;")) {
                            if (unescapeOptions.unescapeAMP) {
                                charsToReplace = "&";
                            }
                        } else if (charsToUnescape.equals("&lt;")) {
                            if (unescapeOptions.unescapeLT) {
                                charsToReplace = "<";
                            }
                        } else if (charsToUnescape.equals("&gt;")) {
                            if (unescapeOptions.unescapeGT) {
                                charsToReplace = ">";
                            }
                        } else if (charsToUnescape.equals("&quot;")) {
                            if (unescapeOptions.unescapeQUOT) {
                                charsToReplace = "\"";
                            }
                        } else if (charsToUnescape.equals("&apos;") && unescapeOptions.unescapeAPOS) {
                            charsToReplace = "'";
                        }
                        if (charsToReplace != null) {
                            toReturn.replace(startReplace, endReplace, charsToReplace);
                            i = startReplace + charsToReplace.length() - 1;
                        }
                    }
                    state = false;
                    endReplace = -1;
                    startReplace = -1;
                    continue block8;
                }
            }
        }
        return toReturn.toString();
    }

    public static Document copyContent(Node originalRoot, Document doc) {
        Node clonedNode = originalRoot.cloneNode(true);
        doc.appendChild(doc.importNode(clonedNode, true));
        return doc;
    }

    private static void convertEntitiesNodesRec(Document doc, Node currentNode) {
        if (currentNode.getNodeType() == 5) {
            EntityReference e = (EntityReference)currentNode;
            Node p = e.getParentNode();
            Text t = null;
            if (e.getNodeName().equals("lt")) {
                t = doc.createTextNode("<");
            } else if (e.getNodeName().equals("gt")) {
                t = doc.createTextNode(">");
            } else if (e.getNodeName().equals("quote")) {
                t = doc.createTextNode("\"");
            } else if (e.getNodeName().equals("amp")) {
                t = doc.createTextNode("&");
            }
            p.replaceChild(t, e);
        } else {
            for (Node child = currentNode.getFirstChild(); child != null; child = child.getNextSibling()) {
                BasicXmlUtil.convertEntitiesNodesRec(doc, child);
            }
        }
    }

    public static String getAssociatedRefValue(Document document, String name) {
        NamedNodeMap map;
        Entity entity;
        Object ret = null;
        DocumentType docType = document.getDoctype();
        if (docType != null && (entity = (Entity)(map = docType.getEntities()).getNamedItem(name)) != null) {
            String systemId = entity.getSystemId();
            if (systemId != null) {
                ret = "SYSTEM '" + systemId + "'";
            } else {
                Node firstChild = entity.getFirstChild();
                if (firstChild != null) {
                    ret = firstChild.getNodeValue();
                }
            }
        }
        return ret;
    }

    public static String getEncoding(Transformer transformer) {
        String transformerEncoding = transformer.getOutputProperty("encoding");
        if (DEBUG_ENABLED) {
            logger.debug("Transformer encoding:" + transformerEncoding);
        }
        String transformerMethod = transformer.getOutputProperty("method");
        if (DEBUG_ENABLED) {
            logger.debug("Transformer method: " + transformerMethod);
        }
        if (transformerEncoding == null || "unknown_external_xslt_encoding".equals(transformerEncoding)) {
            if ("xml".equalsIgnoreCase(transformerMethod) || transformerMethod == null) {
                transformerEncoding = "UTF-8";
            } else {
                try {
                    transformerEncoding = new InputStreamReader(new FileInputStream("fake.txt")).getEncoding();
                }
                catch (FileNotFoundException e) {
                    transformerEncoding = "UTF-8";
                }
            }
        }
        if (DEBUG_ENABLED) {
            logger.debug("Transformer encoding is: " + transformerEncoding);
        }
        return transformerEncoding;
    }

    public static boolean isValidXMLName(String name) {
        return BasicXmlUtil.isValidXMLName(name, false);
    }

    private static boolean isValidXMLName(String name, boolean checkNCName) {
        boolean valid = true;
        if (name != null && name.length() > 0) {
            for (int i = 0; i < name.length(); ++i) {
                char ch = name.charAt(i);
                if (i == 0 && !Character.isLetter(ch) && ch != '_') {
                    valid = false;
                } else {
                    if (Character.isJavaIdentifierPart(ch) || ch == '.' || ch == '-' || !checkNCName && ch == ':') continue;
                    valid = false;
                }
                break;
            }
        } else {
            valid = false;
        }
        return valid;
    }

    public static boolean isValidQName(String name) {
        boolean isValid = true;
        if (name != null && name.length() > 0) {
            String prefix = null;
            String localPart = null;
            int index = name.indexOf(58);
            if (index != -1) {
                prefix = name.substring(0, index);
                if (index + 1 < name.length()) {
                    localPart = name.substring(index + 1);
                }
            } else {
                localPart = name;
            }
            if (prefix != null) {
                isValid = BasicXmlUtil.isValidNCName(prefix);
            }
            isValid = isValid && BasicXmlUtil.isValidNCName(localPart);
        } else {
            isValid = false;
        }
        return isValid;
    }

    public static boolean isValidNCName(String name) {
        return BasicXmlUtil.isValidXMLName(name, true);
    }

    public static boolean equalNS(String str1, String str2) {
        return (str1 == null || "".equals(str1)) && (str2 == null || "".equals(str2)) || str1 != null && str2 != null && str1.equals(str2);
    }

    public static String escapeLineSepAndTab(String toEscape) {
        if ("\r\n".equals(toEscape)) {
            toEscape = "&#xd;&#xa;";
        } else if ("\n".equals(toEscape)) {
            toEscape = "&#xa;";
        } else if ("\t".equals(toEscape)) {
            toEscape = "&#x9;";
        }
        return toEscape;
    }

    public static String unescapeLineSeparatorAndTab(String toUnescape) {
        if ("&#xd;&#xa;".equals(toUnescape)) {
            toUnescape = "\r\n";
        } else if ("&#xa;".equals(toUnescape)) {
            toUnescape = "\n";
        } else if ("&#x9;".equals(toUnescape)) {
            toUnescape = "\t";
        }
        return toUnescape;
    }

    public static String unescapeLineSeparatorAndTabOldFormat(String toUnescape) {
        if ("\\r\\n".equals(toUnescape)) {
            toUnescape = "\r\n";
        } else if ("\\n".equals(toUnescape)) {
            toUnescape = "\n";
        } else if ("\\t".equals(toUnescape)) {
            toUnescape = "\t";
        }
        return toUnescape;
    }

    public static String getXPathForNode(Node node) {
        Object buf = "";
        if (node.getNodeType() == 2) {
            buf = "/@" + ((Attr)node).getName();
            node = ((Attr)node).getOwnerElement();
            if (DEBUG_ENABLED) {
                logger.debug("The parent element is: " + node);
            }
        }
        while (node != null) {
            if (node.getParentNode() != null) {
                String name = node.getNodeName();
                String uri = node.getNamespaceURI();
                short type = node.getNodeType();
                int idx = 1;
                Node sibling = node;
                while ((sibling = sibling.getPreviousSibling()) != null) {
                    if (sibling.getNodeType() != type || !Equaler.verifyEquals(sibling.getNodeName(), name) || !Equaler.verifyEquals(sibling.getNamespaceURI(), uri)) continue;
                    ++idx;
                }
                buf = "/" + BasicXmlUtil.correctNodeName(node) + "[" + idx + "]" + (String)buf;
            }
            node = node.getParentNode();
        }
        if (((String)buf).length() == 0) {
            buf = "/";
        }
        return buf;
    }

    private static String correctNodeName(Node node) {
        Object nodeName = node.getNodeName();
        if (((String)nodeName).startsWith("#")) {
            nodeName = ((String)nodeName).substring(1) + "()";
        } else if (node.getNodeType() == 7) {
            nodeName = "processing-instruction('" + (String)nodeName + "')";
        }
        return nodeName;
    }

    public static boolean isEqual(String localName, String namespace, String qName, ProxyNamespaceMapping pnm, boolean useDefaultNamespace) {
        String targetLocalName = BasicXmlUtil.getLocalName(qName);
        String targetProxy = BasicXmlUtil.getProxy(qName);
        String targetNamespace = useDefaultNamespace ? pnm.getNamespaceForPrefix(targetProxy) : pnm.getNamespaceForAttributePrefix(targetProxy);
        if (DEBUG_ENABLED) {
            logger.debug("LN:" + localName + " tln:" + targetLocalName + " Ns:" + namespace + " tns: " + targetNamespace);
        }
        return Equaler.verifyEquals(localName, targetLocalName) && Equaler.verifyEquals(namespace, targetNamespace);
    }

    public static String getCompactNotation(String qName, ProxyNamespaceMapping pnm, boolean useDefaultNamespace) {
        String compact = BasicXmlUtil.getLocalName(qName) + "#";
        String ns = null;
        ns = useDefaultNamespace ? pnm.getNamespaceForPrefix(BasicXmlUtil.getProxy(qName)) : pnm.getNamespaceForAttributePrefix(BasicXmlUtil.getProxy(qName));
        compact = ns == null ? compact + "{" + BasicXmlUtil.getProxy(qName) + "}" : compact + ns;
        return compact;
    }

    public static String getUnusedProxy(ProxyNamespaceMapping pnm, Collection<String> proxiesToReject, boolean forAttributeProxy) {
        String proxy;
        int nsIndex = 0;
        Object prefix = "";
        do {
            prefix = "ns" + ++nsIndex;
        } while ((proxy = forAttributeProxy ? pnm.getNamespaceForAttributePrefix((String)prefix) : pnm.getNamespaceForPrefix((String)prefix)) != null || proxiesToReject != null && proxiesToReject.contains(prefix));
        return prefix;
    }

    public static String getProxyForNamespace(String namespaceUri, ProxyNamespaceMapping pnm, HashMap<String, Integer> prefixIndicesMap) {
        Object prefix = pnm.getPrefixForNamespace(namespaceUri);
        if (prefix == null || "".equals(prefix)) {
            int index = namespaceUri.lastIndexOf(47);
            if (index != -1) {
                prefix = namespaceUri.substring(index + 1);
                if (((String)prefix).length() > 7) {
                    prefix = ((String)prefix).substring(0, 2);
                }
                prefix = XMLChar.isValidNCName((String)prefix) ? ((String)prefix).toLowerCase() : null;
            }
            boolean generatedPrefix = false;
            if (prefix == null || "".equals(prefix)) {
                prefix = "ns";
                generatedPrefix = true;
            }
            if (generatedPrefix || pnm.getNamespaceForPrefix((String)prefix) != null) {
                Integer counter = prefixIndicesMap.get(prefix);
                if (counter == null) {
                    counter = 1;
                }
                prefixIndicesMap.put((String)prefix, counter + 1);
                prefix = (String)prefix + counter;
            }
        }
        return prefix;
    }

    public static String getFromPIDataPseudoAttribute(String data, String name, boolean unescapeValue) {
        int pos = 0;
        while (pos <= data.length() - 4) {
            int nextQuote = -1;
            for (int q = pos; q < data.length(); ++q) {
                if (data.charAt(q) != '\"' && data.charAt(q) != '\'') continue;
                nextQuote = q;
                break;
            }
            if (nextQuote < 0) {
                return null;
            }
            int closingQuote = data.indexOf(data.charAt(nextQuote), nextQuote + 1);
            if (closingQuote < 0) {
                return null;
            }
            int nextName = data.indexOf(name, pos);
            if (nextName < 0) {
                return null;
            }
            if (nextName < nextQuote) {
                boolean found = true;
                for (int s = nextName + name.length(); s < nextQuote; ++s) {
                    char c = data.charAt(s);
                    if (Character.isWhitespace(c) || c == '=') continue;
                    found = false;
                    break;
                }
                if (found) {
                    String val = data.substring(nextQuote + 1, closingQuote);
                    return unescapeValue ? BasicXmlUtil.unescape(val) : val;
                }
            }
            pos = closingQuote + 1;
        }
        return null;
    }

    private static String unescape(String value) {
        if (value.indexOf(38) < 0) {
            return value;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c == '&') {
                if (i + 2 < value.length() && value.charAt(i + 1) == '#') {
                    int digit;
                    int x;
                    int charval;
                    if (value.charAt(i + 2) == 'x') {
                        charval = 0;
                        for (x = i + 3; x < value.length() && value.charAt(x) != ';'; ++x) {
                            digit = "0123456789abcdef".indexOf(value.charAt(x));
                            if (digit < 0) {
                                digit = "0123456789ABCDEF".indexOf(value.charAt(x));
                            }
                            if (digit < 0) {
                                return null;
                            }
                            charval = charval * 16 + digit;
                        }
                        char hexchar = (char)charval;
                        sb.append(hexchar);
                        i = x;
                        continue;
                    }
                    charval = 0;
                    for (x = i + 2; x < value.length() && value.charAt(x) != ';'; ++x) {
                        digit = "0123456789".indexOf(value.charAt(x));
                        if (digit < 0) {
                            return null;
                        }
                        charval = charval * 10 + digit;
                    }
                    char decchar = (char)charval;
                    sb.append(decchar);
                    i = x;
                    continue;
                }
                if (value.substring(i + 1).startsWith("lt;")) {
                    sb.append('<');
                    i += 3;
                    continue;
                }
                if (value.substring(i + 1).startsWith("gt;")) {
                    sb.append('>');
                    i += 3;
                    continue;
                }
                if (value.substring(i + 1).startsWith("amp;")) {
                    sb.append('&');
                    i += 4;
                    continue;
                }
                if (value.substring(i + 1).startsWith("quot;")) {
                    sb.append('\"');
                    i += 5;
                    continue;
                }
                if (value.substring(i + 1).startsWith("apos;")) {
                    sb.append('\'');
                    i += 5;
                    continue;
                }
                return null;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static int isAttrValueWellformed(String attrValue) {
        return BasicXmlUtil.isAttrValueWellformed(attrValue, true);
    }

    public static String[] detectNamespaceClark(String name) {
        int lPar;
        int fPar;
        String[] nsName = new String[]{null, name};
        if (name != null && (fPar = name.indexOf(123)) != -1 && (lPar = name.indexOf(125, fPar)) != -1) {
            nsName[0] = name.substring(fPar + 1, lPar);
            nsName[1] = name.substring(lPar + 1);
        }
        return nsName;
    }

    public static String escapeXMLText(String text) {
        return BasicXmlUtil.escape(text, LT_AND_AMP_ESCAPE_OPTIONS);
    }

    public static String escapeXMLDoubleQuotedAttrValue(String text) {
        return BasicXmlUtil.escape(text, new EscapeSelectionOptions(true, false, true, false, true, false, false, false, 0, false, false));
    }

    public static String getNamespace(Node node, boolean useDOMLevel1) {
        if (!useDOMLevel1) {
            return node.getNamespaceURI();
        }
        ProxyNamespaceMapping mapping = new ProxyNamespaceMapping(node);
        String proxy = BasicXmlUtil.getProxy(node.getNodeName());
        return mapping.getNamespaceForPrefix(proxy);
    }

    public static LinkedHashMap<String, String> extractPIAttributes(String attributesData, boolean unescapeValues) {
        LinkedHashMap<String, String> attributes;
        block9: {
            attributes = null;
            try {
                if (attributesData == null) break block9;
                Matcher matcher = ATRIBUTES_PATTERN.matcher(attributesData);
                int lastEnd = 0;
                while (matcher.find()) {
                    String attrValue;
                    String attrName;
                    block10: {
                        String valueGroup;
                        if (!BasicXmlUtil.areWhitespacesBetween(attributesData, lastEnd, matcher.start())) {
                            attributesData = null;
                            break;
                        }
                        lastEnd = matcher.end();
                        if (matcher.groupCount() <= 0 || (attrName = matcher.group(1)) == null || attrName.isEmpty()) continue;
                        attrValue = "";
                        if (matcher.groupCount() == 3 && (valueGroup = matcher.group(3)) != null && valueGroup.length() > 2) {
                            attrValue = valueGroup.substring(1, valueGroup.length() - 1);
                        }
                        if (attributes == null) {
                            attributes = new LinkedHashMap<String, String>();
                        }
                        if (unescapeValues) {
                            try {
                                attrValue = BasicXmlUtil.unescape(attrValue, new UnescapeSelectionOptions(true, true, true, true, true, false));
                            }
                            catch (UnescapeParseException e) {
                                if (!logger.isDebugEnabled()) break block10;
                                logger.debug(e.getMessage(), (Throwable)e);
                            }
                        }
                    }
                    attributes.put(attrName, attrValue);
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return attributes;
    }

    public static List<String> extractSimpleAttributeValues(String attributeValue, String valSeparator) {
        ArrayList<String> simpleValues = null;
        if (valSeparator != null && !attributeValue.contains(valSeparator)) {
            simpleValues = new ArrayList<String>();
            simpleValues.add(attributeValue);
        } else {
            StringTokenizer st = null;
            st = valSeparator == null || valSeparator.trim().length() == 0 ? new StringTokenizer(attributeValue) : new StringTokenizer(attributeValue, valSeparator);
            if (st.hasMoreTokens()) {
                simpleValues = new ArrayList();
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    simpleValues.add(token);
                }
            }
        }
        return simpleValues;
    }

    public static String getAttributeLocalName(String qName) {
        int idx;
        String local = qName;
        if (qName != null && (idx = qName.indexOf(58)) != -1) {
            int spaceIdx = qName.indexOf(32);
            local = spaceIdx > 0 ? qName.substring(idx + 1, spaceIdx) : qName.substring(idx + 1);
        }
        return local;
    }

    public static String extractXMLProlog(String textBeforeRoot) {
        int end;
        String xmlProlog = null;
        if (textBeforeRoot != null && textBeforeRoot.startsWith("<?xml ") && (end = textBeforeRoot.indexOf("?>")) > 0) {
            xmlProlog = textBeforeRoot.substring(0, end + 2);
        }
        return xmlProlog;
    }

    public static int[] getPrologEndLineAndColumn(String prolog) {
        int[] lineAndColumn = null;
        if (prolog != null && prolog.trim().length() > 0) {
            try {
                int line = 0;
                int column = 1;
                BufferedReader bufferedReader = new BufferedReader(new StringReader(prolog));
                String readLine = bufferedReader.readLine();
                while (readLine != null) {
                    ++line;
                    column = readLine.length() + 1;
                    readLine = bufferedReader.readLine();
                }
                lineAndColumn = new int[]{line, column};
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return lineAndColumn;
    }

    public static SourceLocator getXalanSourceLocator(Node node) {
        if (node != null && "org.apache.xml.dtm.ref.DTMNodeProxy".equals(node.getClass().getName())) {
            try {
                Method getDTMMethod = node.getClass().getMethod("getDTM", new Class[0]);
                Object dtm = getDTMMethod.invoke((Object)node, new Object[0]);
                if (dtm != null) {
                    Method getNumberMeth = node.getClass().getMethod("getDTMNodeNumber", new Class[0]);
                    Object nodeNumber = getNumberMeth.invoke((Object)node, new Object[0]);
                    Method getSrcMeth = dtm.getClass().getMethod("getSourceLocatorFor", Integer.TYPE);
                    return (SourceLocator)getSrcMeth.invoke(dtm, nodeNumber);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static int isAttrValueWellformed(String attrValue, boolean checkValidNCName) {
        int index = attrValue.indexOf(60);
        if (index != -1) {
            return index;
        }
        int startIdx = 0;
        while (startIdx < attrValue.length() && (index = attrValue.indexOf(38, startIdx)) != -1) {
            int semiColonIndex = attrValue.indexOf(59, index);
            if (semiColonIndex == -1) {
                return index;
            }
            try {
                String possibleEntity = attrValue.substring(index, semiColonIndex + 1);
                if (possibleEntity.indexOf(38, 1) != -1) {
                    return index;
                }
                String unescaped = BasicXmlUtil.unescape(possibleEntity, new UnescapeSelectionOptions(true, true, true, true, true, true));
                if (checkValidNCName && unescaped.equals(possibleEntity) && !BasicXmlUtil.isValidNCName(attrValue.substring(index + 1, semiColonIndex))) {
                    return index + 1;
                }
            }
            catch (UnescapeParseException e) {
                logger.warn(e.getMessage(), (Throwable)e);
                return index + 1;
            }
            startIdx = index + 1;
        }
        return index;
    }

    private static boolean areWhitespacesBetween(String string, int startOffset, int endOffset) {
        boolean onlyWS = true;
        for (int i = startOffset; i < endOffset; ++i) {
            if (Character.isWhitespace(string.charAt(i))) continue;
            onlyWS = false;
            break;
        }
        return onlyWS;
    }

    public static String escapeIllegalCharacters(String value) {
        String escapedValue = value;
        if (escapedValue != null && escapedValue.trim().length() > 0) {
            if (escapedValue.indexOf(60) != -1) {
                escapedValue = BasicXmlUtil.escape(escapedValue, new EscapeSelectionOptions(true, false, false, false, false, false, false, false, -1, false, false));
            }
            StringBuilder sb = new StringBuilder(escapedValue);
            int index = BasicXmlUtil.isAttrValueWellformed(sb.toString());
            int originalIndex = 0;
            while (index != -1) {
                String substring = sb.substring(originalIndex += index, originalIndex + 1);
                substring = BasicXmlUtil.escape(substring, new EscapeSelectionOptions(false, false, true, false, false, false, false, false, -1, false, false));
                sb.replace(originalIndex, originalIndex + 1, substring);
                index = BasicXmlUtil.isAttrValueWellformed(sb.substring(originalIndex));
            }
            escapedValue = sb.toString();
        }
        return escapedValue;
    }

    public static String getProxy(String qName) {
        String prefix = null;
        if (qName != null) {
            int idx = qName.indexOf(58);
            prefix = "";
            if (idx != -1) {
                prefix = qName.substring(0, idx);
            }
        }
        return prefix;
    }

    public static String getLocalName(String qName) {
        int idx;
        String local = qName;
        if (qName != null && (idx = qName.lastIndexOf(58)) != -1) {
            local = qName.substring(idx + 1);
        }
        return local;
    }

    public static final Object getUserdata(Node node, String key) {
        Document doc = BasicXmlUtil.getDocument(node);
        if (doc != null) {
            SmallAndFastHashtable fh;
            Object ret = null;
            Hashtable htud = (Hashtable)doc.getUserData(NODES_UD);
            if (htud != null && (fh = (SmallAndFastHashtable)htud.get(node)) != null) {
                ret = fh.get(key);
            }
            return ret;
        }
        try {
            Method getUserData = node.getClass().getMethod("getUserData", String.class);
            return getUserData.invoke((Object)node, key);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            BasicXmlUtil.throwUserDataError(node, " getUserData ");
            return null;
        }
    }

    public static void throwUserDataError(Node node, String mess) throws UnsupportedOperationException {
        String className = null;
        if (node != null) {
            className = node.getClass().getName();
        }
        throw new UnsupportedOperationException("The DOM implementation does not support " + mess + "!\n" + className + "\n");
    }

    public static final void setUserdata(Node node, String key, Object data, UserDataHandler handler) {
        Document doc = BasicXmlUtil.getDocument(node);
        if (doc != null) {
            SmallAndFastHashtable fh;
            Hashtable<Node, SmallAndFastHashtable> htud = (Hashtable<Node, SmallAndFastHashtable>)doc.getUserData(NODES_UD);
            if (htud == null) {
                htud = new Hashtable<Node, SmallAndFastHashtable>();
                doc.setUserData(NODES_UD, htud, null);
            }
            if ((fh = (SmallAndFastHashtable)htud.get(node)) == null) {
                fh = new SmallAndFastHashtable();
                htud.put(node, fh);
            }
            fh.put(key, data);
        } else if (node != null) {
            try {
                Method setUserData = node.getClass().getMethod("setUserData", String.class, Object.class, UserDataHandler.class);
                setUserData.invoke((Object)node, key, data, handler);
            }
            catch (Throwable e) {
                logger.error(e.getMessage(), e);
                BasicXmlUtil.throwUserDataError(node, " setUserData ");
            }
        }
    }

    private static final Document getDocument(Node node) {
        Document doc = null;
        if (node instanceof Document) {
            doc = (Document)node;
        } else {
            try {
                doc = node.getOwnerDocument();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return doc;
    }

    public static void setAttributesOrderData(Node node, String[] order) {
        BasicXmlUtil.setUserdata(node, ORDER, order, null);
    }

    public static String getTextContent(Node node) {
        if (node instanceof NodeImpl) {
            return ((NodeImpl)node).getTextContent();
        }
        try {
            Method getTextContent = node.getClass().getMethod("getTextContent", new Class[0]);
            return (String)getTextContent.invoke((Object)node, new Object[0]);
        }
        catch (Throwable e) {
            logger.error(e.getMessage(), e);
            BasicXmlUtil.throwUserDataError(node, " getTextContent ");
            return null;
        }
    }

    public static void setTextContent(Node node, String content) {
        if (node instanceof NodeImpl) {
            ((NodeImpl)node).setTextContent(content);
        } else {
            try {
                Method setTextContent = node.getClass().getMethod("setTextContent", String.class);
                setTextContent.invoke((Object)node, content);
                return;
            }
            catch (Throwable e) {
                logger.error(e.getMessage(), e);
                BasicXmlUtil.throwUserDataError(node, " setTextContent ");
            }
        }
    }

    public static void resetAllUserData(Document document, String fallbackKey) {
        block4: {
            if (document instanceof DocumentImpl) {
                document.setUserData(NODES_UD, null, null);
            } else {
                try {
                    BasicXmlUtil.resetAllUserDataForNode(document.getDocumentElement(), fallbackKey);
                }
                catch (UnsupportedOperationException e) {
                    if (!logger.isDebugEnabled()) break block4;
                    logger.debug(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public static void resetAllUserDataForNode(Node node, String key) throws UnsupportedOperationException {
        if (node instanceof NodeAdapter) {
            ((NodeAdapter)node).resetUserData();
        } else if (node != null) {
            try {
                Method setUserData = node.getClass().getMethod("setUserData", String.class, Object.class, UserDataHandler.class);
                setUserData.invoke((Object)node, key, null, null);
            }
            catch (Throwable e) {
                BasicXmlUtil.throwUserDataError(node, " setUserData ");
            }
        }
        if (node instanceof Element) {
            Element element = (Element)node;
            for (Node child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
                BasicXmlUtil.resetAllUserDataForNode(child, key);
            }
        }
    }

    public static String[] getAttributesOrderData(Node node) {
        return (String[])BasicXmlUtil.getUserdata(node, ORDER);
    }

    public static void preserveLocationData(Node original, Node cloned) {
        if (original.getNodeType() == 1) {
            Object userData = BasicXmlUtil.getUserdata(original, ORDER);
            BasicXmlUtil.setUserdata(cloned, ORDER, userData, null);
        }
        NodeList originalChildren = original.getChildNodes();
        NodeList cloneChildren = cloned.getChildNodes();
        int originalChildrenSize = originalChildren.getLength();
        for (int i = 0; i < originalChildrenSize; ++i) {
            BasicXmlUtil.preserveLocationData(originalChildren.item(i), cloneChildren.item(i));
        }
    }

    public static String remapIDs(String obtained) {
        LinkedHashMap<String, Integer> ids = new LinkedHashMap<String, Integer>();
        Pattern idPattern = Pattern.compile("[\"|#|\\[]d([A-Fa-f0-9]*?)[\"|\\]]");
        int cnt = 0;
        Matcher matcher = idPattern.matcher(obtained);
        while (matcher.find()) {
            String idInSource = matcher.group(1);
            if (ids.containsKey(idInSource)) continue;
            ids.put(idInSource, ++cnt);
        }
        Set keySet = ids.keySet();
        for (String key : keySet) {
            obtained = obtained.replace("d" + key, "remapped_id_" + ids.get(key));
        }
        return obtained;
    }

    public static class EscapeSelectionOptions {
        boolean escapeLT;
        boolean escapeGT;
        boolean escapeAMP;
        boolean checkAMPInEntity;
        boolean escapeQUOT;
        boolean escapeAPOS;
        boolean escapeEndCDATA;
        boolean escapeUnicode;
        int startEscapeUnicodeAt;
        boolean escapeUnicodeAsHexa;
        boolean treatSpecialCharsAsUnicode;

        public EscapeSelectionOptions(boolean escapeLT, boolean escapeGT, boolean escapeAMP, boolean escapeQUOT, boolean escapeAPOS, boolean escapeUnicode, int startEscapeUnicodeAt, boolean escapeUnicodeHexa) {
            this(escapeLT, escapeGT, escapeAMP, escapeQUOT, escapeAPOS, false, escapeUnicode, startEscapeUnicodeAt, escapeUnicodeHexa);
        }

        public EscapeSelectionOptions(boolean escapeLT, boolean escapeGT, boolean escapeAMP, boolean escapeQUOT, boolean escapeAPOS, boolean escapeEndCDATA, boolean escapeUnicode, int startEscapeUnicodeAt, boolean escapeUnicodeHexa) {
            this(escapeLT, escapeGT, escapeAMP, false, escapeQUOT, escapeAPOS, escapeEndCDATA, escapeUnicode, startEscapeUnicodeAt, escapeUnicodeHexa, false);
        }

        public EscapeSelectionOptions(boolean escapeUnicodeHexa) {
            this(false, false, false, false, false, false, false, true, -1, escapeUnicodeHexa, true);
        }

        public EscapeSelectionOptions(boolean escapeLT, boolean escapeGT, boolean escapeAMP, boolean checkAMPInEntity, boolean escapeQUOT, boolean escapeAPOS, boolean escapeEndCDATA, boolean escapeUnicode, int startEscapeUnicodeAt, boolean escapeUnicodeHexa, boolean treatSpecialCharsAsUnicode) {
            this.escapeLT = escapeLT;
            this.escapeGT = escapeGT;
            this.escapeAMP = escapeAMP;
            this.checkAMPInEntity = checkAMPInEntity;
            this.escapeQUOT = escapeQUOT;
            this.escapeAPOS = escapeAPOS;
            this.escapeEndCDATA = escapeEndCDATA;
            this.escapeUnicode = escapeUnicode;
            this.startEscapeUnicodeAt = startEscapeUnicodeAt;
            this.escapeUnicodeAsHexa = escapeUnicodeHexa;
            this.treatSpecialCharsAsUnicode = treatSpecialCharsAsUnicode;
        }
    }

    public static class UnescapeSelectionOptions {
        boolean unescapeLT;
        boolean unescapeGT;
        boolean unescapeAMP;
        boolean unescapeQUOT;
        boolean unescapeAPOS;
        boolean unescapeChars;

        public UnescapeSelectionOptions(boolean unescapeLT, boolean unescapeGT, boolean unescapeAMP, boolean unescapeQUOT, boolean unescapeAPOS, boolean unescapeChars) {
            this.unescapeLT = unescapeLT;
            this.unescapeGT = unescapeGT;
            this.unescapeAMP = unescapeAMP;
            this.unescapeQUOT = unescapeQUOT;
            this.unescapeAPOS = unescapeAPOS;
            this.unescapeChars = unescapeChars;
        }
    }

    public static class TextBeforeRootAndReader {
        public final String textBeforeRoot;
        public Reader rewindedReader;

        public TextBeforeRootAndReader(Reader rewindedReader, String textBeforeRoot) {
            this.rewindedReader = rewindedReader;
            this.textBeforeRoot = textBeforeRoot;
        }
    }
}

