/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.basic.util.concurrent;

import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;

public class CPULoadEstimator {
    private static final int SAMPLING_PERIOD = 100;
    private static final int DEFAULT_TOTAL_SAMPLING_PERIOD = 2000;

    private static double getSystemCpuLoad() {
        double load = 0.0;
        OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
        load = operatingSystemMXBean.getSystemLoadAverage();
        return load;
    }

    private static double getSystemCpuLoadOverTime(int tms) throws InterruptedException {
        double load = 0.0;
        int no = 1;
        for (int ct = 0; ct < tms; ct += 100) {
            double systemCpuLoad = CPULoadEstimator.getSystemCpuLoad();
            if (systemCpuLoad > 0.0) {
                load += systemCpuLoad;
                ++no;
            }
            Thread.sleep(100L);
        }
        return load / (double)no;
    }

    public double getWeightingFactor(int tms) throws InterruptedException {
        return CPULoadEstimator.getSystemCpuLoadOverTime(tms) + 1.0;
    }

    public double getWeightingFactor() throws InterruptedException {
        return this.getWeightingFactor(2000);
    }
}

