/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.basic.util;

import java.io.File;
import java.io.IOException;
import ro.sync.basic.util.EncryptionKey;
import ro.sync.basic.util.FilePermissionSetter;
import ro.sync.basic.util.PlatformDetector;

public class WebappEncryptionKey
extends EncryptionKey {
    @Override
    protected String readKeyFromFile(File keyFile) throws IOException {
        if (PlatformDetector.isWin()) {
            return super.readKeyFromFile(keyFile);
        }
        new FilePermissionSetter().makeReadable(keyFile);
        try {
            String string = super.readKeyFromFile(keyFile);
            return string;
        }
        finally {
            new FilePermissionSetter().revokePermissions(keyFile);
        }
    }

    @Override
    protected void writeKeyToFile(String key, File keyFile) throws IOException {
        if (PlatformDetector.isWin()) {
            super.writeKeyToFile(key, keyFile);
        } else {
            if (keyFile.exists()) {
                new FilePermissionSetter().makeWritable(keyFile);
            }
            try {
                super.writeKeyToFile(key, keyFile);
            }
            finally {
                new FilePermissionSetter().revokePermissions(keyFile);
            }
        }
    }
}

