/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.basic.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.net.UnknownServiceException;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.basic.io.FilePathToURI;
import ro.sync.basic.io.FileSystemUtilBasic;
import ro.sync.basic.statics.StaticComponentsRegistry;
import ro.sync.basic.util.AdditionalURLConnectionCreator;
import ro.sync.basic.util.Equaler;
import ro.sync.basic.util.NXDAccessProvider;
import ro.sync.basic.util.NumberFormatException;
import ro.sync.basic.util.NumberParserUtil;
import ro.sync.basic.util.PlatformDetector;
import ro.sync.basic.util.RelativeReferenceResolver;
import ro.sync.basic.util.RelativeReferenceResolversProvider;
import ro.sync.basic.util.URLInfo;

@SkipObfuscate(classes=SkipLevel.NOT_SPECIFIED, fields=SkipLevel.NOT_SPECIFIED, methods=SkipLevel.PUBLIC)
public class URLUtil {
    private static final String RELATIVE_REFERENCE_CUSTOMIZERS_PROVIDER = "RELATIVE_REFERENCE_CUSTOMIZERS_PROVIDER";
    private static NXDAccessProvider nxdUtil;
    public static final String[] URI_SCHEMES;
    private static AdditionalURLConnectionCreator urlConnectionCreator;
    private static final int HTTP_DEFAULT_PORT = 80;
    private static final int HTTPS_DEFAULT_PORT = 443;

    public static String extractFileName(URL url) {
        String[] pathAndFileName = URLUtil.extractPathAndFileName(url);
        if (pathAndFileName != null) {
            return pathAndFileName[1];
        }
        return "";
    }

    public static String[] extractPathAndFileName(URL url) {
        if (url == null) {
            return null;
        }
        String[] pathAndFileName = null;
        String fullName = url.toString();
        int index = fullName.lastIndexOf(47);
        if ("".equals(url.getPath()) || index + 1 == fullName.length()) {
            try {
                url = new URL(url, "index.html");
                fullName = url.toString();
                index = fullName.lastIndexOf(47);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (index != -1) {
            pathAndFileName = new String[]{fullName.substring(0, index + 1), fullName.substring(index + 1)};
            pathAndFileName[1] = URLUtil.removeQueryOrAnchorFromName(pathAndFileName[1]);
        } else {
            String path = url.getPath();
            if (path != null && !path.isEmpty()) {
                pathAndFileName = new String[]{"", URLUtil.removeQueryOrAnchorFromName(path)};
            }
        }
        return pathAndFileName;
    }

    public static String[] extractPathAndFileName(String path) {
        if (path == null) {
            return null;
        }
        int index = (path = URLUtil.removeQueryOrAnchorFromName(path)).lastIndexOf(47);
        if (index == -1) {
            index = path.lastIndexOf(92);
        }
        String[] pathAndFileName = new String[2];
        if (index != -1) {
            pathAndFileName[0] = path.substring(0, index + 1);
            pathAndFileName[1] = path.substring(index + 1);
        } else {
            pathAndFileName[0] = path;
            pathAndFileName[1] = "";
        }
        return pathAndFileName;
    }

    public static URL maskUserInfo(URL url) {
        try {
            return URLUtil.attachUserInfo(url, URLUtil.extractUser(url.getUserInfo()), null, false);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public static String getDescription(URL url) {
        Object toReturn = null;
        if (url != null) {
            String protocol = url.getProtocol();
            if (protocol.equals("file")) {
                toReturn = URLUtil.getFileFromFileUrl(url, true, true, true).toString();
            } else if (protocol.equals("data")) {
                toReturn = url.toExternalForm();
                if (((String)toReturn).length() > 100) {
                    toReturn = ((String)toReturn).substring(0, 100) + "...";
                }
            } else {
                URL maskedUrl = URLUtil.maskUserInfo(url);
                if (maskedUrl != null) {
                    toReturn = URLUtil.uncorrect(maskedUrl.toString());
                }
            }
        }
        return toReturn;
    }

    public static String getDescription(String systemId) {
        String toReturn = systemId;
        if (systemId != null) {
            try {
                toReturn = URLUtil.getDescription(new URL(systemId));
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return toReturn;
    }

    public static String extractFileName(String path) {
        return URLUtil.extractFileName(path, true);
    }

    public static String extractFileName(String path, boolean removeAnchorsAndQuery) {
        if (path == null) {
            return "";
        }
        Object fileName = null;
        if (removeAnchorsAndQuery) {
            path = URLUtil.removeQueryOrAnchorFromName(path);
            fileName = URLUtil.getFileNameForPathWithNoAnchor(path);
        } else {
            String anchor = "";
            String pathWithoutAnchor = path;
            int lastIndexOfHash = path.lastIndexOf(35);
            if (lastIndexOfHash != -1) {
                pathWithoutAnchor = path.substring(0, lastIndexOfHash);
                anchor = path.substring(lastIndexOfHash);
            }
            fileName = URLUtil.getFileNameForPathWithNoAnchor(pathWithoutAnchor);
            fileName = (String)fileName + anchor;
        }
        if (fileName == null) {
            fileName = "";
        }
        return fileName;
    }

    private static String getFileNameForPathWithNoAnchor(String pathWithNoAnchor) {
        int backSlashIndex;
        int slashIndex = pathWithNoAnchor.lastIndexOf(47);
        int index = slashIndex > (backSlashIndex = pathWithNoAnchor.lastIndexOf(92)) ? slashIndex : backSlashIndex;
        String fileName = index != -1 ? pathWithNoAnchor.substring(index + 1) : pathWithNoAnchor;
        return fileName;
    }

    public static URL correctFileExtension(URL url, String extension) {
        int lastDot;
        Object fullUrl = url.toString();
        int lastSlash = ((String)fullUrl).lastIndexOf(47);
        if (lastSlash == -1) {
            lastSlash = 0;
        }
        if ((lastDot = ((String)fullUrl).lastIndexOf(46)) < lastSlash && !"".equals(extension)) {
            fullUrl = (String)fullUrl + "." + extension;
        }
        try {
            return new URL((String)fullUrl);
        }
        catch (MalformedURLException e) {
            return url;
        }
    }

    public static File correctFileExtension(File file, String extension) {
        Object fullPath = file.getAbsolutePath();
        String fileName = file.getName();
        if (!fileName.contains(".")) {
            fullPath = (String)fullPath + "." + extension;
        }
        return new File((String)fullPath);
    }

    public static String removeExtension(String fileName) {
        int lastDotIndex;
        if (fileName != null && (lastDotIndex = fileName.lastIndexOf(46)) != -1) {
            fileName = fileName.substring(0, lastDotIndex);
        }
        return fileName;
    }

    public static boolean isFromUNCPath(URL url) {
        return url != null && url.toString().startsWith("file:////");
    }

    public static boolean isFromLocalDrive(String urlString) {
        URL url = null;
        try {
            url = URLUtil.correct(new URL(urlString));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        boolean noHost = url == null || url.getHost() == null || url.getHost().isEmpty();
        return url != null && "file".equals(url.getProtocol()) && noHost && !URLUtil.isFromUNCPath(url);
    }

    public static boolean isFromLocalDrive(URL url) {
        return url != null && "file".equals(url.getProtocol()) && !URLUtil.isFromUNCPath(url);
    }

    public static URL getCanonicalURL(URL url) {
        URL toRet = url;
        try {
            if (URLUtil.isFromLocalDrive(url)) {
                String query = url.getQuery();
                String anchor = url.getRef();
                File file = URLUtil.getCanonicalFileFromFileUrl(url);
                if (file != null) {
                    StringBuilder newURL = new StringBuilder();
                    newURL.append(URLUtil.correct(file).toExternalForm());
                    if (query != null && !query.isEmpty()) {
                        newURL.append(URLUtil.correct("?" + query, false));
                    }
                    if (anchor != null && !anchor.isEmpty()) {
                        newURL.append(URLUtil.correct("#" + anchor, false));
                    }
                    toRet = new URL(newURL.toString());
                }
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return toRet;
    }

    public static File computeCanonicalFile(URL baseURL, String relativePath) throws IOException {
        boolean baseIsFile;
        File f = new File(relativePath);
        boolean bl = baseIsFile = baseURL != null && "file".equals(baseURL.getProtocol());
        if (!baseIsFile || f.equals(f.getAbsoluteFile())) {
            return f.getCanonicalFile();
        }
        String parentPath = null;
        if (baseURL != null) {
            parentPath = baseURL.getPath();
            if (parentPath.startsWith("/") && !PlatformDetector.isMacOS() && !PlatformDetector.isLinux()) {
                parentPath = parentPath.substring(1);
            }
            parentPath = URLUtil.uncorrect(new File(parentPath).getParentFile().toString());
        }
        return new File(parentPath, relativePath).getCanonicalFile();
    }

    public static String removeQueryOrAnchorFromName(String name) {
        if (name != null) {
            int queryIndex = name.indexOf("?");
            if (queryIndex != -1) {
                name = name.substring(0, queryIndex);
            } else {
                int anchorIndex = name.indexOf("#");
                if (anchorIndex != -1) {
                    name = name.substring(0, anchorIndex);
                }
            }
        }
        return name;
    }

    public static URL removeAnchor(URL url) {
        String urlStr;
        int anchorIndex;
        if (url != null && url.getRef() != null && (anchorIndex = (urlStr = url.toString()).indexOf("#")) != -1) {
            try {
                url = new URL(urlStr.substring(0, anchorIndex));
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return url;
    }

    public static URL removeQuery(URL url) {
        String urlStr;
        int anchorIndex;
        if (url != null && (anchorIndex = (urlStr = url.toString()).indexOf("?")) != -1) {
            try {
                url = new URL(urlStr.substring(0, anchorIndex));
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return url;
    }

    public static String correctDBUrl(String databaseUrl) {
        return FilePathToURI.escapeSpecialAsciiAndNonAscii(databaseUrl);
    }

    public static String urlList2String(List<URL> urls) {
        if (urls == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder("[");
        Iterator<URL> iter = urls.iterator();
        while (iter.hasNext()) {
            buf.append(URLUtil.clearUserInfo(iter.next()));
            if (!iter.hasNext()) continue;
            buf.append(", ");
        }
        buf.append("]");
        return buf.toString();
    }

    public static URL convertToURL(String value) {
        URL url = null;
        if (value != null) {
            try {
                url = new URL(URLUtil.correct(value, false));
            }
            catch (MalformedURLException e) {
                try {
                    url = URLUtil.correct(new File(value));
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
        }
        return url;
    }

    public static URL convertFilePatternToUrl(String path) {
        URL toReturn = null;
        if (path.contains("*")) {
            String escapedPath = URLUtil.escapeWildcards(path);
            URL convertedUrl = URLUtil.convertToURL(escapedPath);
            if (convertedUrl != null) {
                String escapedUrl = convertedUrl.toExternalForm();
                String url = URLUtil.unescapeWildcards(escapedUrl);
                try {
                    toReturn = new URL(url);
                }
                catch (MalformedURLException e) {
                    toReturn = null;
                }
            }
        } else {
            toReturn = URLUtil.convertToURL(path);
        }
        return toReturn;
    }

    static String unescapeWildcards(String escapedString) {
        return escapedString.replace("_0", "*").replace("_1", "_");
    }

    static String escapeWildcards(String path) {
        return path.replace("_", "_1").replace("*", "_0");
    }

    public static boolean isCharAllowedInURLPart(char ch) {
        switch (ch) {
            case '#': 
            case '/': 
            case ':': 
            case '?': 
            case '@': {
                return false;
            }
        }
        return true;
    }

    public static URLInfo getURLInfo(URL url) throws MalformedURLException {
        return new URLInfo(url);
    }

    public static String getURLParameterValue(URL url, String paramName) {
        try {
            LinkedHashMap<String, String> params;
            URLInfo urlInfo = URLUtil.getURLInfo(url);
            if (urlInfo != null && (params = urlInfo.getCustomQueryParameters()) != null) {
                return URLUtil.decodeURIComponent(params.get(paramName));
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return null;
    }

    public static File getTopArchive(URL url) {
        File topArchive = null;
        if ("zip".equals(url.getProtocol())) {
            String zipPath = url.getPath();
            try {
                URL fileURL = new URL(URLUtil.uncorrect(zipPath));
                if ("file".equals(fileURL.getProtocol())) {
                    String localZipPath = fileURL.getFile();
                    topArchive = URLUtil.getTopArchive(localZipPath);
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return topArchive;
    }

    public static File getTopArchive(String localZipPath) {
        File parent;
        File topArchive = null;
        File localZipFile = new File(localZipPath);
        File child = localZipFile;
        for (parent = localZipFile.getParentFile(); parent != null && !parent.exists(); parent = parent.getParentFile()) {
            child = parent;
        }
        if (parent != null) {
            String archiveName = child.getName();
            if (child.getName().endsWith("!")) {
                archiveName = archiveName.substring(0, archiveName.length() - 1);
                topArchive = new File(parent, archiveName);
            } else {
                topArchive = parent;
            }
        }
        return topArchive;
    }

    public static URL addAuthenticationInfo(URL source, URL target) {
        String userInfo;
        if (Equaler.verifyEquals(target.getHost(), source.getHost()) && URLUtil.getUserInfo(target.toString()) == null && (userInfo = URLUtil.getUserInfo(source.toString())) != null) {
            String user = URLUtil.extractUser(userInfo);
            String pass = URLUtil.extractPassword(userInfo);
            try {
                target = URLUtil.attachUserInfo(target, user, pass.toCharArray(), false);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return target;
    }

    public static URL addReferenceInfo(URL source, URL target) {
        if (source.getRef() != null && target.getRef() == null) {
            String sourceRef = source.getRef();
            try {
                target = new URL(target.toExternalForm() + "#" + sourceRef);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return target;
    }

    public static String getInsertStringRepresentation(List<URL> urlList, URL editorLocation) {
        URL base = editorLocation;
        StringBuilder toInsert = new StringBuilder();
        for (int i = 0; i < urlList.size(); ++i) {
            String relative;
            URL url = urlList.get(i);
            URL cleared = URLUtil.clearUserInfo(url);
            if (cleared != null) {
                url = cleared;
            }
            if ((relative = URLUtil.makeRelative(base, url)) != null) {
                toInsert.append(relative);
            }
            if (i >= urlList.size() - 1) continue;
            toInsert.append(" ");
        }
        return toInsert.toString();
    }

    public static OutputStream openOutputStream(URL url) throws IOException {
        URLConnection connection = null;
        if (urlConnectionCreator != null) {
            connection = urlConnectionCreator.createURLConnection(url);
        }
        if (connection == null) {
            connection = url.openConnection();
        }
        return URLUtil.openOutputStream(connection);
    }

    public static OutputStream openOutputStream(URLConnection connection) throws IOException {
        return URLUtil.openOutputStream(connection, Collections.emptyMap());
    }

    public static OutputStream openOutputStream(final URLConnection connection, Map<String, String> headers) throws IOException {
        OutputStream original;
        OutputStream os;
        block12: {
            connection.setDoOutput(true);
            if (connection instanceof HttpURLConnection) {
                ((HttpURLConnection)connection).setRequestMethod("PUT");
            }
            for (Map.Entry<String, String> header : headers.entrySet()) {
                connection.setRequestProperty(header.getKey(), header.getValue());
            }
            os = null;
            try {
                connection.connect();
            }
            catch (FileNotFoundException ex) {
                File file;
                if (URLUtil.isWebAuthor()) {
                    throw ex;
                }
                if (!"file".equals(connection.getURL().getProtocol()) || (file = URLUtil.getCanonicalFileFromFileUrl(connection.getURL())).exists()) break block12;
                try {
                    os = new FileOutputStream(URLUtil.getCanonicalFileFromFileUrl(connection.getURL()));
                }
                catch (IOException ex2) {
                    throw ex;
                }
            }
        }
        if (os == null) {
            try {
                os = connection.getOutputStream();
            }
            catch (UnknownServiceException ex) {
                if (URLUtil.isWebAuthor()) {
                    throw ex;
                }
                if ("file".equals(connection.getURL().getProtocol())) {
                    os = new FileOutputStream(URLUtil.getCanonicalFileFromFileUrl(connection.getURL()));
                }
                throw ex;
            }
        }
        OutputStream toRet = original = os;
        toRet = new FilterOutputStream(original){

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                original.write(b, off, len);
            }

            @Override
            public void close() throws IOException {
                block4: {
                    try {
                        super.close();
                        if (!(connection instanceof HttpURLConnection)) break block4;
                        int rc = ((HttpURLConnection)connection).getResponseCode();
                        if (rc >= 200 && rc < 300) {
                            break block4;
                        }
                        throw new IOException(rc + " " + ((HttpURLConnection)connection).getResponseMessage());
                    }
                    finally {
                        URLUtil.disconnect(connection);
                    }
                }
            }
        };
        return toRet;
    }

    public static boolean isLocalFolder(URL toOpen) {
        File file = URLUtil.getCanonicalFileFromFileUrl(toOpen);
        return file != null && file.isDirectory();
    }

    public static void disconnect(URLConnection conn) {
        if (conn instanceof HttpURLConnection) {
            ((HttpURLConnection)conn).disconnect();
        }
    }

    public static boolean hasRemoteAccessProtocol(URL url) {
        return url != null && ("http".equals(url.getProtocol()) || "https".equals(url.getProtocol()) || "ftp".equals(url.getProtocol()) || "sftp".equals(url.getProtocol()));
    }

    public static String getEditorLocationKey(URL location, boolean alsoRemoveQuery) {
        int anchorIndex;
        try {
            List<? extends RelativeReferenceResolver> relativeReferenceResolvers;
            RelativeReferenceResolversProvider relativeReferenceCustomizersProvider = (RelativeReferenceResolversProvider)StaticComponentsRegistry.get(RELATIVE_REFERENCE_CUSTOMIZERS_PROVIDER);
            if (relativeReferenceCustomizersProvider != null && (relativeReferenceResolvers = relativeReferenceCustomizersProvider.getRelativeReferenceResolvers(location.getProtocol())) != null) {
                int size = relativeReferenceResolvers.size();
                for (int i = 0; i < size; ++i) {
                    RelativeReferenceResolver relativeReferenceResolver = relativeReferenceResolvers.get(i);
                    String key = relativeReferenceResolver.getEditorLocationKey(location);
                    if (key == null) continue;
                    return key;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        String key = location.toString();
        try {
            location = URLUtil.correct(location);
            URL clearedURL = URLUtil.clearUserInfo(location);
            if (clearedURL != null) {
                key = clearedURL.toString();
            } else {
                System.err.println("Could not clear user info for:" + location);
            }
        }
        catch (MalformedURLException ex) {
            ex.printStackTrace();
        }
        if (alsoRemoveQuery) {
            key = URLUtil.removeQueryOrAnchorFromName(key);
        } else if (location.getRef() != null && (anchorIndex = key.lastIndexOf("#")) != -1) {
            key = key.substring(0, anchorIndex);
        }
        return key;
    }

    public static List<URL> getURLListFromStringList(List<String> list) {
        ArrayList<URL> urlsList = new ArrayList<URL>();
        for (String urlStr : list) {
            try {
                URL url = URLUtil.correct(new URL(urlStr));
                urlsList.add(url);
            }
            catch (MalformedURLException e) {
                try {
                    URL url;
                    File file = new File(urlStr);
                    if (!file.exists() || (url = URLUtil.correct(file)) == null) continue;
                    urlsList.add(url);
                }
                catch (MalformedURLException malformedURLException) {}
            }
        }
        return urlsList;
    }

    public static boolean hasCommonProtocol(URL url) {
        boolean commonProtocol = false;
        if (url != null) {
            String protocol = url.getProtocol();
            commonProtocol = "file".equals(protocol) || "ftp".equals(protocol) || "sftp".equals(protocol) || "http".equals(protocol) || "https".equals(protocol);
        }
        return commonProtocol;
    }

    public static URLConnection openConnection(URL url) throws IOException {
        return URLUtil.openConnection(url, true);
    }

    public static URLConnection openConnection(URL url, boolean connect) throws IOException {
        if (URLUtil.isFromLocalDrive(url)) {
            url = URLUtil.removeQuery(url);
        }
        URLConnection conn = null;
        if (urlConnectionCreator != null) {
            conn = urlConnectionCreator.createURLConnection(url);
        }
        if (conn == null) {
            conn = url.openConnection();
        }
        try {
            conn.setUseCaches(false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (connect) {
            conn.connect();
        }
        return conn;
    }

    public static boolean isDefinitelyRelativePath(String path) {
        boolean relativePath = URLUtil.isRelativePath(path);
        if (relativePath && path != null && path.contains(":")) {
            return false;
        }
        return relativePath;
    }

    public static boolean isRelativePath(String path) {
        boolean toRet = true;
        if (path != null) {
            if (path.startsWith("urn:") || URLUtil.hasSpecialURIScheme(path)) {
                toRet = false;
            } else if (path.contains(":/")) {
                try {
                    URI uri = new URI(path);
                    toRet = uri.getScheme() == null;
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
        }
        return toRet;
    }

    public static URL getParentURL(URL url) throws MalformedURLException {
        String path = url.getPath();
        URL ret = url;
        if ("file".equals(url.getProtocol())) {
            String parent = new File(URLUtil.uncorrect(path)).getParent();
            if (parent != null && !(ret = URLUtil.correct(new File(parent))).toExternalForm().endsWith("/")) {
                ret = new URL(ret.toExternalForm() + "/");
            }
        } else {
            Object parent = new File(path).getParent();
            if (parent != null) {
                parent = ((String)parent).replace('\\', '/');
                if (path.startsWith("/") && !((String)parent).startsWith("/") && "".equals(url.getHost())) {
                    parent = "/" + (String)parent;
                }
                if (!((String)parent).endsWith("/")) {
                    parent = (String)parent + "/";
                }
                ret = new URL(url.getProtocol(), url.getHost(), url.getPort(), (String)parent);
            }
        }
        return ret;
    }

    public static URL getCommonAncestorURL(URL url1, URL url2) throws MalformedURLException {
        URL commonAncestorURL = null;
        if (url1.getHost().equals(url2.getHost())) {
            URL currentURL = url1;
            if (url1.toExternalForm().equals(url2.toExternalForm())) {
                commonAncestorURL = url1;
            } else if (url2 != URLUtil.getParentURL(url2)) {
                url2 = URLUtil.getParentURL(url2);
                while (currentURL != null) {
                    Object currentExt;
                    Object url2Ext = url2.toExternalForm();
                    if (!((String)url2Ext).endsWith("/")) {
                        url2Ext = (String)url2Ext + "/";
                    }
                    if (!((String)(currentExt = currentURL.toExternalForm())).endsWith("/")) {
                        currentExt = (String)currentExt + "/";
                    }
                    if (((String)url2Ext).startsWith((String)currentExt)) {
                        commonAncestorURL = currentURL;
                        break;
                    }
                    if (!URLUtil.getParentURL(currentURL).equals(currentURL)) {
                        currentURL = URLUtil.getParentURL(currentURL);
                        continue;
                    }
                    currentURL = null;
                }
            }
        }
        return commonAncestorURL;
    }

    public static String makeAbsolute(String base, String resourceLocation) {
        String toRet = null;
        if (URLUtil.isRelativePath(resourceLocation)) {
            if (base != null) {
                try {
                    URL baseURL = new URL(base);
                    URL absURL = new URL(baseURL, resourceLocation);
                    toRet = absURL.toString();
                }
                catch (MalformedURLException malformedURLException) {}
            }
        } else {
            toRet = resourceLocation;
        }
        return toRet;
    }

    public static boolean isURIWithUnknownURLScheme(String pathURL) {
        block5: {
            if (pathURL != null) {
                try {
                    URI uri = new URI(pathURL);
                    if (uri.getScheme() == null) break block5;
                    try {
                        new URL(pathURL);
                    }
                    catch (MalformedURLException ex1) {
                        return true;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    public static int[] parseLocationRef(String reference) {
        int line = -1;
        int column = -1;
        int offset = -1;
        if (reference != null) {
            try {
                Pattern cpatt;
                Matcher cm;
                reference = URLUtil.uncorrect(reference);
                Pattern lpatt = Pattern.compile("(.*?)line=(\\d*)(.*?)");
                Matcher lm = lpatt.matcher(reference);
                if (lm.lookingAt()) {
                    line = NumberParserUtil.parseInt(lm.group(2));
                    Pattern colpatt = Pattern.compile("(.*?)column=(\\d*)(.*?)");
                    Matcher colm = colpatt.matcher(reference);
                    if (colm.lookingAt()) {
                        column = NumberParserUtil.parseInt(colm.group(2));
                    }
                }
                if ((cm = (cpatt = Pattern.compile("(.*?)char=(\\d*)(.*?)")).matcher(reference)).lookingAt()) {
                    offset = NumberParserUtil.parseInt(cm.group(2));
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return new int[]{line, column, offset};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean existsLocalFile(String uri) {
        boolean exists = false;
        if (uri.startsWith("file:")) {
            try {
                File file = URLUtil.getCanonicalFileFromFileUrl(new URL(uri));
                exists = file.isFile();
            }
            catch (MalformedURLException file) {}
        } else if (uri.startsWith("jar:")) {
            InputStream inputStream = null;
            try {
                URL url = new URL(uri);
                inputStream = url.openConnection().getInputStream();
                inputStream.read();
                exists = true;
            }
            catch (Exception e) {
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        exists = false;
                    }
                }
            }
        }
        return exists;
    }

    public static String encodeURIComponent(String string) {
        String result = null;
        try {
            result = URLEncoder.encode(string, "UTF-8").replace("+", "%20").replace("%21", "!").replace("%27", "'").replace("%28", "(").replace("%29", ")").replace("%7E", "~");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return result;
    }

    public static String decodeURIComponent(String string) {
        if (string == null) {
            return null;
        }
        String decoded = null;
        try {
            decoded = URLDecoder.decode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return decoded;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getCommonRelativePath(URL localURL, URL remoteURL) {
        String toRet;
        if (localURL == null) return null;
        if (remoteURL == null) {
            return null;
        }
        String st1 = localURL.toExternalForm();
        String st2 = remoteURL.toExternalForm();
        if (st1.isEmpty()) return null;
        if (st2.isEmpty()) {
            return null;
        }
        char urlSeparator = '/';
        int commonPathMarker = 0;
        int i = st1.length() - 1;
        for (int j = st2.length() - 1; i > 0 && j > 0; --i, --j) {
            int cp1 = Character.codePointAt(st1, i);
            int cp2 = Character.codePointAt(st2, j);
            if (!PlatformDetector.isLinux()) {
                cp1 = Character.toLowerCase(cp1);
                cp2 = Character.toLowerCase(cp2);
            }
            if (cp1 == cp2) continue;
            commonPathMarker = i;
            break;
        }
        if ((toRet = st1.substring(commonPathMarker)).isEmpty()) {
            return null;
        }
        String protocol = localURL.getProtocol();
        boolean isFileProtocol = protocol.equals("file");
        if (commonPathMarker != 0) {
            int urlSeparatorFirstIndex = toRet.indexOf(urlSeparator);
            if (urlSeparatorFirstIndex == -1) return null;
            toRet = toRet.substring(urlSeparatorFirstIndex + 1);
        } else if (toRet.startsWith(protocol + ":")) {
            toRet = toRet.substring(protocol.length() + (isFileProtocol ? 2 : 3));
        }
        if (!PlatformDetector.isWinXPOrLater()) return toRet;
        if (!isFileProtocol) return toRet;
        return toRet.replace(urlSeparator, File.separatorChar);
    }

    public static String generateUniqueFileName(URL url) {
        return url.toString().hashCode() + URLUtil.extractFileName(url);
    }

    public static String convertUrlWithNoProtocolToHTTP(String hrefValue) {
        if (hrefValue == null) {
            return null;
        }
        Object correctUrl = hrefValue;
        if (!URLUtil.hasSpecialURIScheme(hrefValue)) {
            StringBuilder regEx = new StringBuilder();
            regEx.append("^[a-z+0-9.]+:\\/");
            regEx.append("|^[/.]");
            regEx.append("|^[^./]+(/|\\z)");
            regEx.append("|^[^./]+(.html|.htm)");
            Pattern pattern = Pattern.compile(regEx.toString());
            Matcher matcher = pattern.matcher(hrefValue);
            boolean find = matcher.find();
            if (!find) {
                correctUrl = "http://" + hrefValue;
            }
        }
        return correctUrl;
    }

    public static boolean isFileUrlWithWrongNumberOfSlahses(String href) {
        if (href.startsWith("file://") && !href.startsWith("file:///")) {
            URL url;
            try {
                url = new URL(href);
            }
            catch (MalformedURLException e) {
                return false;
            }
            return url.getHost().length() == 1;
        }
        return false;
    }

    public static URL correct(File file) throws MalformedURLException {
        if (file == null) {
            throw new MalformedURLException("The url is null");
        }
        return new URL(URLUtil.correct(file.toURL().toString(), true));
    }

    public static URL correct(URL url) throws MalformedURLException {
        if (url == null) {
            throw new MalformedURLException("The url is null");
        }
        return new URL(URLUtil.correct(url.toString(), false));
    }

    public static String extractUser(String userInfo) {
        if (userInfo == null) {
            return null;
        }
        int index = userInfo.lastIndexOf(58);
        if (index == -1) {
            return userInfo;
        }
        return userInfo.substring(0, index);
    }

    public static String extractPassword(String userInfo) {
        if (userInfo == null) {
            return null;
        }
        String password = "";
        int index = userInfo.lastIndexOf(58);
        if (index != -1 && index < userInfo.length() - 1) {
            password = userInfo.substring(index + 1);
        }
        return password;
    }

    @Deprecated
    public static URL attachUserInfo(URL url, String user, char[] password) throws MalformedURLException {
        return URLUtil.attachUserInfo(url, user, password, false);
    }

    public static URL attachUserInfo(URL url, String user, char[] password, boolean forceCorrection) throws MalformedURLException {
        return URLUtil.attachUserInfo(url, user, password, forceCorrection, true);
    }

    public static URL attachUserInfo(URL url, String user, char[] password, boolean forceCorrectionOfUserPasswordInfo, boolean correct) throws MalformedURLException {
        if (url == null) {
            return null;
        }
        if ((url.getAuthority() == null || "".equals(url.getAuthority())) && !"jar".equals(url.getProtocol())) {
            return url;
        }
        StringBuilder buf = new StringBuilder();
        String protocol = url.getProtocol();
        if (protocol.equals("jar")) {
            URL newURL = new URL(url.getPath());
            newURL = URLUtil.attachUserInfo(newURL, user, password, forceCorrectionOfUserPasswordInfo);
            buf.append("jar:");
            buf.append(newURL.toString());
        } else {
            String ref;
            if (correct) {
                password = URLUtil.correctPassword(password, forceCorrectionOfUserPasswordInfo);
            }
            if (correct) {
                user = URLUtil.correctUser(user, forceCorrectionOfUserPasswordInfo);
            }
            buf.append(protocol);
            buf.append("://");
            if (!"file".equals(protocol) && user != null && user.trim().length() > 0) {
                buf.append(user);
                if (password != null && password.length > 0) {
                    buf.append(":");
                    buf.append(password);
                }
                buf.append("@");
            }
            buf.append(url.getHost());
            if (url.getPort() > 0) {
                buf.append(":");
                buf.append(url.getPort());
            }
            buf.append(url.getPath());
            String query = url.getQuery();
            if (query != null && query.trim().length() > 0) {
                buf.append("?").append(query);
            }
            if ((ref = url.getRef()) != null && ref.trim().length() > 0) {
                buf.append("#").append(ref);
            }
        }
        return new URL(buf.toString());
    }

    public static String correctUser(String user, boolean forceCorrection) {
        if (user != null && user.trim().length() > 0 && (forceCorrection || user.indexOf(37) == -1)) {
            String escaped = FilePathToURI.escapeSpecialAsciiAndNonAscii(user);
            StringBuilder totalEscaped = new StringBuilder();
            for (int i = 0; i < escaped.length(); ++i) {
                char ch = escaped.charAt(i);
                if (ch == '@' || ch == '/' || ch == ':') {
                    totalEscaped.append('%').append(Integer.toHexString(ch).toUpperCase(Locale.ENGLISH));
                    continue;
                }
                totalEscaped.append(ch);
            }
            user = totalEscaped.toString();
        }
        return user;
    }

    public static char[] correctPassword(char[] password, boolean forceCorrection) {
        if (password != null && (forceCorrection || new String(password).indexOf(37) == -1)) {
            String escaped = FilePathToURI.escapeSpecialAsciiAndNonAscii(new String(password));
            StringBuilder totalEscaped = new StringBuilder();
            for (int i = 0; i < escaped.length(); ++i) {
                char ch = escaped.charAt(i);
                if (ch == '@' || ch == '/' || ch == ':' || ch == '!') {
                    totalEscaped.append('%').append(Integer.toHexString(ch).toUpperCase(Locale.ENGLISH));
                    continue;
                }
                totalEscaped.append(ch);
            }
            password = totalEscaped.toString().toCharArray();
        }
        return password;
    }

    public static URL clearUserInfo(URL url) {
        if (url != null) {
            try {
                if (!"file".equals(url.getProtocol())) {
                    return URLUtil.attachUserInfo(url, null, null, false);
                }
                return url;
            }
            catch (MalformedURLException e) {
                return null;
            }
        }
        return null;
    }

    public static URL clearUserInfo(String systemID) {
        try {
            URL url = new URL(systemID);
            if (!"file".equals(url.getProtocol())) {
                return URLUtil.attachUserInfo(url, null, null, false);
            }
            return url;
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public static String correct(String url, boolean forceCorrection) {
        int queryIndex;
        int refIndex;
        String uncorrectedURL;
        URL urlWithoutUserInfo;
        if (url == null) {
            return null;
        }
        if (((String)url).startsWith("file://") && !((String)url).startsWith("file:///") && PlatformDetector.isWin()) {
            url = "file:////" + ((String)url).substring("file://".length());
        }
        String userInfo = URLUtil.getUserInfo((String)url);
        String user = URLUtil.extractUser(userInfo);
        String pass = URLUtil.extractPassword(userInfo);
        String initialUrl = url;
        if ((user != null || pass != null) && (urlWithoutUserInfo = URLUtil.clearUserInfo((String)url)) != null) {
            url = URLUtil.clearUserInfo((String)url).toString();
        }
        if (FilePathToURI.isDisableCorrectionForOverAsciiChars() && ((String)url).contains("%") && URLUtil.containsOverAsciiChars(uncorrectedURL = URLUtil.uncorrect((String)url))) {
            url = uncorrectedURL;
        }
        if (!forceCorrection && ((String)url).indexOf("%") != -1) {
            return initialUrl;
        }
        String reference = null;
        if (!forceCorrection && (refIndex = ((String)url).indexOf(35)) != -1) {
            reference = FilePathToURI.filepath2URI(((String)url).substring(refIndex + 1));
            url = ((String)url).substring(0, refIndex);
        }
        StringBuilder queryBuffer = null;
        if (!forceCorrection && (queryIndex = ((String)url).indexOf(63)) != -1) {
            String query = ((String)url).substring(queryIndex + 1);
            url = ((String)url).substring(0, queryIndex);
            queryBuffer = new StringBuilder(query.length());
            StringTokenizer st = new StringTokenizer(query, "&");
            while (st.hasMoreElements()) {
                String token = st.nextToken();
                token = FilePathToURI.filepath2URI(token);
                queryBuffer.append(token);
                if (!st.hasMoreElements()) continue;
                queryBuffer.append("&");
            }
        }
        Object toReturn = FilePathToURI.filepath2URI((String)url);
        if (queryBuffer != null) {
            toReturn = (String)toReturn + "?" + queryBuffer.toString();
        }
        if (reference != null) {
            toReturn = (String)toReturn + "#" + reference;
        }
        if (user != null || pass != null) {
            try {
                if (user == null) {
                    user = "";
                }
                if (pass == null) {
                    pass = "";
                }
                toReturn = URLUtil.attachUserInfo(new URL((String)toReturn), user, pass.toCharArray(), forceCorrection).toString();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return toReturn;
    }

    public static boolean containsOverNonAsciiCharsWhichWouldBeEncoded(String url) {
        return !FilePathToURI.isDisableCorrectionForOverAsciiChars() && URLUtil.containsOverAsciiChars(URLUtil.uncorrect(url));
    }

    private static boolean containsOverAsciiChars(String url) {
        int len = url.length();
        for (int i = 0; i < len; ++i) {
            char ch = url.charAt(i);
            if (ch < '\u0080' || !Character.isAlphabetic(ch)) continue;
            return true;
        }
        return false;
    }

    public static String getUserInfo(String url) {
        String userInfo = null;
        int startIndex = Integer.MIN_VALUE;
        int nextSlashIndex = Integer.MIN_VALUE;
        int endIndex = Integer.MIN_VALUE;
        try {
            startIndex = url.indexOf("//");
            if (startIndex != -1) {
                nextSlashIndex = url.indexOf(47, startIndex += 2);
                if (nextSlashIndex == -1) {
                    nextSlashIndex = url.length();
                }
                if ((endIndex = url.substring(startIndex, nextSlashIndex).lastIndexOf(64)) != -1) {
                    userInfo = url.substring(startIndex, startIndex + endIndex);
                }
            }
        }
        catch (StringIndexOutOfBoundsException ex) {
            System.err.println("String index out of bounds for:|" + url + "|");
            System.err.println("Start index: " + startIndex);
            System.err.println("Next slash index " + nextSlashIndex);
            System.err.println("End index :" + endIndex);
            System.err.println("User info :|" + userInfo + "|");
            ex.printStackTrace();
        }
        return userInfo;
    }

    public static String replaceBackSlash(String url) {
        int indexOfDoubleSlash = ((String)url).indexOf("//");
        if (indexOfDoubleSlash != -1) {
            int endOfUserInfo = ((String)url).indexOf("@", indexOfDoubleSlash + 2);
            if (endOfUserInfo != -1) {
                String pathAfterThirdSlash = ((String)url).substring(endOfUserInfo + 1);
                String beforeThirdSlash = ((String)url).substring(0, endOfUserInfo + 1);
                url = beforeThirdSlash + pathAfterThirdSlash.replace('\\', '/');
            } else {
                url = ((String)url).replace('\\', '/');
            }
        } else {
            url = ((String)url).replace('\\', '/');
        }
        return url;
    }

    public static File getCanonicalFileFromFileUrl(URL url) {
        return URLUtil.getFileFromFileUrl(url, true, true, false);
    }

    public static File getCanonicalFileFromFileUrl(URL url, boolean avoidNativeCanonicalizationOnMacLinux) {
        return URLUtil.getFileFromFileUrl(url, true, avoidNativeCanonicalizationOnMacLinux, false);
    }

    public static File getAbsoluteFileFromFileUrl(URL url) {
        return URLUtil.getFileFromFileUrl(url, false, true, false);
    }

    public static File getFileFromFileUrl(URL url, boolean canonical, boolean avoidNativeCanonicalizationOnMacLinux, boolean avoidNativeCanonicalizationOnWindows) {
        try {
            return URLUtil.getFileFromFileUrlInternal(url, canonical, avoidNativeCanonicalizationOnMacLinux, avoidNativeCanonicalizationOnWindows);
        }
        catch (AccessControlException e) {
            return null;
        }
    }

    public static File getFileFromFileUrlInternal(URL url, boolean canonical, boolean avoidNativeCanonicalizationOnMacLinux, boolean avoidNativeCanonicalizationOnWindows) {
        File file = null;
        if (url == null) {
            throw new NullPointerException("The URL cannot be null.");
        }
        if ("file".equals(url.getProtocol())) {
            boolean hasHost;
            String host = url.getHost();
            Object fileName = url.getFile();
            boolean bl = hasHost = host != null && host.length() > 0;
            if (PlatformDetector.isWin() && hasHost) {
                fileName = "//" + host + (String)fileName;
            }
            fileName = URLUtil.removeQueryOrAnchorFromName((String)fileName);
            String path = URLUtil.uncorrect((String)fileName);
            file = new File(path);
            if (!path.startsWith("\\\\") && !path.startsWith("//")) {
                if (canonical) {
                    boolean autoCanonicalization = false;
                    if (PlatformDetector.isWin()) {
                        autoCanonicalization = !avoidNativeCanonicalizationOnWindows;
                    } else {
                        boolean bl2 = autoCanonicalization = !avoidNativeCanonicalizationOnMacLinux;
                    }
                    if (autoCanonicalization) {
                        try {
                            file = file.getCanonicalFile();
                        }
                        catch (IOException e) {
                            autoCanonicalization = false;
                        }
                    }
                    String absolutePath = file.getAbsolutePath();
                    if (!autoCanonicalization) {
                        absolutePath = URLUtil.simpleCanonicalization(absolutePath);
                        file = new File(absolutePath);
                    }
                } else {
                    file = file.getAbsoluteFile();
                }
            } else if (canonical) {
                file = new File(URLUtil.simpleCanonicalization(file.getAbsolutePath()));
            }
        }
        return file;
    }

    private static String simpleCanonicalization(String absolutePath) {
        try {
            StringBuilder sb = new StringBuilder(absolutePath.length());
            int len = absolutePath.length();
            for (int i = 0; i < len; ++i) {
                char ch = absolutePath.charAt(i);
                if ('.' == ch) {
                    char c = '\uffffffff';
                    if (i > 0) {
                        c = absolutePath.charAt(i - 1);
                    }
                    char c2 = '\uffffffff';
                    if (i + 1 < len) {
                        c2 = absolutePath.charAt(i + 1);
                    }
                    int nextNextChar = -1;
                    if (i + 2 < len) {
                        nextNextChar = absolutePath.charAt(i + 2);
                    }
                    if (c2 == -1) continue;
                    if (File.separatorChar == c2 && File.separatorChar == c) {
                        ++i;
                        continue;
                    }
                    if (c2 == '.' && File.separatorChar == c) {
                        if (nextNextChar != -1) {
                            char afterNextChar = absolutePath.charAt(i + 2);
                            if (afterNextChar == File.separatorChar || afterNextChar == '\uffffffff') {
                                i += 2;
                                int lastSlash = sb.lastIndexOf(File.separator, sb.length() - 2);
                                if (lastSlash == -1) continue;
                                sb.delete(lastSlash + 1, sb.length());
                                continue;
                            }
                            sb.append(ch);
                            continue;
                        }
                        sb.append(ch);
                        continue;
                    }
                    if (c2 == '\uffffffff') continue;
                    sb.append(ch);
                    continue;
                }
                sb.append(ch);
            }
            return sb.toString();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return absolutePath;
        }
    }

    public static String uncorrect(String s) {
        if (s == null) {
            return null;
        }
        if (s.indexOf(37) == -1) {
            return s;
        }
        StringBuilder sbuf = new StringBuilder();
        int l = s.length();
        int ch = -1;
        int b = 0;
        int sumb = 0;
        boolean applyUTF8dec = false;
        int more = -1;
        for (int i = 0; i < l; ++i) {
            char current = s.charAt(i);
            ch = current;
            switch (ch) {
                case 37: {
                    if (i + 2 >= s.length()) break;
                    int hb = (Character.isDigit((char)(ch = (int)s.charAt(++i))) ? ch - 48 : 10 + Character.toLowerCase((char)ch) - 97) & 0xF;
                    ch = s.charAt(++i);
                    int lb = (Character.isDigit((char)ch) ? ch - 48 : 10 + Character.toLowerCase((char)ch) - 97) & 0xF;
                    b = hb << 4 | lb;
                    applyUTF8dec = true;
                    break;
                }
                default: {
                    b = ch;
                    applyUTF8dec = false;
                }
            }
            if (applyUTF8dec) {
                if ((b & 0xC0) == 128) {
                    sumb = sumb << 6 | b & 0x3F;
                    if (--more != 0) continue;
                    sbuf.append((char)sumb);
                    continue;
                }
                if ((b & 0x80) == 0) {
                    sbuf.append((char)b);
                    continue;
                }
                if ((b & 0xE0) == 192) {
                    sumb = b & 0x1F;
                    more = 1;
                    continue;
                }
                if ((b & 0xF0) == 224) {
                    sumb = b & 0xF;
                    more = 2;
                    continue;
                }
                if ((b & 0xF8) == 240) {
                    sumb = b & 7;
                    more = 3;
                    continue;
                }
                if ((b & 0xFC) == 248) {
                    sumb = b & 3;
                    more = 4;
                    continue;
                }
                sumb = b & 1;
                more = 5;
                continue;
            }
            sbuf.append(current);
            more = -1;
        }
        return sbuf.toString();
    }

    public static String[] splitUserAndDomain(String userWithDomain) {
        String[] userDomain = new String[]{userWithDomain, ""};
        int slashIndex = userWithDomain.indexOf(92);
        if (slashIndex == -1) {
            slashIndex = userWithDomain.indexOf(47);
        }
        if (slashIndex != -1) {
            userDomain[1] = userWithDomain.substring(0, slashIndex);
            userDomain[0] = slashIndex < userWithDomain.length() - 1 ? userWithDomain.substring(slashIndex + 1) : "";
        }
        return userDomain;
    }

    public static String filterPasswords(String message) {
        if (message == null) {
            return null;
        }
        if (message.indexOf("@") != -1) {
            return message.replaceAll("://([^\\:\\/\\@\\s]*?):([^\\:\\/\\s]*?)@", "://$1:******@");
        }
        return message;
    }

    public static boolean hasSpecialURIScheme(String uriValue) {
        if (uriValue != null) {
            for (int i = 0; i < URI_SCHEMES.length; ++i) {
                if (!uriValue.startsWith(URI_SCHEMES[i])) continue;
                return true;
            }
        }
        return false;
    }

    public static File getCanonicalFile(File file) {
        boolean autoCanonicalization = PlatformDetector.isWin();
        if (autoCanonicalization) {
            try {
                file = file.getCanonicalFile();
            }
            catch (IOException e) {
                autoCanonicalization = false;
            }
        }
        if (!autoCanonicalization) {
            String absolutePath = file.getAbsolutePath();
            absolutePath = URLUtil.simpleCanonicalization(absolutePath);
            file = new File(absolutePath);
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static URL copyURL(URL sourceURL, URL targetURL) throws MalformedURLException, IOException {
        URLConnection sourceConnection = null;
        URLConnection targetConnection = null;
        try {
            File parentFile;
            sourceURL = URLUtil.correct(sourceURL);
            sourceConnection = sourceURL.openConnection();
            InputStream input = sourceConnection.getInputStream();
            targetURL = URLUtil.correct(targetURL);
            File targetFile = URLUtil.getCanonicalFileFromFileUrl(targetURL);
            if (targetFile != null && (parentFile = targetFile.getParentFile()) != null && !parentFile.exists()) {
                parentFile.mkdirs();
            }
            targetConnection = targetURL.openConnection();
            OutputStream output = null;
            try {
                output = URLUtil.openOutputStream(targetConnection);
            }
            catch (UnknownServiceException ex) {
                if (URLUtil.isWebAuthor()) {
                    throw ex;
                }
                if ("file".equals(targetURL.getProtocol())) {
                    output = new FileOutputStream(targetFile);
                }
                throw ex;
            }
            FileSystemUtilBasic.copyInputStreamToOutputStream(input, output, true);
        }
        catch (Throwable throwable) {
            URLUtil.disconnect(sourceConnection);
            URLUtil.disconnect(targetConnection);
            throw throwable;
        }
        URLUtil.disconnect(sourceConnection);
        URLUtil.disconnect(targetConnection);
        return targetURL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyURLToFile(URL sourceURL, File targetFile) throws MalformedURLException, IOException {
        URLConnection sourceConnection = null;
        try {
            sourceURL = URLUtil.correct(sourceURL);
            sourceConnection = URLUtil.openConnection(sourceURL);
            InputStream input = sourceConnection.getInputStream();
            File parentOfFile = targetFile.getParentFile();
            if (parentOfFile != null && !parentOfFile.exists()) {
                parentOfFile.mkdirs();
            }
            FileOutputStream output = new FileOutputStream(targetFile);
            FileSystemUtilBasic.copyInputStreamToOutputStream(input, output, true);
        }
        catch (Throwable throwable) {
            URLUtil.disconnect(sourceConnection);
            throw throwable;
        }
        URLUtil.disconnect(sourceConnection);
    }

    public static String getExtension(String name) {
        return FileSystemUtilBasic.getExtension(URLUtil.removeQueryOrAnchorFromName(name));
    }

    public static String getRelativeLocation(String baseUri, String fileUri) {
        try {
            return URLUtil.getRelativeLocation(new URL(baseUri), new URL(fileUri));
        }
        catch (Exception e) {
            return fileUri;
        }
    }

    public static String getRelativeLocation(URL base, URL file) {
        if (base.getProtocol().equals(file.getProtocol())) {
            return URLUtil.getRelativePath(base.getPath(), file.getPath());
        }
        return file.toString();
    }

    public static String getRelativePath(String basePath, String originalPath) {
        return FileSystemUtilBasic.getRelativePath(basePath, originalPath, '/');
    }

    public static String makeRelative(URL baseURL, URL childURL) {
        return URLUtil.makeRelative(baseURL, childURL, true, true);
    }

    public static String makeRelative(URL baseURL, URL childURL, boolean preserveQuery, boolean preserveAnchor) {
        int i;
        try {
            List<? extends RelativeReferenceResolver> relativeReferenceResolvers;
            RelativeReferenceResolversProvider relativeReferenceCustomizersProvider = (RelativeReferenceResolversProvider)StaticComponentsRegistry.get(RELATIVE_REFERENCE_CUSTOMIZERS_PROVIDER);
            if (relativeReferenceCustomizersProvider != null && (relativeReferenceResolvers = relativeReferenceCustomizersProvider.getRelativeReferenceResolvers(baseURL.getProtocol())) != null) {
                int size = relativeReferenceResolvers.size();
                for (int i2 = 0; i2 < size; ++i2) {
                    RelativeReferenceResolver relativeReferenceResolver = relativeReferenceResolvers.get(i2);
                    String rel = relativeReferenceResolver.makeRelative(baseURL, childURL);
                    if (rel == null) continue;
                    return rel;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (!Equaler.verifyEquals(baseURL.getProtocol(), childURL.getProtocol())) {
            return childURL.toString();
        }
        if (!Equaler.verifyEquals(baseURL.getHost(), childURL.getHost())) {
            return childURL.toString();
        }
        if (baseURL != null && childURL != null && baseURL.getPort() != childURL.getPort()) {
            return childURL.toString();
        }
        String base = baseURL.getPath();
        String child = childURL.getPath();
        String query = null;
        if (preserveQuery) {
            query = childURL.getQuery();
        }
        String anchor = null;
        if (preserveAnchor) {
            anchor = childURL.getRef();
        }
        if (nxdUtil != null && nxdUtil.isNXDURL(baseURL) && nxdUtil.isNXDURL(childURL)) {
            String childPath;
            String basePath = nxdUtil.getResourcePath(baseURL);
            if (basePath != null) {
                base = basePath;
            }
            if ((childPath = nxdUtil.getResourcePath(childURL)) != null) {
                child = childPath;
            }
        }
        int childLen = child.length();
        int baseLen = base.length();
        for (i = 0; i < childLen && i < baseLen && child.charAt(i) == base.charAt(i); ++i) {
        }
        String common = child.substring(0, i);
        while (i > 0) {
            if (common.charAt(--i) != '/') continue;
            ++i;
            break;
        }
        String basePart = base.substring(i);
        String childPart = child.substring(i);
        if (PlatformDetector.isWin() && i == 1 && (base.length() > 2 && base.charAt(2) == ':' || child.length() > 2 && child.charAt(2) == ':')) {
            return childURL.toString();
        }
        StringTokenizer tok = new StringTokenizer(basePart, "/", true);
        ArrayList<String> strs = new ArrayList<String>(10);
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            strs.add(token);
        }
        StringBuilder result = new StringBuilder();
        int size = strs.size();
        for (int j = 0; j < size; j += 2) {
            if (j + 1 >= size || !((String)strs.get(j + 1)).equals("/")) continue;
            result.append("..");
            result.append("/");
        }
        Object path = result + childPart;
        if (((String)path).length() == 0) {
            path = ".";
        }
        if (query != null && query.length() > 0) {
            path = (String)path + "?" + query;
        }
        if (anchor != null && anchor.length() > 0) {
            path = (String)path + "#" + anchor;
        }
        return path;
    }

    public static URL resolveRelativeSystemIDs(URL baseSystemID, String systemID) {
        if (systemID != null) {
            block8: {
                if (baseSystemID != null) break block8;
                return new URL(systemID);
            }
            try {
                URL resolved = null;
                if (nxdUtil != null && nxdUtil.isNXDURL(baseSystemID)) {
                    resolved = nxdUtil.resolveRelative(baseSystemID, systemID);
                }
                if (resolved == null) {
                    resolved = new URL(baseSystemID, systemID);
                }
                return resolved;
            }
            catch (MalformedURLException e) {
                try {
                    return new URL(systemID);
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public static File resolveRelativeSystemID(String baseSystemId, String expanded) {
        try {
            URL url = new URL(expanded);
            return URLUtil.getCanonicalFileFromFileUrl(url);
        }
        catch (MalformedURLException url) {
            File toReturn = new File(expanded);
            File inputFile = null;
            try {
                inputFile = URLUtil.getCanonicalFileFromFileUrl(new URL(baseSystemId));
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            if (!toReturn.isAbsolute() && inputFile != null) {
                toReturn = new File(inputFile.getParentFile(), expanded);
            }
            return toReturn;
        }
    }

    public static boolean isReadOnly(URL url) {
        if (url != null) {
            File local = URLUtil.getCanonicalFileFromFileUrl(url);
            if (local != null && local.exists() && local.isFile()) {
                boolean canWrite;
                try {
                    canWrite = local.canWrite();
                }
                catch (AccessControlException e) {
                    canWrite = false;
                }
                if (!canWrite) {
                    return true;
                }
            }
            if (nxdUtil != null && nxdUtil.isNXDURL(url)) {
                return nxdUtil.isReadOnly(url);
            }
        }
        return false;
    }

    public static void setRelativeReferencesCustomizersProvider(RelativeReferenceResolversProvider relativeReferenceCustomizersProvider) {
        StaticComponentsRegistry.register(RELATIVE_REFERENCE_CUSTOMIZERS_PROVIDER, relativeReferenceCustomizersProvider);
    }

    public static void setNXDUtil(NXDAccessProvider nxdUtil) {
        URLUtil.nxdUtil = nxdUtil;
    }

    public static String correctAndMakeRelative(URL baseURL, URL childURL, boolean preserveQuery, boolean preserveAnchor) {
        try {
            return URLUtil.makeRelative(URLUtil.correct(baseURL), URLUtil.correct(childURL), preserveQuery, preserveAnchor);
        }
        catch (MalformedURLException malformedURLException) {
            return URLUtil.makeRelative(baseURL, childURL, preserveQuery, preserveAnchor);
        }
    }

    public static void setAdditionalURLConnectionCreator(AdditionalURLConnectionCreator urlConnectionCreator) {
        URLUtil.urlConnectionCreator = urlConnectionCreator;
    }

    public static String getHostnameAndPort(String urlStr) throws MalformedURLException {
        URL url = new URL(urlStr);
        StringBuilder hostBuilder = new StringBuilder(url.getHost());
        int port = url.getPort();
        if (port == -1) {
            if ("http".equals(url.getProtocol())) {
                port = 80;
            } else if ("https".equals(url.getProtocol())) {
                port = 443;
            }
        }
        if (port != -1) {
            hostBuilder.append(':').append(port);
        }
        return hostBuilder.toString();
    }

    public static URL removeQueryFromFileURL(URL url) throws MalformedURLException {
        if (url != null && "file".equals(url.getProtocol()) && url.getQuery() != null) {
            url = new URL("file", null, url.getPath());
        }
        return url;
    }

    private static boolean isWebAuthor() {
        Boolean isWebAuthor = (Boolean)StaticComponentsRegistry.get("IS_WEBAUTHOR_COMPONENT");
        return isWebAuthor == null ? false : isWebAuthor;
    }

    static {
        URI_SCHEMES = new String[]{"aaa://", "aaas://", "acap://", "cap://", "cid:", "crid://", "data:", "dav:", "dict://", "dns://", "fax:", "go://", "gopher://", "h323:", "icap://", "im:", "imap://", "info:", "ipp://", "iris:", "iris.beep:", "iris.xpc:", "iris.xpcs:", "iris.lwz:", "javascript:", "ldap://", "mailto:", "mid:", "modem:", "msrp://", "msrps://", "mtqp://"};
    }
}

