/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.basic.util;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalHostUtil {
    private static final Logger logger = LoggerFactory.getLogger(LocalHostUtil.class);

    private LocalHostUtil() {
    }

    public static String getLocalHostName() throws UnknownHostException {
        String name = LocalHostUtil.getHostNameOrIp(true);
        if (logger.isDebugEnabled()) {
            logger.debug("The local host name is " + name);
        }
        return name;
    }

    public static String getLocalHostAddress() throws UnknownHostException {
        String ip = LocalHostUtil.getHostNameOrIp(false);
        if (logger.isDebugEnabled()) {
            logger.debug("The local host IP is " + ip);
        }
        return ip;
    }

    private static String getHostNameOrIp(boolean useForHostName) throws UnknownHostException {
        String host = useForHostName ? InetAddress.getLocalHost().getHostName() : InetAddress.getLocalHost().getHostAddress();
        return host;
    }

    public static String getMacHardwareAddress() {
        String macAddress;
        block7: {
            macAddress = null;
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug("Get the MAC address by iterating interfaces.");
                }
                Enumeration<NetworkInterface> networks = NetworkInterface.getNetworkInterfaces();
                ArrayList<InterfaceAndMac> macs = new ArrayList<InterfaceAndMac>();
                while (networks.hasMoreElements()) {
                    byte[] mac;
                    NetworkInterface network = networks.nextElement();
                    if (network.isLoopback() || network.isVirtual() || network.isPointToPoint()) continue;
                    String interfaceName = network.getDisplayName();
                    if (logger.isDebugEnabled()) {
                        logger.debug("Candidate interface " + interfaceName);
                    }
                    if ((mac = network.getHardwareAddress()) == null) continue;
                    macAddress = LocalHostUtil.serializeMacAddress(mac);
                    InterfaceAndMac itf = new InterfaceAndMac(interfaceName, macAddress);
                    macs.add(itf);
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug(interfaceName + " " + macAddress);
                }
                if (macs.size() > 0) {
                    Collections.sort(macs);
                    macAddress = ((InterfaceAndMac)macs.get(0)).getMacAddress();
                }
            }
            catch (Throwable t) {
                if (!logger.isDebugEnabled()) break block7;
                logger.debug(t.getMessage(), t);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Mac Address: {}", macAddress);
        }
        return macAddress;
    }

    private static String serializeMacAddress(byte[] mac) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < mac.length; ++i) {
            sb.append(String.format("%02X%s", mac[i], i < mac.length - 1 ? "-" : ""));
        }
        return sb.toString();
    }

    static class InterfaceAndMac
    implements Comparable<InterfaceAndMac> {
        private static final String UNNAMED = "zz-unnamed";
        private String interfaceName;
        private String macAddress;

        public InterfaceAndMac(String interfaceName, String macAddress) {
            this.interfaceName = interfaceName;
            if (this.interfaceName == null) {
                this.interfaceName = UNNAMED;
            }
            this.macAddress = macAddress;
            if (this.macAddress == null) {
                this.macAddress = UNNAMED;
            }
        }

        public String getMacAddress() {
            if (UNNAMED.equals(this.macAddress)) {
                return null;
            }
            return this.macAddress;
        }

        @Override
        public int compareTo(InterfaceAndMac o) {
            boolean nsw = this.interfaceName.startsWith("en");
            boolean osw = o.interfaceName.startsWith("en");
            if (nsw && !osw) {
                return -1;
            }
            if (!nsw && osw) {
                return 1;
            }
            return 0;
        }

        public String toString() {
            return this.interfaceName + " / " + this.macAddress;
        }
    }
}

