/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.basic.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.util.PlatformDetector;

class FilePermissionSetter {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)FilePermissionSetter.class.getName());

    FilePermissionSetter() {
    }

    void addOnwerReadPerm(File keyFile) {
        if (!PlatformDetector.isWin()) {
            try {
                Set<PosixFilePermission> permissions = Files.getPosixFilePermissions(keyFile.toPath(), new LinkOption[0]);
                if (!permissions.contains((Object)PosixFilePermission.OWNER_READ)) {
                    HashSet<PosixFilePermission> newPermissions = new HashSet<PosixFilePermission>();
                    newPermissions.addAll(permissions);
                    newPermissions.add(PosixFilePermission.OWNER_READ);
                    Files.setPosixFilePermissions(keyFile.toPath(), newPermissions);
                }
            }
            catch (IOException e) {
                LOGGER.debug("Error adding read permissions to owner", (Throwable)e);
            }
        }
    }

    void makeReadable(File keyFile) {
        HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>();
        perms.add(PosixFilePermission.OWNER_READ);
        try {
            Files.setPosixFilePermissions(keyFile.toPath(), perms);
        }
        catch (Exception e) {
            LOGGER.debug("Failed to make key file readable", (Throwable)e);
        }
    }

    void makeWritable(File keyFile) {
        HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>();
        perms.add(PosixFilePermission.OWNER_WRITE);
        try {
            Files.setPosixFilePermissions(keyFile.toPath(), perms);
        }
        catch (Exception e) {
            LOGGER.debug("Failed to make key file writable", (Throwable)e);
        }
    }

    void revokePermissions(File keyFile) {
        try {
            Files.setPosixFilePermissions(keyFile.toPath(), Collections.emptySet());
        }
        catch (Exception e) {
            LOGGER.warn("Failed to revoke permissions of the key file writable", (Throwable)e);
        }
    }
}

