/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.basic.util;

import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

public class DaemonThreadFactory
implements ThreadFactory {
    private ThreadFactory factory;

    public DaemonThreadFactory(ThreadFactory factory) {
        this.factory = factory;
    }

    public static ThreadFactory defaultThreadFactory() {
        return new DaemonThreadFactory(Executors.defaultThreadFactory());
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread thread = this.factory.newThread(r);
        if (!thread.isDaemon()) {
            thread.setDaemon(true);
        }
        thread.setName(thread.getName() + "- daemon");
        return thread;
    }
}

