/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.basic.statics;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.ModifiedFromTests;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;

@SkipObfuscate(classes=SkipLevel.PRIVATE, fields=SkipLevel.PRIVATE, methods=SkipLevel.PUBLIC)
public final class StaticComponentsRegistry {
    private static final Logger logger = LoggerFactory.getLogger((String)StaticComponentsRegistry.class.getName());
    private static final Map<String, Optional> registry = new ConcurrentHashMap<String, Optional>();
    @ModifiedFromTests
    private static Boolean closed = false;

    private StaticComponentsRegistry() {
        throw new IllegalStateException("Utility class for storing and analysing Web Author static components");
    }

    public static void register(String key, Object staticComponent) {
        Object oldComponent;
        if (closed.booleanValue() && ((oldComponent = StaticComponentsRegistry.get(key)) == null && staticComponent != null || oldComponent != null && staticComponent == null || oldComponent != null && !oldComponent.equals(staticComponent))) {
            logger.error("Static component registered after the registry is closed: " + key);
        }
        registry.put(key, Optional.ofNullable(staticComponent));
    }

    public static Object get(String key) {
        Optional<Object> optional = registry.getOrDefault(key, Optional.empty());
        return optional.orElse(null);
    }

    public static void close() {
        closed = true;
    }

    public static boolean isClosed() {
        return closed;
    }
}

