/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.basic.io.zip;

import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.io.zip.TraversalPathException;
import ro.sync.basic.util.URLUtil;

public final class ArchiveSecurityUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)ArchiveSecurityUtil.class.getName());

    private ArchiveSecurityUtil() {
        throw new UnsupportedOperationException("Instantiation of this utility class is not allowed!");
    }

    public static void checkSafe(String entryName, File zipEntryFile, File targetDir) throws TraversalPathException {
        File entryFile = URLUtil.getCanonicalFile(zipEntryFile);
        File targetFile = URLUtil.getCanonicalFile(targetDir);
        ArchiveSecurityUtil.isTraversalPathExploit(entryName, entryFile.getAbsolutePath(), targetFile.getAbsolutePath());
    }

    private static void isTraversalPathExploit(String entryName, String zipEntryCanonicalPath, String targetDirCanonicalPath) throws TraversalPathException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("zipEntryCanonicalPath: {}", (Object)zipEntryCanonicalPath);
            LOGGER.debug("targetDirCanonicalPath: {}", (Object)targetDirCanonicalPath);
        }
        if (!zipEntryCanonicalPath.startsWith(targetDirCanonicalPath + File.separator)) {
            throw new TraversalPathException(ArchiveSecurityUtil.createExceptionMessage(entryName));
        }
    }

    private static String createExceptionMessage(String entryName) {
        StringBuilder exceptionMessage = new StringBuilder();
        exceptionMessage.append("Cannot extract archive content.\n");
        exceptionMessage.append("For security reasons, archive entries cannot be extracted outside of the target directory.\n\n");
        exceptionMessage.append("The following entry appears to be a path traversal:\n");
        exceptionMessage.append(entryName);
        return exceptionMessage.toString();
    }
}

