/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.basic.io;

import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LineSeparatorFilterReader
extends FilterReader {
    private static Logger logger = LoggerFactory.getLogger((String)LineSeparatorFilterReader.class.getName());
    private static final boolean DEBUG_ENABLED = logger.isDebugEnabled();
    private static final int BUFFER_SIZE = 4096;
    private char[] singleChar = new char[1];
    private char[] internalBuffer = null;
    private int bufferPosition = -1;
    private int lastReadCount;
    private char[] newEOL;
    private boolean skipCRInLastTime;
    private final int bufferSize;

    public LineSeparatorFilterReader(Reader wrappedReader, char[] newEOL, int bufferSize) {
        super(wrappedReader);
        this.newEOL = newEOL;
        this.bufferSize = bufferSize;
        this.internalBuffer = new char[bufferSize];
        this.bufferPosition = bufferSize;
        this.lastReadCount = 0;
    }

    public LineSeparatorFilterReader(Reader wrappedReader, char[] newEOL) {
        this(wrappedReader, newEOL, 4096);
    }

    @Override
    public int read() throws IOException {
        if (this.read(this.singleChar, 0, 1) != -1) {
            return this.singleChar[0];
        }
        return -1;
    }

    @Override
    public int read(char[] cbuf) throws IOException {
        return this.read(cbuf, 0, cbuf.length);
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int toRet = -1;
        int availableCharsInInternalBuffer = this.lastReadCount - this.bufferPosition;
        if (DEBUG_ENABLED) {
            logger.debug("availableCharsInInternalBuffer " + availableCharsInInternalBuffer);
        }
        if (availableCharsInInternalBuffer <= 0) {
            this.internalBuffer = new char[this.bufferSize];
            this.readInBuffer();
            availableCharsInInternalBuffer = this.lastReadCount - this.bufferPosition;
            if (DEBUG_ENABLED) {
                logger.debug("availableCharsInInternalBuffer after read in buffer " + availableCharsInInternalBuffer);
            }
        }
        if (availableCharsInInternalBuffer > 0) {
            if (len <= availableCharsInInternalBuffer) {
                System.arraycopy(this.internalBuffer, this.bufferPosition, cbuf, off, len);
                this.bufferPosition += len;
                toRet = len;
            } else {
                System.arraycopy(this.internalBuffer, this.bufferPosition, cbuf, off, availableCharsInInternalBuffer);
                this.bufferPosition += availableCharsInInternalBuffer;
                toRet = availableCharsInInternalBuffer;
            }
        } else if (availableCharsInInternalBuffer == 0) {
            toRet = 0;
        } else if (DEBUG_ENABLED) {
            logger.debug("EOF");
        }
        return toRet;
    }

    private void readInBuffer() throws IOException {
        if (DEBUG_ENABLED) {
            logger.debug("Read in buffer");
        }
        int readCount = -1;
        if (this.skipCRInLastTime) {
            this.lastReadCount = readCount = this.in.read(this.internalBuffer, 1, this.internalBuffer.length - 1);
            this.internalBuffer[0] = 13;
            this.lastReadCount = this.lastReadCount == -1 ? 1 : ++this.lastReadCount;
            this.skipCRInLastTime = false;
        } else {
            readCount = this.lastReadCount = this.in.read(this.internalBuffer, 0, this.internalBuffer.length);
        }
        int idx = 0;
        while (idx < this.lastReadCount) {
            if (this.internalBuffer[idx] == '\r' || this.internalBuffer[idx] == '\n') {
                boolean sameSeparator;
                char[] fileEOL = new char[]{this.internalBuffer[idx]};
                if (this.internalBuffer[idx] == '\r') {
                    if (idx + 1 < this.lastReadCount) {
                        if (this.internalBuffer[idx + 1] == '\n') {
                            fileEOL = new char[]{'\r', '\n'};
                        }
                    } else if (readCount != -1) {
                        --this.lastReadCount;
                        this.skipCRInLastTime = true;
                        break;
                    }
                }
                if (!(sameSeparator = this.verifyCharArrayEquals(fileEOL, this.newEOL))) {
                    int eolSizeDiff = fileEOL.length - this.newEOL.length;
                    if (fileEOL.length > this.newEOL.length) {
                        System.arraycopy(this.internalBuffer, idx + fileEOL.length, this.internalBuffer, idx + this.newEOL.length, this.lastReadCount - idx - fileEOL.length);
                        System.arraycopy(this.newEOL, 0, this.internalBuffer, idx, this.newEOL.length);
                        this.lastReadCount -= eolSizeDiff;
                    } else if (fileEOL.length < this.newEOL.length) {
                        if (this.lastReadCount - eolSizeDiff > this.internalBuffer.length) {
                            char[] tmpBuffer = new char[this.internalBuffer.length + 500];
                            System.arraycopy(this.internalBuffer, 0, tmpBuffer, 0, this.internalBuffer.length);
                            this.internalBuffer = tmpBuffer;
                        }
                        System.arraycopy(this.internalBuffer, idx + fileEOL.length, this.internalBuffer, idx + this.newEOL.length, this.lastReadCount - idx - fileEOL.length);
                        System.arraycopy(this.newEOL, 0, this.internalBuffer, idx, this.newEOL.length);
                        this.lastReadCount -= eolSizeDiff;
                    } else {
                        System.arraycopy(this.newEOL, 0, this.internalBuffer, idx, this.newEOL.length);
                    }
                    idx += this.newEOL.length;
                    continue;
                }
                idx += fileEOL.length;
                continue;
            }
            ++idx;
        }
        this.bufferPosition = 0;
    }

    private boolean verifyCharArrayEquals(char[] first, char[] second) {
        boolean equals;
        boolean bl = equals = first.length == second.length;
        if (equals) {
            for (int i = 0; i < first.length; ++i) {
                if (first[i] == second[i]) continue;
                equals = false;
                break;
            }
        }
        return equals;
    }
}

