/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.basic.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.basic.io.IOStreamUtil;

@SkipObfuscate(classes=SkipLevel.NOT_SPECIFIED, fields=SkipLevel.NOT_SPECIFIED, methods=SkipLevel.PUBLIC)
public class FileSystemUtilBasic {
    private static final int BUFFERED_SIZE = 130000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyInputStreamToOutputStream(InputStream is, OutputStream os, boolean closeOutputStream) throws IOException {
        BufferedOutputStream bos = new BufferedOutputStream(os, 130000);
        BufferedInputStream bis = new BufferedInputStream(is, 130000);
        try {
            int count;
            byte[] buff = new byte[16384];
            while ((count = bis.read(buff)) != -1) {
                bos.write(buff, 0, count);
            }
        }
        finally {
            IOStreamUtil.closeQuietly(bis);
            if (closeOutputStream) {
                bos.close();
            } else {
                bos.flush();
            }
        }
    }

    public static String getRelativePath(String basePath, String originalPath) {
        return FileSystemUtilBasic.getRelativePath(basePath, originalPath, File.separatorChar);
    }

    public static String getRelativePath(String basePath, String originalPath, char separator) {
        if (basePath == null || "".equals(basePath)) {
            return originalPath;
        }
        if (((String)basePath).equals(originalPath)) {
            return "";
        }
        if (!((String)basePath).endsWith(String.valueOf(separator))) {
            basePath = (String)basePath + separator;
        }
        int old1 = 0;
        int old2 = 0;
        int index1 = ((String)basePath).indexOf(separator);
        int index2 = originalPath.indexOf(separator);
        while (index1 != -1 && index1 == index2 && ((String)basePath).substring(old1, index1).equals(originalPath.substring(old2, index2))) {
            old1 = index1;
            old2 = index2;
            index1 = ((String)basePath).indexOf(separator, index1 + 1);
            index2 = originalPath.indexOf(separator, index2 + 1);
        }
        if (old2 == 0) {
            return originalPath;
        }
        StringBuilder location = new StringBuilder();
        while (index1 != -1) {
            location.append(".." + separator);
            index1 = ((String)basePath).indexOf(separator, index1 + 1);
        }
        location.append(originalPath.substring(old2 + 1));
        return location.toString();
    }

    public static String getExtension(String name) {
        int lastURLSeparatorIdx;
        int lastFileSeparatorIdx;
        int lastIndex;
        String lastName;
        int idx;
        String extension = "";
        if (name != null && (idx = (lastName = name.substring((lastIndex = (lastFileSeparatorIdx = name.lastIndexOf(File.separatorChar)) > (lastURLSeparatorIdx = name.lastIndexOf(47)) ? lastFileSeparatorIdx : lastURLSeparatorIdx) + 1)).lastIndexOf(46)) >= 0) {
            extension = lastName.substring(idx + 1);
        }
        return extension;
    }
}

