/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.basic.io;

import java.io.File;
import java.util.Comparator;
import java.util.Hashtable;

public class FileComparator
implements Comparator {
    private final Hashtable<File, Boolean> directoriesHash;

    public FileComparator() {
        this.directoriesHash = new Hashtable();
    }

    public FileComparator(Hashtable<File, Boolean> hash) {
        this.directoriesHash = hash;
    }

    public boolean isDirectory(File file) {
        Boolean isDir = this.directoriesHash.get(file);
        if (isDir == null) {
            boolean isDirBool = file.isDirectory();
            this.directoriesHash.put(file, isDirBool);
            return isDirBool;
        }
        return isDir;
    }

    public int compare(Object fileObj1, Object fileObj2) {
        File file1 = (File)fileObj1;
        File file2 = (File)fileObj2;
        boolean f1IsDir = this.isDirectory(file1);
        boolean f2IsDir = this.isDirectory(file2);
        if (f1IsDir && f2IsDir || !f1IsDir && !f2IsDir) {
            return FileComparator.compareFileName(file1.getName(), file2.getName());
        }
        if (f1IsDir) {
            return -1;
        }
        return 1;
    }

    public static int compareFileName(String f1Name, String f2Name) {
        int comparisonResult = f1Name.compareToIgnoreCase(f2Name);
        if (comparisonResult == 0) {
            comparisonResult = -f1Name.compareTo(f2Name);
        }
        return comparisonResult;
    }
}

