/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.basic.io;

import java.io.Reader;

public class CharSequenceReader
extends Reader {
    private static final StringBuilder EMPTY_BUILDER = new StringBuilder(0);
    private final CharSequence charSequence;
    private int idx;
    private int mark;
    private int cLen;

    public CharSequenceReader(CharSequence charSequence) {
        this.charSequence = charSequence != null ? charSequence : EMPTY_BUILDER;
        this.cLen = this.charSequence.length();
    }

    @Override
    public void close() {
        this.idx = 0;
        this.mark = 0;
    }

    @Override
    public void mark(int readAheadLimit) {
        this.mark = this.idx;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public int read() {
        if (this.idx >= this.cLen) {
            return -1;
        }
        return this.charSequence.charAt(this.idx++);
    }

    @Override
    public int read(char[] array, int offset, int length) {
        if (this.idx >= this.cLen) {
            return -1;
        }
        if (array == null) {
            throw new NullPointerException("Character array is missing");
        }
        if (length < 0 || offset + length > array.length) {
            throw new IndexOutOfBoundsException("Array Size=" + array.length + ", offset=" + offset + ", length=" + length);
        }
        int count = 0;
        for (int i = 0; i < length; ++i) {
            int c = this.read();
            if (c == -1) {
                return count;
            }
            array[offset + i] = (char)c;
            ++count;
        }
        return count;
    }

    @Override
    public void reset() {
        this.idx = this.mark;
    }

    @Override
    public long skip(long n) {
        if (n < 0L) {
            throw new IllegalArgumentException("Number of characters to skip is less than zero: " + n);
        }
        if (this.idx >= this.cLen) {
            return -1L;
        }
        int dest = (int)Math.min((long)this.cLen, (long)this.idx + n);
        int count = dest - this.idx;
        this.idx = dest;
        return count;
    }
}

