/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.basic.classloader;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.classloader.VirtualServicesClassLoader;

public class ClassLoaderUtil {
    private static Logger logger = LoggerFactory.getLogger((String)ClassLoaderUtil.class.getName());
    protected static ClassLoader alternateClassLoader = null;

    public static ClassLoader installContextClassLoader() {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                Thread ct = Thread.currentThread();
                ClassLoader oldClassLoader = ct.getContextClassLoader();
                if (alternateClassLoader != null) {
                    ClassLoaderUtil.setContextCLToCurrentThread(alternateClassLoader);
                } else {
                    ClassLoaderUtil.setContextCLToCurrentThread(ClassLoaderUtil.class.getClassLoader());
                }
                return oldClassLoader;
            }
        });
    }

    public static ClassLoader installContextClassLoader(final String[] services, final String[] servicesValues) {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                ClassLoader context;
                Thread ct = Thread.currentThread();
                ClassLoader oldClassLoader = ct.getContextClassLoader();
                ClassLoader classLoader = context = alternateClassLoader != null ? alternateClassLoader : ClassLoaderUtil.class.getClassLoader();
                if (services != null) {
                    try {
                        context = new VirtualServicesClassLoader(context, services, servicesValues);
                    }
                    catch (SecurityException ex) {
                        logger.warn("Could not set custom class loader because of lacking security permissions, probably running in applet " + ex, (Throwable)ex);
                    }
                }
                ClassLoaderUtil.setContextCLToCurrentThread(context);
                return oldClassLoader;
            }
        });
    }

    public static void uninstallContextClassLoader(ClassLoader oldClassLoader) {
        ClassLoaderUtil.setContextCLToCurrentThread(oldClassLoader);
    }

    public static void setContextCLToCurrentThread(final ClassLoader classLoader) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    Thread.currentThread().setContextClassLoader(classLoader);
                }
                catch (SecurityException ex) {
                    logger.warn("Could not set custom class loader because of lacking security permissions, probably running in applet " + ex, (Throwable)ex);
                }
                return null;
            }
        });
    }

    public static void setAlternateClassLoader(ClassLoader aClassLoader) {
        alternateClassLoader = aClassLoader;
    }

    public static ClassLoader getAlternateClassLoader() {
        return alternateClassLoader;
    }
}

