/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.basic.classloader;

import java.lang.reflect.Constructor;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.classloader.CLURLSetDescriptor;
import ro.sync.basic.classloader.DBLateDelegationClassLoader;
import ro.sync.basic.classloader.LateDelegationClassLoader;
import ro.sync.basic.util.Equaler;
import ro.sync.basic.util.GCUtil;

public class BasicClassLoadersRegistry {
    private static Logger logger = LoggerFactory.getLogger((String)BasicClassLoadersRegistry.class.getName());
    public static final int URL_CL_TYPE = 0;
    public static final int DB_CL_TYPE = 1;
    public static final int LATE_CL_TYPE = 3;
    private WeakHashMap<ClassLoader, CLURLSetDescriptor> clsToDescriptions = new WeakHashMap();
    HashMap<String, CLURLSetDescriptor> classloaderIdToDescriptor = new HashMap();
    Map<Integer, Class> typeToClassLoaderClassMap = new HashMap<Integer, Class>();
    public static boolean forceURLClassLoaderForDBFromTests = false;

    public BasicClassLoadersRegistry() {
        this.typeToClassLoaderClassMap.put(0, URLClassLoader.class);
        this.typeToClassLoaderClassMap.put(1, DBLateDelegationClassLoader.class);
        this.typeToClassLoaderClassMap.put(3, LateDelegationClassLoader.class);
    }

    public synchronized ClassLoader requestClassLoader(ClassLoader parentCL, URL[] urlsToLoad, int classLoaderType) {
        CLURLSetDescriptor descr = new CLURLSetDescriptor(parentCL, urlsToLoad, classLoaderType);
        if (logger.isDebugEnabled()) {
            logger.debug("Before:" + this.clsToDescriptions);
        }
        ClassLoader toReturn = null;
        boolean forceCleanup = false;
        for (ClassLoader cl : this.clsToDescriptions.keySet()) {
            CLURLSetDescriptor clDescr = this.clsToDescriptions.get(cl);
            if (descr.equals(clDescr)) {
                logger.debug("Reuse class loader");
                toReturn = cl;
                break;
            }
            if (!Equaler.verifyArrayEquals(descr.locations, clDescr.locations)) continue;
            forceCleanup = descr.locations.length > 0;
            break;
        }
        if (toReturn == null) {
            Class clClass;
            if (forceCleanup) {
                logger.debug("Force cleanup");
                Iterator<ClassLoader> iter = null;
                GCUtil.runGC();
            }
            if (parentCL == null) {
                parentCL = ClassLoader.getSystemClassLoader();
            }
            if (forceURLClassLoaderForDBFromTests && classLoaderType == 1) {
                classLoaderType = 0;
            }
            if ((clClass = this.typeToClassLoaderClassMap.get(classLoaderType)) != null) {
                try {
                    Constructor constructor = clClass.getConstructor(URL[].class, ClassLoader.class);
                    toReturn = (ClassLoader)constructor.newInstance(urlsToLoad, parentCL);
                    this.clsToDescriptions.put(toReturn, descr);
                }
                catch (Exception e) {
                    logger.error("Could not create classloader of type " + classLoaderType + ": " + clClass, (Throwable)e);
                }
            } else {
                logger.error("Could not create classloader of type " + classLoaderType + ": " + clClass);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("After:" + this.clsToDescriptions);
            }
        }
        return toReturn;
    }

    public void registerClassLoaderType(int type, Class classLoaderClass) {
        this.typeToClassLoaderClassMap.put(type, classLoaderClass);
    }

    public synchronized void mapClassLoader(ClassLoader classLoader, String classLoaderId) {
        CLURLSetDescriptor descriptor = this.clsToDescriptions.get(classLoader);
        this.classloaderIdToDescriptor.put(classLoaderId, descriptor);
    }

    public synchronized ClassLoader getClassLoader(String parentClassLoaderId) {
        ClassLoader parentClassLoader = null;
        CLURLSetDescriptor parentCLDescriptor = this.classloaderIdToDescriptor.get(parentClassLoaderId);
        if (parentCLDescriptor != null) {
            for (ClassLoader loader : this.clsToDescriptions.keySet()) {
                CLURLSetDescriptor clurlSetDescriptor = this.clsToDescriptions.get(loader);
                if (!Equaler.verifyEquals(parentCLDescriptor, clurlSetDescriptor)) continue;
                parentClassLoader = loader;
                break;
            }
            if (parentClassLoader == null) {
                logger.error("The requested class loader was probably garbage collected: " + parentClassLoaderId);
            }
        } else {
            logger.error("Unable to identify the parent class loader: " + parentClassLoaderId);
        }
        return parentClassLoader;
    }

    public WeakHashMap<ClassLoader, CLURLSetDescriptor> getClsToDescriptions() {
        return this.clsToDescriptions;
    }
}

