/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.yaml.validator;

import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.error.MarkedYAMLException;
import ro.sync.yaml.util.YAMLUtil;
import ro.sync.yaml.validator.YAMLWellformedException;

public class YAMLValidator {
    private YAMLValidator() {
    }

    public static List<Object> loadYaml(Reader documentReader) throws YAMLWellformedException {
        ArrayList<Object> yamlDocuments = new ArrayList<Object>();
        try {
            Yaml yaml = YAMLUtil.createDefaultYamlParser();
            for (Object document : yaml.loadAll(documentReader)) {
                yamlDocuments.add(document);
            }
        }
        catch (MarkedYAMLException e) {
            throw YAMLValidator.createCustomException(e);
        }
        return yamlDocuments;
    }

    public static YAMLWellformedException createCustomException(MarkedYAMLException e) {
        StringBuilder message = new StringBuilder();
        Object problem = e.getProblem().replaceFirst("found ", "");
        problem = ((String)problem).substring(0, 1).toUpperCase() + ((String)problem).substring(1);
        message.append(((String)problem).substring(0, 1).toUpperCase()).append(((String)problem).substring(1));
        String snippet = e.getProblemMark().get_snippet().replace("^", "").trim();
        message.append(": ").append("\"").append(snippet).append("\"");
        return new YAMLWellformedException(message.toString(), e.getProblemMark().getLine() + 1, e.getProblemMark().getColumn() + 1);
    }
}

