/*
 * Decompiled with CFR 0.152.
 */
package org.htmlcleaner;

import java.util.Iterator;
import java.util.List;
import org.htmlcleaner.BaseToken;
import org.htmlcleaner.HtmlNode;
import org.htmlcleaner.TagNode;
import org.htmlcleaner.XmlVisitor;

public class XmlTraversor {
    private XmlVisitor visitor;

    public static void traverse(XmlVisitor visitor, HtmlNode root) {
        HtmlNode node = root;
        int depth = 0;
        while (node != null) {
            visitor.head(node, depth);
            if (node instanceof TagNode && ((TagNode)node).hasChildren()) {
                node = (HtmlNode)((TagNode)node).getAllChildren().get(0);
                ++depth;
                continue;
            }
            List<? extends BaseToken> siblings = node.getSiblings();
            Iterator<? extends BaseToken> it = siblings.iterator();
            while (it.hasNext() && it.next() == null && depth > 0) {
                visitor.tail(node, depth);
                node = node.getParent();
                --depth;
            }
            visitor.tail(node, depth);
            if (node == root) break;
            if (it.hasNext()) {
                node = (HtmlNode)it.next();
                continue;
            }
            node = null;
        }
    }
}

