/*
 * Decompiled with CFR 0.152.
 */
package org.json;

public class JSONLocation
implements Cloneable {
    private final int startLine;
    private final int startColumn;
    private final int endLine;
    private final int endColumn;

    public JSONLocation(int startLine, int startColumn) {
        this(startLine, startColumn, -1, -1);
    }

    public JSONLocation(int startLine, int startColumn, int endLine, int endColumn) {
        this.startLine = startLine;
        this.startColumn = startColumn;
        this.endLine = endLine;
        this.endColumn = endColumn;
    }

    public int getLine() {
        return this.startLine;
    }

    public int getColumn() {
        return this.startColumn;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public int getEndColumn() {
        return this.endColumn;
    }

    public String toString() {
        return "start: " + this.startLine + ":" + this.startColumn + " end: " + this.endLine + ":" + this.endColumn;
    }

    public Object clone() throws CloneNotSupportedException {
        return new JSONLocation(this.startLine, this.startColumn, this.endLine, this.endColumn);
    }

    public boolean equals(Object obj) {
        if (obj instanceof JSONLocation) {
            JSONLocation otherLocation = (JSONLocation)obj;
            return otherLocation.startColumn == this.startColumn && otherLocation.startLine == this.startLine && otherLocation.endColumn == this.endColumn && otherLocation.endLine == this.endLine;
        }
        return false;
    }
}

