/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.dita.antextensions;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URI;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DetectLang
extends Task {
    private String documentPath;

    public void setDocumentPath(String path) {
        this.documentPath = path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        String locale;
        block16: {
            if (this.getProject() == null) {
                throw new BuildException((Throwable)new IllegalStateException("Project not available"));
            }
            if (this.getProject().getProperty("document.locale") == null) {
                try {
                    this.documentPath = this.documentPath.replace(File.separatorChar, '/');
                    File file = this.documentPath.startsWith("file:") ? new File(new URI(this.documentPath)) : new File(this.documentPath);
                    SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
                    SAXParser saxParser = saxParserFactory.newSAXParser();
                    InputStream is = this.getIsFromJob(file.toURI());
                    if (is != null) {
                        try {
                            saxParser.parse(is, new DefaultHandlerImpl(), file.toURI().toString());
                            break block16;
                        }
                        finally {
                            try {
                                is.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                    if (!file.exists()) {
                        throw new Exception("File does not exist");
                    }
                    if (!file.canRead()) {
                        throw new Exception("Can't read input file");
                    }
                    saxParser.parse(file, (DefaultHandler)new DefaultHandlerImpl());
                }
                catch (StopParsingException e) {
                    this.log("Lang search finished", 2);
                }
                catch (Exception e) {
                    throw new BuildException("Failed to read document language: " + e.getMessage(), (Throwable)e);
                }
            }
        }
        if ((locale = this.getProject().getProperty("document.locale")) != null && this.getProject().getProperty("document.language") == null) {
            this.setActiveProjectProperty("document.language", locale.substring(0, locale.length() < 2 ? locale.length() : 2));
        }
    }

    private InputStream getIsFromJob(URI uri) {
        Object job = this.getProject().getReference("job");
        if (job != null) {
            try {
                Method getStore = job.getClass().getMethod("getStore", new Class[0]);
                Object store = getStore.invoke(job, new Object[0]);
                Method meth = store.getClass().getMethod("getInputStream", URI.class);
                return (InputStream)meth.invoke(store, uri);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    private void setActiveProjectProperty(String propertyName, String propertyValue) {
        Project activeProject = this.getProject();
        if (activeProject != null) {
            activeProject.setProperty(propertyName, propertyValue);
        }
    }

    private class DefaultHandlerImpl
    extends DefaultHandler {
        private DefaultHandlerImpl() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            String classAttr = attributes.getValue("class");
            String langAttr = attributes.getValue("xml:lang");
            if (classAttr != null && langAttr != null && (classAttr.indexOf(" map/map ") > -1 || classAttr.indexOf(" topic/topic ") > -1)) {
                String partProcessedString = langAttr.replace('-', '_');
                int length = partProcessedString.length();
                Object processedString = length == 5 ? partProcessedString.substring(0, length - 2).toLowerCase() + partProcessedString.substring(length - 2).toUpperCase() : (length > 5 ? partProcessedString.substring(0, 2).toLowerCase() + partProcessedString.substring(2) : partProcessedString);
                DetectLang.this.setActiveProjectProperty("document.locale", (String)processedString);
                throw new StopParsingException();
            }
        }
    }

    private static final class StopParsingException
    extends SAXException {
        private StopParsingException() {
        }
    }
}

