/*
 * Decompiled with CFR 0.152.
 */
package org.zwobble.mammoth.internal.xml;

import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.zwobble.mammoth.internal.xml.NamespacePrefix;
import org.zwobble.mammoth.internal.xml.NamespacePrefixes;
import org.zwobble.mammoth.internal.xml.XmlElement;
import org.zwobble.mammoth.internal.xml.XmlNode;
import org.zwobble.mammoth.internal.xml.XmlNodeVisitor;
import org.zwobble.mammoth.internal.xml.XmlTextNode;

public class XmlWriter {
    private final XMLStreamWriter writer;
    private final NamespacePrefixes namespaces;

    public static String toString(XmlElement element, NamespacePrefixes namespaces) {
        return XmlWriter.toString(element, namespaces, false);
    }

    public static String toString(XmlElement element, NamespacePrefixes namespaces, boolean shouldCreateDocumentFragment) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            XmlWriter writer = new XmlWriter(XmlWriter.createXmlWriter(outputStream), namespaces);
            if (shouldCreateDocumentFragment) {
                writer.writeDocumentFragment(element);
            } else {
                writer.writeDocument(element);
            }
            return new String(outputStream.toByteArray(), StandardCharsets.UTF_8);
        }
        catch (XMLStreamException exception) {
            throw new RuntimeException(exception);
        }
    }

    private static XMLStreamWriter createXmlWriter(ByteArrayOutputStream outputStream) throws XMLStreamException {
        XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
        return outputFactory.createXMLStreamWriter(outputStream, StandardCharsets.UTF_8.name());
    }

    private XmlWriter(XMLStreamWriter writer, NamespacePrefixes namespaces) {
        this.writer = writer;
        this.namespaces = namespaces;
    }

    private void writeDocumentFragment(XmlElement element) throws XMLStreamException {
        this.writeStartElement(element);
        this.writeNamespaces(this.namespaces);
        this.writeAttributes(element);
        this.writeNodes(element.getChildren());
        this.writer.writeEndElement();
    }

    private void writeDocument(XmlElement element) throws XMLStreamException {
        this.writer.writeStartDocument("UTF-8", "1.0");
        this.writeDocumentFragment(element);
        this.writer.writeEndDocument();
    }

    private void writeNodes(List<XmlNode> children) {
        for (XmlNode child : children) {
            this.writeNode(child);
        }
    }

    private void writeNode(XmlNode child) {
        child.accept(new XmlNodeVisitor<Object>(){

            @Override
            public Object visit(XmlElement element) {
                try {
                    XmlWriter.this.writeStartElement(element);
                    XmlWriter.this.writeAttributes(element);
                    XmlWriter.this.writeNodes(element.getChildren());
                    XmlWriter.this.writer.writeEndElement();
                }
                catch (XMLStreamException exception) {
                    throw new RuntimeException(exception);
                }
                return null;
            }

            @Override
            public Object visit(XmlTextNode textNode) {
                try {
                    XmlWriter.this.writer.writeCharacters(textNode.getValue());
                }
                catch (XMLStreamException exception) {
                    throw new RuntimeException(exception);
                }
                return null;
            }
        });
    }

    private void writeNamespaces(NamespacePrefixes namespaces) throws XMLStreamException {
        for (NamespacePrefix namespace : namespaces) {
            Optional<String> prefix = namespace.getPrefix();
            if (prefix.isPresent()) {
                this.writer.writeNamespace(prefix.get(), namespace.getUri());
                continue;
            }
            this.writer.writeDefaultNamespace(namespace.getUri());
        }
    }

    private void writeStartElement(XmlElement element) throws XMLStreamException {
        XmlName name = this.readName(element.getName());
        Optional<String> prefix = name.namespace.getPrefix();
        if (prefix.isPresent()) {
            this.writer.writeStartElement(prefix.get(), name.localName, name.namespace.getUri());
        } else {
            this.writer.writeStartElement(name.localName);
        }
    }

    private void writeAttributes(XmlElement element) throws XMLStreamException {
        for (Map.Entry<String, String> attribute : element.getAttributes().entrySet()) {
            this.writeAttribute(attribute);
        }
    }

    private void writeAttribute(Map.Entry<String, String> attribute) throws XMLStreamException {
        XmlName name = this.readName(attribute.getKey());
        Optional<String> prefix = name.namespace.getPrefix();
        if (prefix.isPresent()) {
            this.writer.writeAttribute(prefix.get(), name.namespace.getUri(), name.localName, attribute.getValue());
        } else {
            this.writer.writeAttribute(name.localName, attribute.getValue());
        }
    }

    private XmlName readName(String name) {
        if (name.contains("}")) {
            String[] parts = name.split("}", 2);
            return new XmlName(new NamespacePrefix(Optional.empty(), parts[0].substring(1)), parts[1]);
        }
        String[] parts = name.split(":", 2);
        if (parts.length == 1) {
            return new XmlName(this.namespaces.defaultNamespace().get(), parts[0]);
        }
        String prefix = parts[0];
        String localName = parts[1];
        NamespacePrefix namespace = this.namespaces.lookupPrefix(prefix).orElseThrow(() -> new RuntimeException("Could not find namespace for prefix: " + prefix));
        return new XmlName(namespace, localName);
    }

    private static class XmlName {
        private final NamespacePrefix namespace;
        private final String localName;

        private XmlName(NamespacePrefix namespace, String localName) {
            this.namespace = namespace;
            this.localName = localName;
        }
    }
}

