/*
 * Decompiled with CFR 0.152.
 */
package org.zwobble.mammoth.internal.xml;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import org.zwobble.mammoth.internal.util.Iterables;
import org.zwobble.mammoth.internal.util.Maps;
import org.zwobble.mammoth.internal.xml.NamespacePrefix;

public class NamespacePrefixes
implements Iterable<NamespacePrefix> {
    private final Map<String, NamespacePrefix> uriToPrefix;

    public static Builder builder() {
        return new Builder();
    }

    public NamespacePrefixes(Map<String, NamespacePrefix> uriToPrefix) {
        this.uriToPrefix = uriToPrefix;
    }

    public Optional<NamespacePrefix> lookupUri(String uri) {
        return Maps.lookup(this.uriToPrefix, uri);
    }

    public Optional<NamespacePrefix> lookupPrefix(String prefix) {
        return this.lookupPrefix(Optional.of(prefix));
    }

    public Optional<NamespacePrefix> defaultNamespace() {
        return this.lookupPrefix(Optional.empty());
    }

    private Optional<NamespacePrefix> lookupPrefix(Optional<String> prefix) {
        return Iterables.tryFind(this.uriToPrefix.values(), namespace -> namespace.getPrefix().equals(prefix));
    }

    @Override
    public Iterator<NamespacePrefix> iterator() {
        return this.uriToPrefix.values().iterator();
    }

    public static class Builder {
        private final Map<String, NamespacePrefix> uriToPrefix = new HashMap<String, NamespacePrefix>();

        public Builder put(String prefix, String uri) {
            this.uriToPrefix.put(uri, new NamespacePrefix(Optional.of(prefix), uri));
            return this;
        }

        public Builder defaultPrefix(String uri) {
            this.uriToPrefix.put(uri, new NamespacePrefix(Optional.empty(), uri));
            return this;
        }

        public NamespacePrefixes build() {
            return new NamespacePrefixes(this.uriToPrefix);
        }
    }
}

