/*
 * Decompiled with CFR 0.152.
 */
package org.zwobble.mammoth.internal.util;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;

public class Maps {
    public static <K, V> Map<K, V> map() {
        return Collections.emptyMap();
    }

    public static <K, V> Map<K, V> map(K key1, V value1) {
        return Collections.singletonMap(key1, value1);
    }

    public static <K, V> Map<K, V> map(K key1, V value1, K key2, V value2) {
        HashMap<K, V> map = new HashMap<K, V>();
        map.put(key1, value1);
        map.put(key2, value2);
        return map;
    }

    public static <K, V> Map<K, V> map(K key1, V value1, K key2, V value2, K key3, V value3) {
        HashMap<K, V> map = new HashMap<K, V>();
        map.put(key1, value1);
        map.put(key2, value2);
        map.put(key3, value3);
        return map;
    }

    public static <K, V> Map<K, V> map(K key1, V value1, K key2, V value2, K key3, V value3, K key4, V value4) {
        HashMap<K, V> map = new HashMap<K, V>();
        map.put(key1, value1);
        map.put(key2, value2);
        map.put(key3, value3);
        map.put(key4, value4);
        return map;
    }

    public static <K, V> Map<K, V> mutableMap(K key1, V value1) {
        HashMap<K, V> map = new HashMap<K, V>();
        map.put(key1, value1);
        return map;
    }

    public static <K, V> Map.Entry<K, V> entry(K key, V value) {
        return new AbstractMap.SimpleImmutableEntry<K, V>(key, value);
    }

    public static <K, V> Optional<V> lookup(Map<K, V> map, K key) {
        return Optional.ofNullable(map.get(key));
    }

    public static <T, K> Map<K, T> toMapWithKey(Iterable<T> iterable, Function<T, K> function) {
        return Maps.toMap(iterable, element -> Maps.entry(function.apply(element), element));
    }

    public static <T, K, V> Map<K, V> toMap(Iterable<T> iterable, Function<T, Map.Entry<K, V>> function) {
        HashMap<K, V> map = new HashMap<K, V>();
        for (T element : iterable) {
            Map.Entry<K, V> entry = function.apply(element);
            map.put(entry.getKey(), entry.getValue());
        }
        return map;
    }

    public static <T, K> Map<K, List<T>> toMultiMapWithKey(Iterable<T> iterable, Function<T, K> function) {
        return Maps.toMultiMap(iterable, element -> Maps.entry(function.apply(element), element));
    }

    public static <T, K, V> Map<K, List<V>> toMultiMap(Iterable<T> iterable, Function<T, Map.Entry<K, V>> function) {
        HashMap<Object, List> map = new HashMap<Object, List>();
        for (T element : iterable) {
            Map.Entry<K, V> pair = function.apply(element);
            map.computeIfAbsent(pair.getKey(), key -> new ArrayList()).add(pair.getValue());
        }
        return map;
    }

    public static <K1, K2, V> Map<K2, V> eagerMapKeys(Map<K1, V> map, Function<K1, K2> function) {
        HashMap<K2, V> result = new HashMap<K2, V>();
        for (Map.Entry<K1, V> element : map.entrySet()) {
            result.put(function.apply(element.getKey()), element.getValue());
        }
        return result;
    }

    public static <K, V1, V2> Map<K, V2> eagerMapValues(Map<K, V1> map, Function<V1, V2> function) {
        HashMap<K, V2> result = new HashMap<K, V2>();
        for (Map.Entry<K, V1> element : map.entrySet()) {
            result.put(element.getKey(), function.apply(element.getValue()));
        }
        return result;
    }

    public static <K, V> Builder<K, V> builder() {
        return new Builder();
    }

    public static class Builder<K, V> {
        private final Map<K, V> values = new HashMap();

        public Builder<K, V> put(K key, V value) {
            this.values.put(key, value);
            return this;
        }

        public Map<K, V> build() {
            return this.values;
        }
    }
}

