/*
 * Decompiled with CFR 0.152.
 */
package org.zwobble.mammoth.internal.styles.parsing;

import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.zwobble.mammoth.internal.styles.HtmlPath;
import org.zwobble.mammoth.internal.styles.StyleMap;
import org.zwobble.mammoth.internal.styles.StyleMapBuilder;
import org.zwobble.mammoth.internal.styles.parsing.DocumentMatcherParser;
import org.zwobble.mammoth.internal.styles.parsing.HtmlPathParser;
import org.zwobble.mammoth.internal.styles.parsing.LineParseException;
import org.zwobble.mammoth.internal.styles.parsing.ParseException;
import org.zwobble.mammoth.internal.styles.parsing.StyleMappingTokeniser;
import org.zwobble.mammoth.internal.styles.parsing.TokenIterator;
import org.zwobble.mammoth.internal.styles.parsing.TokenType;

public class StyleMapParser {
    public static StyleMap parse(String input) {
        return StyleMapParser.parseStyleMappings(Arrays.asList(input.split("\\r?\\n")));
    }

    public static StyleMap parseStyleMappings(List<String> lines) {
        StyleMapBuilder styleMap = StyleMap.builder();
        for (int lineIndex = 0; lineIndex < lines.size(); ++lineIndex) {
            String line = lines.get(lineIndex);
            try {
                StyleMapParser.handleLine(styleMap, line);
                continue;
            }
            catch (LineParseException exception) {
                throw new ParseException(StyleMapParser.generateErrorMessage(line, lineIndex + 1, exception.getCharacterIndex(), exception.getMessage()));
            }
        }
        return styleMap.build();
    }

    private static void handleLine(StyleMapBuilder styleMap, String line) {
        if (line.startsWith("#")) {
            return;
        }
        if ((line = line.trim()).isEmpty()) {
            return;
        }
        StyleMapParser.parseStyleMapping(line).accept(styleMap);
    }

    private static Consumer<StyleMapBuilder> parseStyleMapping(String line) {
        TokenIterator<TokenType> tokens = StyleMappingTokeniser.tokenise(line);
        BiConsumer<StyleMapBuilder, HtmlPath> documentMatcher = DocumentMatcherParser.parse(tokens);
        tokens.skip(TokenType.WHITESPACE);
        tokens.skip(TokenType.SYMBOL, "=>");
        HtmlPath htmlPath = StyleMapParser.parseHtmlPath(tokens);
        tokens.skip(TokenType.EOF);
        return styleMap -> documentMatcher.accept((StyleMapBuilder)styleMap, htmlPath);
    }

    private static HtmlPath parseHtmlPath(TokenIterator<TokenType> tokens) {
        if (tokens.peekTokenType() == TokenType.EOF) {
            return HtmlPath.EMPTY;
        }
        tokens.skip(TokenType.WHITESPACE);
        return HtmlPathParser.parse(tokens);
    }

    private static String generateErrorMessage(String line, int lineNumber, int characterIndex, String message) {
        return "error reading style map at line " + lineNumber + ", character " + (characterIndex + 1) + ": " + message + "\n\n" + line + "\n" + StyleMapParser.repeatString(" ", characterIndex) + "^";
    }

    private static String repeatString(String value, int times) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < times; ++i) {
            builder.append(value);
        }
        return builder.toString();
    }
}

