/*
 * Decompiled with CFR 0.152.
 */
package org.zwobble.mammoth.internal.styles;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.zwobble.mammoth.internal.documents.Break;
import org.zwobble.mammoth.internal.documents.Paragraph;
import org.zwobble.mammoth.internal.documents.Run;
import org.zwobble.mammoth.internal.documents.Table;
import org.zwobble.mammoth.internal.html.HtmlTag;
import org.zwobble.mammoth.internal.styles.HtmlPath;
import org.zwobble.mammoth.internal.styles.HtmlPathElement;
import org.zwobble.mammoth.internal.styles.HtmlPathElements;
import org.zwobble.mammoth.internal.styles.ParagraphMatcher;
import org.zwobble.mammoth.internal.styles.StyleMapBuilder;
import org.zwobble.mammoth.internal.styles.StyleMapping;
import org.zwobble.mammoth.internal.util.Iterables;
import org.zwobble.mammoth.internal.util.Lists;
import org.zwobble.mammoth.internal.util.Optionals;

public class StyleMap {
    public static final StyleMap EMPTY = new StyleMapBuilder().build();
    private final Optional<HtmlPath> bold;
    private final Optional<HtmlPath> italic;
    private final Optional<HtmlPath> underline;
    private final Optional<HtmlPath> strikethrough;
    private final Optional<HtmlPath> allCaps;
    private final Optional<HtmlPath> smallCaps;
    private final Optional<HtmlPath> commentReference;
    private final List<StyleMapping<Paragraph>> paragraphStyles;
    private final List<StyleMapping<Run>> runStyles;
    private final List<StyleMapping<Table>> tableStyles;
    private final List<StyleMapping<Break>> breakStyles;

    public static StyleMapBuilder builder() {
        return new StyleMapBuilder();
    }

    public static StyleMap merge(StyleMap high, StyleMap low) {
        return new StyleMap(Optionals.first(high.bold, low.bold), Optionals.first(high.italic, low.italic), Optionals.first(high.underline, low.underline), Optionals.first(high.strikethrough, low.strikethrough), Optionals.first(high.allCaps, low.allCaps), Optionals.first(high.smallCaps, low.smallCaps), Optionals.first(high.commentReference, low.commentReference), Lists.eagerConcat(high.paragraphStyles, low.paragraphStyles), Lists.eagerConcat(high.runStyles, low.runStyles), Lists.eagerConcat(high.tableStyles, low.tableStyles), Lists.eagerConcat(high.breakStyles, low.breakStyles));
    }

    public StyleMap(Optional<HtmlPath> bold, Optional<HtmlPath> italic, Optional<HtmlPath> underline, Optional<HtmlPath> strikethrough, Optional<HtmlPath> allCaps, Optional<HtmlPath> smallCaps, Optional<HtmlPath> commentReference, List<StyleMapping<Paragraph>> paragraphStyles, List<StyleMapping<Run>> runStyles, List<StyleMapping<Table>> tableStyles, List<StyleMapping<Break>> breakStyles) {
        this.bold = bold;
        this.italic = italic;
        this.underline = underline;
        this.strikethrough = strikethrough;
        this.allCaps = allCaps;
        this.smallCaps = smallCaps;
        this.commentReference = commentReference;
        this.paragraphStyles = paragraphStyles;
        this.runStyles = runStyles;
        this.tableStyles = tableStyles;
        this.breakStyles = breakStyles;
    }

    public StyleMap update(StyleMap styleMap) {
        return StyleMap.merge(styleMap, this);
    }

    public Optional<HtmlPath> getBold() {
        return this.bold;
    }

    public Optional<HtmlPath> getItalic() {
        return this.italic;
    }

    public Optional<HtmlPath> getUnderline() {
        return this.underline;
    }

    public Optional<HtmlPath> getStrikethrough() {
        return this.strikethrough;
    }

    public Optional<HtmlPath> getAllCaps() {
        return this.allCaps;
    }

    public Optional<HtmlPath> getSmallCaps() {
        return this.smallCaps;
    }

    public Optional<HtmlPath> getCommentReference() {
        return this.commentReference;
    }

    public Optional<HtmlPath> getParagraphHtmlPath(Paragraph paragraph) {
        StyleMapping<Paragraph> foundListMapping = null;
        StyleMapping<Paragraph> foundMapping = null;
        for (StyleMapping<Paragraph> paraStyle : this.paragraphStyles) {
            boolean isListStyleMatch;
            boolean matches = paraStyle.matches(paragraph);
            if (!matches) continue;
            boolean bl = isListStyleMatch = paraStyle.getMatcher() instanceof ParagraphMatcher && ((ParagraphMatcher)paraStyle.getMatcher()).getNumbering().isPresent();
            if (isListStyleMatch) {
                if (foundListMapping != null) continue;
                foundListMapping = paraStyle;
                continue;
            }
            foundMapping = paraStyle;
            break;
        }
        Optional<HtmlPath> htmlPath = Optional.empty();
        if (foundMapping != null) {
            HtmlPath foundPath = foundMapping.getHtmlPath();
            htmlPath = Optional.ofNullable(foundPath);
            if (this.isSimpleParagraphPath(foundPath) && foundListMapping != null) {
                htmlPath = Optional.ofNullable(foundListMapping.getHtmlPath());
            }
        } else if (foundListMapping != null) {
            htmlPath = Optional.ofNullable(foundListMapping.getHtmlPath());
        }
        if (paragraph.getNumbering().isPresent() && paragraph.getNumbering().get().isFirstItemNumbering()) {
            htmlPath = this.updatePathForFirstItem(htmlPath);
        }
        return htmlPath;
    }

    private boolean isSimpleParagraphPath(HtmlPath toCheck) {
        HtmlPathElements foundElementsPath;
        boolean isSimpleParaMapping = false;
        if (toCheck instanceof HtmlPathElements && (foundElementsPath = (HtmlPathElements)toCheck).getElements().size() == 1) {
            HtmlTag tag = foundElementsPath.getElements().get(0).getTag();
            isSimpleParaMapping = tag.getTagNames().size() == 1 && "p".equals(tag.getTagNames().get(0));
        }
        return isSimpleParaMapping;
    }

    private Optional<HtmlPath> updatePathForFirstItem(Optional<HtmlPath> htmlPath) {
        if (htmlPath.isPresent() && htmlPath.get() instanceof HtmlPathElements) {
            HtmlPathElements pathElements = (HtmlPathElements)htmlPath.get();
            ArrayList<HtmlPathElement> elements = new ArrayList<HtmlPathElement>(pathElements.getElements());
            for (int i = elements.size() - 1; i >= 0; --i) {
                HtmlTag tag = ((HtmlPathElement)elements.get(i)).getTag();
                if (!tag.getTagNames().contains("ol") && !tag.getTagNames().contains("ul")) continue;
                elements.set(i, new HtmlPathElement(new HtmlTag(tag.getTagNames(), tag.getAttributes(), false, tag.getSeparator())));
                break;
            }
            htmlPath = Optional.of(new HtmlPathElements(elements));
        }
        return htmlPath;
    }

    public Optional<HtmlPath> getRunHtmlPath(Run run) {
        return Iterables.tryFind(this.runStyles, styleMapping -> styleMapping.matches(run)).map(StyleMapping::getHtmlPath);
    }

    public Optional<HtmlPath> getTableHtmlPath(Table table) {
        return Iterables.tryFind(this.tableStyles, styleMapping -> styleMapping.matches(table)).map(StyleMapping::getHtmlPath);
    }

    public Optional<HtmlPath> getBreakHtmlPath(Break breakElement) {
        return Iterables.tryFind(this.breakStyles, styleMapping -> styleMapping.matches(breakElement)).map(StyleMapping::getHtmlPath);
    }
}

