/*
 * Decompiled with CFR 0.152.
 */
package org.zwobble.mammoth.internal.docx;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.zwobble.mammoth.internal.xml.XmlElement;

public class TableContext {
    private List<XmlElement> unhandledBookmarks = new ArrayList<XmlElement>();
    private Set<String> processedBookmarks = new HashSet<String>();
    private boolean isTableCellContext = false;

    public void addUnhandledBookmarks(List<XmlElement> bookmark) {
        this.unhandledBookmarks.addAll(bookmark);
    }

    public void addUnhandledBookmark(XmlElement bookmark) {
        this.unhandledBookmarks.add(bookmark);
    }

    public List<XmlElement> getUnhandledBookmarks() {
        return this.unhandledBookmarks;
    }

    public void clearUnhandledBookmarks() {
        this.unhandledBookmarks.clear();
    }

    public boolean isInTableCellContext() {
        return this.isTableCellContext;
    }

    public void setTableCellContext(boolean isTableCellContext) {
        this.isTableCellContext = isTableCellContext;
    }

    public boolean isProcessedBookmark(XmlElement element) {
        Optional<String> id = element.getAttributeOrNone("w:id");
        return id.isPresent() && this.processedBookmarks.contains(id.get());
    }

    public void addProcessedBookmark(XmlElement processedBookmark) {
        Optional<String> idAttr = processedBookmark.getAttributeOrNone("w:id");
        if (idAttr.isPresent()) {
            this.processedBookmarks.add(idAttr.get());
        }
    }
}

